package jp.kirikiri.tvp2;

import java.util.Properties;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.base.ScriptsClass;
import jp.kirikiri.tvp2.base.SystemInitializer;
import jp.kirikiri.tvp2.base.TVPSystem;
import jp.kirikiri.tvp2.env.ApplicationSystem;
import jp.kirikiri.tvp2.env.EventHandleThread;
import jp.kirikiri.tvp2.utils.DebugClass;

class Main {

    public static void main(String[] args) {
    	processArg( args );
		try {
			ApplicationSystem app = new ApplicationSystem(); // 自分でTVPに登録する
			TVP.initialize();
			ScriptsClass.initScriptEnging();

			// banner
			DebugClass.addImportantLog( "Program started on " + TVPSystem.getOSName() );
			DebugClass.addImportantLog( "JVM : " + TVPSystem.getJVMName() );
			DebugClass.addImportantLog( "JRE : " + TVPSystem.getJREName() );

			SystemInitializer.systemInitialize();
			ScriptsClass.initializeStartupScript();
			EventHandleThread t = new EventHandleThread();
			t.start();
		} catch (VariantException e) {
			TVP.DebugLog.onError();
			e.printStackTrace();
		} catch (TJSException e) {
			TVP.DebugLog.onError();
			e.printStackTrace();
		} catch( Exception e ) {
			TVP.DebugLog.onError();
			e.printStackTrace();
		}
	}
	private static void processArg( String[] args ) {
		TVP.Properties = new Properties();
		final int count = args.length;
		for( int i = 0; i < count; i++ ) {
			String arg = args[i];
			if( arg.charAt(0) == '-' ) {
				String name = arg.substring(1);
				int index = name.indexOf('=');
				if( index != -1 && name.length() > (index+1) ) {
					String value = name.substring(index+1);
					name = name.substring(0,index);
					TVP.Properties.setProperty(name, value);
				} else {
					TVP.Properties.setProperty(name, "no value" );
				}
			}
		}
	}
}
