package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;

public class Event implements Runnable {

	static private final int
		E_NOTIMPL		= -1002,
		S_TRUE			= 1;

	private Dispatch2 mTarget;
	private Dispatch2 mSource;
	private String mEventName;
	private int mTag;
	private Variant[] mArgs;
	private int mFlags;
	private long mSequence;

	public Event( Dispatch2 target, Dispatch2 source, String eventname, int tag, Variant[] args, int flags ) {
		// constructor
		// eventname is not a const object but this object only touch to
		// eventname.GetHint()
		mArgs = null;
		mTarget = null;
		mSource = null;

		mSequence = TVP.EventManager.getSequenceNumber();
		mEventName = eventname;
		final int count = args.length;
		mArgs = new Variant[count];
		for( int i = 0; i < count; i++ ) {
			mArgs[i] = new Variant(args[i]);
		}
		mTarget = target;
		mSource = source;
		mTag = tag;
		mFlags = flags;
	}


	public Event( final Event ref ){
		// copy constructor
		mArgs = null;
		mTarget = null;
		mSource = null;

		mEventName = ref.mEventName;
		final int count = ref.mArgs.length;
		mArgs = new Variant[count];
		for( int i = 0; i < count; i++ ) {
			mArgs[i] = new Variant( ref.mArgs[i] );
		}
		mTarget = ref.mTarget;
		mSource = ref.mSource;
		mTag = ref.mTag;
	}

	protected void finalize() {
		mArgs = null;
		mTarget = null;
		mSource = null;
	}

	public void deliver() throws VariantException, TJSException {
		int hr = mTarget.isValid(0, null, mTarget);
		if( hr != S_TRUE && hr != E_NOTIMPL ) return; // The target had been invalidated
		mTarget.funcCall( 0, mEventName, null, mArgs, mTarget );
	}

	@Override
	public void run() {
		try {
			deliver();
		} catch (VariantException e) {
		} catch (TJSException e) {
		}
	}
	static public void immediate( Dispatch2 target, Dispatch2 source, String eventname, int tag, Variant[] args, int flags ) throws VariantException, TJSException {
		int hr = target.isValid(0, null, target);
		if( hr != S_TRUE && hr != E_NOTIMPL ) return; // The target had been invalidated
		target.funcCall( 0, eventname, null, args, target );
	}


	public Dispatch2 getTarget() { return mTarget; }
	public Dispatch2 getSource() { return mSource; }
	public final String getEventName() { return mEventName; }
	public int getTag() { return mTag; }
	public int getFlags() { return mFlags; }
	public long getSequence() { return mSequence; }

}
