package jp.kirikiri.tvp2.env;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.GraphicsLoader;


public class ImagePanel extends JPanel {

	/**
	 *
	 */
	private static final long serialVersionUID = 7393364494465761702L;

	private VRAMImageBuffer mImageBuffer;	// VRAMバッファ
	private PanelDrawListener mDraw;

	private NativeImageBuffer mImage;

	//コンストラクタ
	public ImagePanel() {
		mImageBuffer = new VRAMImageBuffer(this);
		mImage = new NativeImageBuffer(32,32);
	}
	@Override
	public void setSize(int w, int h ) {
		super.setSize(w,h);
		try {
			mImage.recreate(w, h, true);
			if( mDraw != null ) {
				Image img = mImage.getImage();
				if( img != null ) {
					mDraw.onDraw( img.getGraphics() );
				}
			}
		} catch (TJSException e) {
		}
	}
	/*
	public Graphics getTargetGraphics() {
		return mImage.getImage().getGraphics();
	}
	*/
	/*
	private void loadImage() {
		BaseBitmap bmp = new BaseBitmap(32,32,32);
		try {
			GraphicsLoader.loadGraphic( bmp, "kaname_kira.png", 0, 0, 0, GraphicsLoader.glmNormal, null );
		} catch (TJSException e) {
		}
		mTestImage = (BufferedImage) bmp.getBitmap().getImage();
	}
	*/

	// 画面の描画処理
	protected void paintComponent( Graphics graphic ) {
		// ダブルバッファ用イメージの初期化
		mImageBuffer.initializeVolatileImage();
		try {
			do {
				// ダブルバッファ用イメージのチェック
				mImageBuffer.validateVolatileImage();

				// バッファのグラフィックスオブジェクトを取得
				Graphics buffer = mImageBuffer.getGraphics();

				// 親クラスの描画処理を呼びだす
				// super.paintComponent(buffer); 余計な塗りつぶしをなくす

				// 具体的な描画処理を入れる
				buffer.drawImage(mImage.getImage(), 0, 0, null );

				// グラフィックスオブジェクトを破棄する
				buffer.dispose();

				// バッファのイメージを実際に描画する
				graphic.drawImage(mImageBuffer.getImage(),0,0,this);

				// バッファ内容が失われたら再描画させる
			} while( mImageBuffer.isContentsLost() );
		} catch( NullPointerException ex ){
			// VolatileImageのアクセス中に例外が発生することがあるので、ここでキャッチしておく
		}
	}
	public void setDrawListener( PanelDrawListener draw ) {
		mDraw = draw;
		//if( mDraw != null ) mDraw.onDraw( mImage.getImage().getGraphics() );
	}
}
