package jp.kirikiri.tjs2;

public abstract class NativeClassProperty extends Dispatch {

	public int isInstanceOf( int flag, final String membername, final String classname, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername == null ) {
			if( "Property".equals(classname) ) return Error.S_TRUE;
		}
		return super.isInstanceOf(flag, membername, classname, objthis);
	}
	public int propGet( int flag, final String membername, Variant result, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.propGet( flag, membername, result, objthis );
		if( objthis == null ) return Error.E_NATIVECLASSCRASH;
		if( result == null ) return Error.E_FAIL;

		return get( result, objthis );
	}
	public int propSet( int flag, final String membername, final Variant param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.propSet(flag, membername, param, objthis);
		if( objthis == null ) return Error.E_NATIVECLASSCRASH;
		if( param == null ) return Error.E_FAIL;

		return set( param, objthis );
	}

	abstract public int get( Variant result, Dispatch2 objthis ) throws TJSException;
	abstract public int set( Variant param, Dispatch2 objthis ) throws VariantException, TJSException;
}
