package jp.kirikiri.tvp2env;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

import javax.imageio.ImageIO;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.GraphicsLoader;


public class NativeImageLoader {

	static public BufferedImage loadImage( InputStream stream ) {
		try {
			BufferedImage img = null;
			img = ImageIO.read(stream);
			return img;
		} catch (IOException e) {
			return null;
		}
	}

	static public NativeImageBuffer loadImage( BinaryStream stream, final String ext, HashMap<String,String> metainfo, int keyidx, int mode ) throws TJSException {
		BufferedImage img = null;
		if( ".tlg".equalsIgnoreCase(ext) || ".tlg5".equalsIgnoreCase(ext ) || ".tlg6".equalsIgnoreCase(ext ) ) {
			img = TLGLoader.loadTLG(stream, mode, metainfo );
		}
		/** test */
		/*
		if( ".png".equalsIgnoreCase(ext) ) {
			img = PNGLoader.loadPNG(stream, mode);
			return new NativeImageBuffer(img);
			// stream.setPosition(0);
		}
		*/
		/** test */
		if( img == null ) {
			try {
				img = ImageIO.read(stream.getInputStream());
			} catch (IOException e) {
			}
		}
		if( img == null ) return null;

		if( GraphicsLoader.glmNormal == mode ) {
			/*
			if( img.getType() != BufferedImage.TYPE_INT_ARGB_PRE ) {
				if( img.getType() == BufferedImage.TYPE_INT_ARGB ) {
					img.coerceData(true); // alpha 乗算
				} else {
					// 常に変換するようにしてみる、DataBuffer は int になるので、自前で処理するのは速くなる
					BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), BufferedImage.TYPE_INT_ARGB_PRE );
					Graphics2D g = img2.createGraphics();
					g.drawImage(img, 0, 0, null );
					g.dispose();
					img = img2;
				}
			}
			*/
			final int imgType = img.getType();
			if( imgType != BufferedImage.TYPE_INT_ARGB && imgType != BufferedImage.TYPE_INT_ARGB_PRE ) {
				int transparentColor = -1;
				if( imgType == BufferedImage.TYPE_BYTE_INDEXED && keyidx != -1 ) {
					ColorModel model = img.getColorModel();
					if( model instanceof IndexColorModel ) {
						IndexColorModel indexColor = (IndexColorModel)model;
						int indexSize = indexColor.getMapSize();
						int[] palette = new int[indexSize];
						indexColor.getRGBs(palette);
						if( keyidx < palette.length ) {
							transparentColor = palette[keyidx];
						}
					}
				}
				// 常に変換するようにしてみる、DataBuffer は int になるので、自前で処理するのは速くなる
				BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), BufferedImage.TYPE_INT_ARGB );
				Graphics2D g = img2.createGraphics();
				g.drawImage(img, 0, 0, null );
				g.dispose();
				img = img2;
				if( transparentColor != -1 ) {
					WritableRaster src = img.getRaster();
					DataBuffer buff = src.getDataBuffer();
					final int type = buff.getDataType();
					if( type == DataBuffer.TYPE_INT ) {
						DataBufferInt srcBuff = (DataBufferInt)buff;
						int[] s = srcBuff.getData();
						final int color = transparentColor & 0x00ffffff;
						final int count = s.length;
						for( int i = 0; i < count; i++ ) {
							int a = s[i] & 0x00ffffff;
							if( a != color ) a |= 0xff000000;
							s[i] = a;
						}
						s = null;
						srcBuff = null;
					}
					buff = null;
					src = null;
				}
			}
		} else if( mode == GraphicsLoader.glmPalettized ) {
			if( img.getType() != BufferedImage.TYPE_BYTE_INDEXED ) {
				Message.throwExceptionMessage( Message.ImageLoadError, "Unsupported color mode for palettized image.");
			}
		}
		return new NativeImageBuffer(img);
	}
}
