/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;

public class Event implements Runnable {

	private Dispatch2 mTarget;
	private Dispatch2 mSource;
	private String mEventName;
	private int mTag;
	private Variant[] mArgs;
	private int mFlags;
	private long mSequence;

	public Event( Dispatch2 target, Dispatch2 source, String eventname, int tag, Variant[] args, int flags ) {
		// constructor
		// eventname is not a const object but this object only touch to
		// eventname.GetHint()
		//mArgs = null;
		//mTarget = null;
		//mSource = null;

		mSequence = TVP.EventManager.getSequenceNumber();
		mEventName = eventname;
		final int count = args.length;
		mArgs = new Variant[count];
		for( int i = 0; i < count; i++ ) {
			mArgs[i] = new Variant(args[i]);
		}
		mTarget = target;
		mSource = source;
		mTag = tag;
		mFlags = flags;
	}


	public Event( final Event ref ){
		// copy constructor
		//mArgs = null;
		//mTarget = null;
		//mSource = null;

		mEventName = ref.mEventName;
		final int count = ref.mArgs.length;
		mArgs = new Variant[count];
		for( int i = 0; i < count; i++ ) {
			mArgs[i] = new Variant( ref.mArgs[i] );
		}
		mTarget = ref.mTarget;
		mSource = ref.mSource;
		mTag = ref.mTag;
	}

	/*
	protected void finalize() {
		mArgs = null;
		mTarget = null;
		mSource = null;
	}
	*/

	public void deliver() throws VariantException, TJSException {
		int hr = mTarget.isValid(0, null, mTarget);
		if( hr != Error.S_TRUE && hr != Error.E_NOTIMPL ) return; // The target had been invalidated
		mTarget.funcCall( 0, mEventName, null, mArgs, mTarget );
	}

	@Override
	public void run() {
		try {
			deliver();
		} catch (VariantException e) {
		} catch (TJSException e) {
		}
	}
	static public void immediate( Dispatch2 target, Dispatch2 source, String eventname, int tag, Variant[] args, int flags ) throws VariantException, TJSException {
		int hr = target.isValid(0, null, target);
		if( hr != Error.S_TRUE && hr != Error.E_NOTIMPL ) return; // The target had been invalidated
		target.funcCall( 0, eventname, null, args, target );
	}


	public Dispatch2 getTarget() { return mTarget; }
	public Dispatch2 getSource() { return mSource; }
	public final String getEventName() { return mEventName; }
	public int getTag() { return mTag; }
	public int getFlags() { return mFlags; }
	public long getSequence() { return mSequence; }

}
