/**
 *
 */
package jp.kirikiri.tvp2env;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URL;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.utils.DebugClass;

/**
 * オリジナルとは異なり、Window等の実態を持たないクラス
 *
 */
public class MainForm {

	private long mLastCompactedTick;
	private long mLastContinuousTick;
	private long mLastCloseClickedTick;
	private long mLastShowModalWindowSentTick;
	private long mLastRehashedTick;
	private long mMixedIdleTick;
	private boolean mContinuousEventCalling;
	private boolean mAutoShowConsoleOnError;
	private boolean mApplicationStayOnTop;
	private boolean mApplicationActivating;
	private boolean mApplicationNotMinimizing;
	private String mClassPath;
	private String mExeName;

	public MainForm() {
		mContinuousEventCalling = false;
		mAutoShowConsoleOnError = false;
		mApplicationStayOnTop = false;
		mApplicationActivating = true;
		mApplicationNotMinimizing = true;

		long tick = TVP.getTickCount();
		mLastCompactedTick = tick;
		mLastContinuousTick = tick;
		mLastCloseClickedTick = tick;
		mLastShowModalWindowSentTick = tick;
		mLastRehashedTick = tick;
		mMixedIdleTick = tick;


	}
	public void invokeEvents() {
		callDeliverAllEventsOnIdle();
	}

	public void notifyEventDelivered() {
		// called from event system, notifying the event is delivered.
		mLastCloseClickedTick = 0;
		//if(TVPHaltWarnForm) delete TVPHaltWarnForm, TVPHaltWarnForm = NULL;
	}

	public void callDeliverAllEventsOnIdle() {
		//::PostMessage(TVPMainForm->Handle, WM_USER+0x31/*dummy msg*/, 0, 0);
		// indirectly called by TVPInvokeEvents  *** currently not used ***
		//if(EventButton->Down)
		/*
		{		// TODO 仮で呼んでおく
			TVP.EventManager.deliverAllEvents();
		}
		*/
	}

	/**
	 * クラスパスとjarのパスを取得する
	 * TODO Androidだとどうするか……
	 */
	private void retrieveClassPath() {
		try {
			Class<? extends MainForm> c = this.getClass();
			URL u = c.getResource(c.getSimpleName() + ".class");
			mClassPath = u.toString();
			int delimiPos = mClassPath.indexOf('!');
			String name;
			if( delimiPos >= 0 ) {
				name = mClassPath.substring(0,delimiPos);
			} else {
				name = mClassPath;
			}
			if( name.indexOf("jar:file:/") >= 0 ) {
				name = name.substring("jar:file:/".length());
			}
			mExeName = TVP.StorageMediaManager.normalizeStorageName(name, null);
		} catch( NullPointerException e ) {
			mClassPath = System.getProperty("user.dir");
			mExeName = mClassPath;
		} catch (TJSException e) {
			mClassPath = System.getProperty("user.dir");
			mExeName = mClassPath;
		}
	}
	public String getClassPath() {
		if( mClassPath == null ) {
			retrieveClassPath();
		}
		return mClassPath;
	}
	public String getExeName() {
		if( mExeName == null ) {
			retrieveClassPath();
		}
		return mExeName;
	}

	public void beginContinuousEvent() {
		if(!mContinuousEventCalling) {
			mContinuousEventCalling = true;
			invokeEvents();
		}
	}

	public void endContinuousEvent() {
		if(mContinuousEventCalling) {
			mContinuousEventCalling = false;
		}
	}
	public boolean applicationIdle() {
		deliverEvents();
		boolean cont = mContinuousEventCalling;
		mMixedIdleTick += TVP.getTickCount();
		return cont;
	}
	private void deliverEvents() {
		if( mContinuousEventCalling )
			TVP.EventManager.setProcessContinuousHandlerEventFlag(true); // set flag

		//if(EventButton->Down) TVPDeliverAllEvents();
		TVP.EventManager.deliverAllEvents();
	}

	public int getScreenWidth() {
		GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice device = graphicsEnvironment.getDefaultScreenDevice();
		return device.getDisplayMode().getWidth();
	}
	public int getScreenHeight() {
		GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice device = graphicsEnvironment.getDefaultScreenDevice();
		return device.getDisplayMode().getHeight();
	}
	public int getDesktopHeight() {
		GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
		return rect.height;
	}
	public int getDesktopLeft() {
		GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
		return rect.x;
	}
	public int getDesktopTop() {
		GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
		return rect.y;
	}
	public int getDesktopWidth() {
		GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
		return rect.width;
	}
}
