package jp.kirikiri.tvp2;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.base.ScriptsClass;
import jp.kirikiri.tvp2.base.SystemInitializer;
import jp.kirikiri.tvp2.base.TVPSystem;
import jp.kirikiri.tvp2.utils.DebugClass;

class Main {

    public static void main(String[] args) {
/*
    	TJS tjs = new TJS();
    	String script = "c = (a=1, b=2)";
    	PreprocessorExpressionParser parser = new PreprocessorExpressionParser( tjs, script );
    	int result = -1;
		try {
			result = parser.parse();
		} catch (CompileException e) {
			e.printStackTrace();
		}
    	System.out.println("result:" + result);
*/

		try {
			TVP.initialize();
			ScriptsClass.initScriptEnging();

			// banner
			DebugClass.addImportantLog( "Program started on " + TVPSystem.getOSName() );
			DebugClass.addImportantLog( "JVM : " + TVPSystem.getJVMName() );
			DebugClass.addImportantLog( "JRE : " + TVPSystem.getJREName() );

			SystemInitializer.systemInitialize();
			ScriptsClass.executeStartupScript();
		} catch (VariantException e) {
			e.printStackTrace();
		} catch (TJSException e) {
			e.printStackTrace();
		}
    }
}
