package jp.kirikiri.tvp2.env;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

import jp.kirikiri.tvp2.visual.DivisibleData;

/**
 * 表画面が回転しながら遠ざかり、裏画面が回転しながら近寄るトランジション
 *
 * オリジナルでは、遠ざかる時水平方向に少し倒れたようになるが、これは手前を向いたままなので、少し見た目が違う。
 */
public class RotateSwapTransHandler extends BaseRotateTransHandler {

	private boolean mSrc1First; // src1 を先に描画するかどうか

	private AffineTransform mSrc1Mat;
	private AffineTransform mSrc2Mat;
	private float mTwist;
	private Color mBGColorObj;

	public RotateSwapTransHandler(long time, int width, int height, int bgcolor, double twist ) {
		super(time, width, height, bgcolor);
		mTwist = (float) (twist * Math.PI * 2.0);
		mBGColorObj = new Color( bgcolor|0xff000000, true );
	}

	@Override
	public int process(DivisibleData data) {
		BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
		BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
		BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
		final int destLeft = data.DestLeft;
		final int src1Left = data.Src1Left;
		final int src2Left = data.Src2Left;
		final int h = data.Height;
		final int w = data.Width;
		final int destTop = data.DestTop;
		final int src1Top = data.Src1Top;
		final int src2Top = data.Src2Top;

		Graphics2D g = (Graphics2D)dest.getGraphics();
		g.setRenderingHint(RenderingHints.KEY_INTERPOLATION , RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR ); // ニアレストネイバー
		g.setComposite( AlphaComposite.Src );
		g.setColor( mBGColorObj );
		g.fillRect( destLeft, destTop, w, h );

		g.setTransform(mSrc1Mat);
		if( mSrc1First ) {
			g.drawImage( src1, destLeft, destTop, destLeft+w, destTop+h, src1Left, src1Top, src1Left+w, src1Top+h, null );
		} else {
			g.drawImage( src2, destLeft, destTop, destLeft+w, destTop+h, src1Left, src1Top, src1Left+w, src1Top+h, null );
		}

		g.setTransform(mSrc2Mat);
		if( mSrc1First ) {
			g.drawImage( src2, destLeft, destTop, destLeft+w, destTop+h, src2Left, src2Top, src2Left+w, src2Top+h, null );
		} else {
			g.drawImage( src1, destLeft, destTop, destLeft+w, destTop+h, src2Left, src2Top, src2Left+w, src2Top+h, null );
		}
		g.dispose();

		return S_OK;
	}

	@Override
	void calcPosition() {
		float rad;
		float cx, cy;
		final int scx = mWidth/2;
		final int scy = mHeight/2;
		final float zm = (float)(int)mCurTime / (float)(int)mTime;
		float tm;//, s, c;
		mSrc1First = ( mCurTime >= mTime / 2 );

		// src1
		tm = zm * zm;
		cx = (float) (( - scx ) * tm + scx + Math.sin(tm * Math.PI)*scx*1.5f);
		cy = ( - scy ) * tm + scy;
		rad = tm * mTwist;
		tm = 1.0f - tm;
		//s = (float) (Math.sin(rad) * tm);
		//c = (float) (Math.cos(rad) * tm);
		AffineTransform mat;
		AffineTransform rot = AffineTransform.getRotateInstance( -rad, cx, cy );
		AffineTransform scale = AffineTransform.getScaleInstance(tm, tm);
		scale.concatenate(rot);
		if( tm != 0.0f && tm != 1.0f ) {
			cx = cx - cx * tm;
			cy = cy - cy * tm;
			AffineTransform trans = AffineTransform.getTranslateInstance(cx, cy);
			trans.concatenate(scale);
			mat = trans;
		} else {
			mat = scale;
		}
		if( mSrc1First ) {
			mSrc1Mat = mat;
		} else {
			mSrc2Mat = mat;
		}

		// src2
		tm = 1.0f - (1.0f - zm) * (1.0f - zm);
		cx = (float) ((scx - (mWidth  - 1)) * tm + (mWidth  - 1) - Math.sin(tm * Math.PI) * scx*1.5f);
		cy = (scy - (mHeight - 1)) * tm + (mHeight - 1);
		rad = (-1.0f + tm) * mTwist;
		//s = sin(rad) * tm;
		//c = cos(rad) * tm;
		rot = AffineTransform.getRotateInstance( -rad, cx, cy );
		scale = AffineTransform.getScaleInstance(tm, tm);
		scale.concatenate(rot);
		if( tm != 0.0f && tm != 1.0f ) {
			cx = cx - cx * tm;
			cy = cy - cy * tm;
			AffineTransform trans = AffineTransform.getTranslateInstance(cx, cy);
			trans.concatenate(scale);
			mat = trans;
		} else {
			mat = scale;
		}
		if( mSrc1First ) {
			mSrc2Mat = mat;
		} else {
			mSrc1Mat = mat;
		}
	}

}
