#ifndef __GLOBALS_H__
#define __GLOBALS_H__

// Global constants

const	QString	uPnPAddress = "239.255.255.250";	// UPnP multicast address
const	quint16	uPnPPort = 1900;					// UPnP multicast port
const	QString	uPnPRequest = "M-SEARCH * HTTP/1.1\r\n\
Host: 239.255.255.250:1900\r\n\
Man: \"ssdp:discover\"\r\n\
ST: urn:schemas-upnp-org:device:MediaServer:1\r\n\
MX: 3\r\n\r\n";

// File extension
const	QString	videoInfoExt = ".ifo";
const	QString	videoFileExt = ".ts";

// Timer interval
const	int	discoverTimeout = 3000;		// msec
const	int	progressInterval = 1000;	// msec

// struct

struct	serverInfo
{
	QString	info;
	QString	descUrl;
};

struct	videoInfo
{
	QString	id;
	QString	title;
	QString	datetime;
	QString	duration;
	QString	channel;
	QString	url;
	QString	size;
	QString	bitrate;
	
};
#endif // __GLOBALS_H__
