#include "serverdialogimpl.h"

// place your code here

serverDialogImpl::serverDialogImpl(QList<serverInfo*>	*list, QWidget	*parent, Qt::WFlags	f)
	: QDialog(parent, f)
{
	setupUi(this);
	
	QStandardItemModel	*model = new QStandardItemModel;
	QStringList	header;
	header.append(QString("Server info"));
	header.append(QString("IP address"));
	model->setHorizontalHeaderLabels(header);
	QList<serverInfo*>::iterator	iter = list->begin();
	for(int	i = 0; iter != list->end(); i++)
	{
		serverInfo	*info = *iter;
		model->setItem(i, 0, new QStandardItem(info->info));
		QUrl	url(info->descUrl);
		model->setItem(i, 1, new QStandardItem(url.host()));
		iter++;
	}
	serverListView->setModel(model);
	serverListView->resizeColumnsToContents();
}
