#include "led.h"
#include "defines.h"
#include "portconf.h"

int led_init(void)
{
  volatile uint8 mask = PORTCONF_PABIT_LED1 | PORTCONF_PABIT_LED2 | PORTCONF_PABIT_LEDG | PORTCONF_PABIT_LEDR;

  /*
   * ݡȥǥ쥯ꤹ˥ǡ쥸롣
   * ʤΤǡͤΥȽϤˤ֤Ȥʤ롣
   */
  *PORTCONF_PADR |= mask;

  /*
   * ݡAΥӥå2,3,6,7ϽϥݡȤȤꤹ롣
   *
   * ǡǥ쥯쥸Write OnlyʤΤǡ
   * ¾ΥӥåȤ꤬ɬפˤʤäǡ
   * ݡޤȤƴ褦
   * 餫кɬפȤʤ
   */
  *PORTCONF_PADDR = 0xCC;

  return 0;
}

int led_write(led_target_t target, led_state_t state)
{
  volatile uint8 mask = 0x00;

  switch (target) {
    case Led1:
      mask = PORTCONF_PABIT_LED1;
      break;
    case Led2:
      mask = PORTCONF_PABIT_LED2;
      break;
    case LedG:
      mask = PORTCONF_PABIT_LEDG;
      break;
    case LedR:
      mask = PORTCONF_PABIT_LEDR;
      break;
    default:
      return -1;
  }

  switch (state) {
    case LedOn:
      *PORTCONF_PADR &= ~mask;
      break;
    case LedOff:
      *PORTCONF_PADR |= mask;
      break;
    default:
      return -1;
  }

  return 0;
}

int led_toggle(led_target_t target)
{
  volatile uint8 mask = 0x00;

  switch (target) {
    case Led1:
      mask = PORTCONF_PABIT_LED1;
      break;
    case Led2:
      mask = PORTCONF_PABIT_LED2;
      break;
    case LedG:
      mask = PORTCONF_PABIT_LEDG;
      break;
    case LedR:
      mask = PORTCONF_PABIT_LEDR;
      break;
    default:
      return -1;
  }

  if (*PORTCONF_PADR & mask) {
    *PORTCONF_PADR &= ~mask;
  } else {
    *PORTCONF_PADR |= mask;
  }

  return 0;
}

