#!/bin/sh

#
# KOZOS IPC Relationship Visualization Tool (Version 0.0.1)
# Copyright(C) 2012 Shinichiro Nakamura (CuBeatSystems)
#

#
# 処理を実際に行うタスクはtask_xxx.c行う
# タスクはMSGBOX経由で仕事の依頼を受ける
# MSGBOXへの仕事依頼はipc_xxx.cが行う(task_xxx.cのフロントエンドとして機能)
# 仕事の依頼はtask_xxx.cがipc_xxx.cのインターフェースを使って行う
#

#
# 定義
#
TARGET_SENDTASK="task_*.c ipc_*.c"
TARGET_RECVTASK="task_*.c"
KXSEND_TEMPFILE=`mktemp kxsend.XXX`
KZSEND_TEMPFILE=`mktemp kzsend.XXX`
KZRECV_TEMPFILE=`mktemp kzrecv.XXX`
IPCLST_TEMPFILE=`mktemp ipclst.XXX`
IPCLST_WORKFILE=`mktemp ipcwrk.XXX`
DOTFILE="ipcmap.dot"
IMGFILE="ipcmap.png"

#
# Init
#
echo "" > $DOTFILE
echo "" > $IPCLST_TEMPFILE

#
# kx_sendとkz_sendとkz_recvの情報を一時ファイルに格納する
#
grep kx_send $TARGET_SENDTASK | \
  sed "s/kx_send(//" | sed "s/[\:,]//g" | sed "s/\.c//g" | \
  awk '{ print "\"" $1 "\"" " -> " "\"" $2 "\"" }' > $KXSEND_TEMPFILE
grep kz_send $TARGET_SENDTASK | \
  sed "s/kz_send(//" | sed "s/[\:,]//g" | sed "s/\.c//g" | \
  awk '{ print "\"" $1 "\"" " -> " "\"" $2 "\"" }' > $KZSEND_TEMPFILE
grep kz_recv $TARGET_RECVTASK | \
  sed "s/kz_recv(//" | sed "s/[\:,]//g" | sed "s/\.c//g" | \
  awk '{ print "\"" $2 "\"" " -> " "\"" $1 "\"" }' > $KZRECV_TEMPFILE

#
# バナー
#
echo "// Generated by KOZOS IPC Relationship Visualization Tool" >> $DOTFILE
echo "// Copyright(C) 2012 Shinichiro Nakamura (CuBeatSystems) " >> $DOTFILE
echo "" >> $DOTFILE

#
# ヘッダ
#
echo "digraph relationship {" >> $DOTFILE
echo "" >> $DOTFILE
echo "  // Global configurations" >> $DOTFILE
echo "  graph [size = \"16.0, 16.0\", label = \"KOZOS IPC Relationship Visualization\", labelloc = t, rankdir = LR];" >> $DOTFILE
echo "" >> $DOTFILE

#
# kx_sendとメッセージボックスの関係を記す
#
echo "  // kx_send" >> $DOTFILE
while read LINE
do
  #
  # kx_sendを使ってMSGBOXに送信している箇所を抽出する
  #
  EVTSND=`echo $LINE | sed "s/\.c//g" | awk '{ print $1 }'`
  MSGBOX=`echo $LINE | awk '{ print $3 }'`
  echo "  "$EVTSND" [style = dashed];" >> $DOTFILE
  echo "  "$MSGBOX" [shape = box];" >> $DOTFILE
  echo "  "$LINE";" >> $DOTFILE
  #
  #
  #
  IPCFILE=`echo $EVTSND | sed "s/[\:\"]/ /g" | awk '{ print $1 }'`
  FLIST=`ls -1 $TARGET_SENDTASK`
  for F in $FLIST
  do
    IPCIF=`echo $IPCFILE | sed "s/$/_/g"`
    grep $IPCIF $F | sed "s/^/$F,$IPCIF,/" >> $IPCLST_TEMPFILE
  done
done < $KXSEND_TEMPFILE
echo "" >> $DOTFILE

#
# kz_sendとメッセージボックスの関係を記す
#
echo "  // kz_send" >> $DOTFILE
while read LINE
do
  #
  # kz_sendを使ってMSGBOXに送信している箇所を抽出する
  #
  EVTSND=`echo $LINE | sed "s/\.c//g" | awk '{ print $1 }'`
  MSGBOX=`echo $LINE | awk '{ print $3 }'`
  echo "  "$EVTSND" [style = solid];" >> $DOTFILE
  echo "  "$MSGBOX" [shape = box];" >> $DOTFILE
  echo "  "$LINE";" >> $DOTFILE
  #
  #
  #
  IPCFILE=`echo $EVTSND | sed "s/[\:\"]/ /g" | awk '{ print $1 }'`
  FLIST=`ls -1 $TARGET_SENDTASK`
  for F in $FLIST
  do
    IPCIF=`echo $IPCFILE | sed "s/$/_/g"`
    grep $IPCIF $F | sed "s/^/$F,$IPCIF,/" >> $IPCLST_TEMPFILE
  done
done < $KZSEND_TEMPFILE
echo "" >> $DOTFILE

#
# kz_recvとメッセージボックスの関係を記す
#
echo "  // kz_recv" >> $DOTFILE
while read LINE
do
  #
  # kz_recvを使ってMSGBOXから受信している箇所を抽出する
  #
  MSGBOX=`echo $LINE | awk '{ print $1 }'`
  EVTRCV=`echo $LINE | sed "s/\.c//g" | awk '{ print $1 }'`
  echo "  "$MSGBOX" [shape = box];" >> $DOTFILE
  echo "  "$EVTRCV" [style = solid];" >> $DOTFILE
  echo "  "$LINE";" >> $DOTFILE
done < $KZRECV_TEMPFILE
echo "" >> $DOTFILE

#
# IPCインターフェースを使っているタスクの関係性を列挙する
#
sort $IPCLST_TEMPFILE | uniq | sed '/^$/d' > $IPCLST_WORKFILE
echo "  // IPC interface" >> $DOTFILE
while read LINE
do
  SRCIF=`echo $LINE | sed "s/,/ /g" | awk '{ print $1 }' | sed "s/\.c//g"`
  DESIF=`echo $LINE | sed "s/,/ /g" | awk '{ print $2 }' | sed "s/_$//g"`
  if [ ! "$SRCIF" = "$DESIF" ]
  then
    echo "  \""$SRCIF"\" -> \""$DESIF"\";" >> $DOTFILE
  fi
done < $IPCLST_WORKFILE

#
# テイラー
#
echo "}" >> $DOTFILE
echo "" >> $DOTFILE

#
# 一時ファイルを削除する
#
rm $KXSEND_TEMPFILE
rm $KZSEND_TEMPFILE
rm $KZRECV_TEMPFILE
rm $IPCLST_TEMPFILE
rm $IPCLST_WORKFILE

#
# Graphviz/dotでグラフを描画する
#
dot -T png $DOTFILE -o $IMGFILE

