#include "led.h"
#include "defines.h"

#define H8_3069F_PADDR  ((volatile uint8 *)0xFEE009)
#define H8_3069F_PADR   ((volatile uint8 *)0xFFFFD9)

#define MASK_LEDG   (1 << 2)
#define MASK_LEDR   (1 << 3)
#define MASK_LED1   (1 << 6)
#define MASK_LED2   (1 << 7)

int led_init(void)
{
  volatile uint8 mask = MASK_LED1 | MASK_LED2 | MASK_LEDG | MASK_LEDR;

  /*
   * ݡȥǥ쥯ꤹ˥ǡ쥸롣
   * ʤΤǡͤΥȽϤˤ֤Ȥʤ롣
   */
  *H8_3069F_PADR |= mask;

  /*
   * ݡAΥӥå2,3,6,7ϽϥݡȤȤꤹ롣
   *
   * ǡǥ쥯쥸Write OnlyʤΤǡ
   * ¾ΥӥåȤ꤬ɬפˤʤäǡ
   * ݡޤȤƴ褦
   * 餫кɬפȤʤ
   */
  *H8_3069F_PADDR = 0xCC;

  return 0;
}

int led_write(led_target_t target, led_state_t state)
{
  volatile uint8 mask = 0x00;

  switch (target) {
    case Led1:
      mask = MASK_LED1;
      break;
    case Led2:
      mask = MASK_LED2;
      break;
    case LedG:
      mask = MASK_LEDG;
      break;
    case LedR:
      mask = MASK_LEDR;
      break;
    default:
      return -1;
  }

  switch (state) {
    case LedOn:
      *H8_3069F_PADR &= ~mask;
      break;
    case LedOff:
      *H8_3069F_PADR |= mask;
      break;
    default:
      return -1;
  }

  return 0;
}

int led_toggle(led_target_t target)
{
  volatile uint8 mask = 0x00;

  switch (target) {
    case Led1:
      mask = MASK_LED1;
      break;
    case Led2:
      mask = MASK_LED2;
      break;
    case LedG:
      mask = MASK_LEDG;
      break;
    case LedR:
      mask = MASK_LEDR;
      break;
    default:
      return -1;
  }

  if (*H8_3069F_PADR & mask) {
    *H8_3069F_PADR &= ~mask;
  } else {
    *H8_3069F_PADR |= mask;
  }

  return 0;
}

