#include "defines.h"
#include "kozos.h"
#include "intr.h"
#include "interrupt.h"
#include "serial.h"
#include "lib.h"
#include "driver_console.h"

#define CONS_BUFFER_SIZE 32

#define CONSDRV_CMD_USE   'u' /* 󥽡롦ɥ饤Фλѳ */
#define CONSDRV_CMD_WRITE 'w' /* 󥽡ؤʸ */

static struct consreg {
  kz_thread_id_t id; /* 󥽡Ѥ륹å */
  int index;         /* Ѥ륷ꥢֹ */

  char *send_buf;    /* Хåե */
  char *recv_buf;    /* Хåե */
  int send_len;      /* ХåեΥǡ */
  int recv_len;      /* ХåեΥǡ */

  /* kozos.c  kz_msgbox ƱͤͳǡߡФǥĴ */
  long dummy[3];
} consreg[CONSDRV_DEVICE_NUM];

/* 󥽡롦ɥ饤ФλѳϤ򥳥󥽡롦ɥ饤Ф˰ꤹ */
void console_use(int index)
{
  char *p;
  p = kz_kmalloc(3);
  p[0] = '0';
  p[1] = CONSDRV_CMD_USE;
  p[2] = '0' + index;
  kz_send(MSGBOX_ID_CONSOUTPUT, 3, p);
}

/* 󥽡ؤʸϤ򥳥󥽡롦ɥ饤Ф˰ꤹ */
void console_write(char *str)
{
  char *p;
  int len;
  len = strlen(str);
  p = kz_kmalloc(len + 2);
  p[0] = '0';
  p[1] = CONSDRV_CMD_WRITE;
  memcpy(&p[2], str, len);
  kz_send(MSGBOX_ID_CONSOUTPUT, len + 2, p);
}

/*
 * ʲΣĤδؿ(send_char(), send_string())ϳ߽ȥåɤ
 * ƤФ뤬ХåեƤԲĤΤᡤåɤƤӽФ
 * ¾Τ߶ػ߾֤ǸƤ֤ȡ
 */

/* ХåեƬʸ */
static void send_char(struct consreg *cons)
{
  int i;
  serial_send_byte(cons->index, cons->send_buf[0]);
  cons->send_len--;
  /* ƬʸΤǡʸ֤󤺤餹 */
  for (i = 0; i < cons->send_len; i++)
    cons->send_buf[i] = cons->send_buf[i + 1];
}

/* ʸХåե˽񤭹Ϥ */
static void send_string(struct consreg *cons, char *str, int len)
{
  int i;
  for (i = 0; i < len; i++) { /* ʸХåե˥ԡ */
    if (str[i] == '\n') /* \n\r\nѴ */
      cons->send_buf[cons->send_len++] = '\r';
    cons->send_buf[cons->send_len++] = str[i];
  }
  /*
   * ̵ʤСϤƤʤΤϤ롥
   * ͭʤϤƤꡤߤαĹ
   * ХåեΥǡ缡Τǡ⤷ʤƤ褤
   */
  if (cons->send_len && !serial_intr_is_send_enable(cons->index)) {
    serial_intr_send_enable(cons->index); /* ͭ */
    send_char(cons); /*  */
  }
}

/*
 * ʲϳߥϥɥ餫ƤФ߽ǤꡤƱ
 * ƤФΤǡ饤֥ؿʤɤƤӽФˤդɬס
 * ܤȤơʲΤ줫ƤϤޤؿƤӽФƤϤʤ
 * ǽǤ롥
 * åɤƤФ뤳Ȥ̵ؿǤ롥
 * åɤƤФ뤳Ȥ뤬߶ػߤǸƤӽФƤ롥
 * ޤ󥳥ƥȾ֤ǸƤФ뤿ᡤƥࡦѤƤϤʤ
 * (ӥѤ뤳)
 */
static int consdrv_intrproc(struct consreg *cons)
{
  unsigned char c;
  char *p;

  if (serial_is_recv_enable(cons->index)) { /*  */
    c = serial_recv_byte(cons->index);
    if (c == '\r') /* ԥѴ(\r\n) */
      c = '\n';

    send_string(cons, &c, 1); /* Хå */

    if (cons->id) {
      if (c != '\n') {
	/* ԤǤʤʤ顤Хåե˥Хåե󥰤 */
	cons->recv_buf[cons->recv_len++] = c;
      } else {
	/*
	 * Enter줿顤ХåեƤ
	 * ޥɽåɤΤ롥
	 * (ߥϥɥʤΤǡӥѤ)
	 */
	p = kx_kmalloc(CONS_BUFFER_SIZE);
	memcpy(p, cons->recv_buf, cons->recv_len);
	kx_send(MSGBOX_ID_CONSINPUT, cons->recv_len, p);
	cons->recv_len = 0;
      }
    }
  }

  if (serial_is_send_enable(cons->index)) { /*  */
    if (!cons->id || !cons->send_len) {
      /* ǡ̵ʤСλ */
      serial_intr_send_disable(cons->index);
    } else {
      /* ǡʤС³ */
      send_char(cons);
    }
  }

  return 0;
}

/* ߥϥɥ */
static void consdrv_intr(void)
{
  int i;
  struct consreg *cons;

  for (i = 0; i < CONSDRV_DEVICE_NUM; i++) {
    cons = &consreg[i];
    if (cons->id) {
      if (serial_is_send_enable(cons->index) ||
	  serial_is_recv_enable(cons->index))
	/* ߤʤС߽ƤӽФ */
	consdrv_intrproc(cons);
    }
  }
}

static int consdrv_init(void)
{
  memset(consreg, 0, sizeof(consreg));
  return 0;
}

/* åɤ׵ */
static int consdrv_command(struct consreg *cons, kz_thread_id_t id,
			   int index, int size, char *command)
{
  switch (command[0]) {
  case CONSDRV_CMD_USE: /* 󥽡롦ɥ饤Фλѳ */
    cons->id = id;
    cons->index = command[1] - '0';
    cons->send_buf = kz_kmalloc(CONS_BUFFER_SIZE);
    cons->recv_buf = kz_kmalloc(CONS_BUFFER_SIZE);
    cons->send_len = 0;
    cons->recv_len = 0;
    serial_init(cons->index);
    serial_intr_recv_enable(cons->index); /* ͭ() */
    break;

  case CONSDRV_CMD_WRITE: /* 󥽡ؤʸ */
    /*
     * send_string()ǤХåեƤԲĤʤΤǡ
     * ¾Τ˳߶ػߤˤƸƤӽФ
     */
    INTR_DISABLE;
    send_string(cons, command + 1, size - 1); /* ʸ */
    INTR_ENABLE;
    break;

  default:
    break;
  }

  return 0;
}

int driver_console(int argc, char *argv[])
{
  int size, index;
  kz_thread_id_t id;
  char *p;

  consdrv_init();
  kz_setintr(SOFTVEC_TYPE_SERINTR, consdrv_intr); /* ߥϥɥ */

  while (1) {
    id = kz_recv(MSGBOX_ID_CONSOUTPUT, &size, &p);
    index = p[0] - '0';
    consdrv_command(&consreg[index], id, index, size - 1, p + 1);
    kz_kmfree(p);
  }

  return 0;
}
