#include "driver_led.h"
#include "led.h"
#include "kozos.h"

#define LEDDRV_CMD_LED_ON       'o' /* LED$B$NE@Et(B */
#define LEDDRV_CMD_LED_OFF      'x' /* LED$B$N>CEt(B */
#define LEDDRV_CMD_LED_TOGGLE   't' /* LED$B$N%H%0%k(B */

void leddrv_write(int target, int state)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = state ? LEDDRV_CMD_LED_ON : LEDDRV_CMD_LED_OFF;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

void leddrv_toggle(int target)
{
  char *p;
  p = kz_kmalloc(2);
  p[0] = LEDDRV_CMD_LED_TOGGLE;
  p[1] = '0' + target;
  kz_send(MSGBOX_ID_LEDDRIVE, 2, p);
}

/* $B%9%l%C%I$+$i$NMW5a$r=hM}$9$k(B */
static int leddrv_command(char *p)
{
  int cmd = p[0];
  int led = p[1] - '0';
  switch (cmd) {
  case LEDDRV_CMD_LED_ON:
    led_write(led, LedOn);
    break;
  case LEDDRV_CMD_LED_OFF:
    led_write(led, LedOff);
    break;
  case LEDDRV_CMD_LED_TOGGLE:
    led_toggle(led);
    break;
  default:
    break;
  }
  kz_kmfree(p);

  return 0;
}

int driver_led(int argc, char *argv[])
{
  int size;
  char *p;

  led_init();

  while (1) {
    kz_recv(MSGBOX_ID_LEDDRIVE, &size, &p);
    leddrv_command(p);
  }

  return 0;
}
