#include "re.h"

#define H8_3069F_TMDR       ((volatile uint8 *)0xFFFF62)
#define H8_3069F_TSTR       ((volatile uint8 *)0xFFFF60)
#define H8_3069F_16TCNT2H   ((volatile uint8 *)0xFFFF7A)
#define H8_3069F_16TCNT2L   ((volatile uint8 *)0xFFFF7B)

#define TMDR_BIT_MDF    (1 << 6)
#define TSTR_BIT_STR2   (1 << 2)

int re_init(void)
{
  *H8_3069F_TMDR |= TMDR_BIT_MDF;
  *H8_3069F_TSTR |= TSTR_BIT_STR2;

  return 0;
}

uint16 re_read(void)
{
  return ((*H8_3069F_16TCNT2H) << 8) | (*H8_3069F_16TCNT2L << 0);
}

