#include "sw.h"

#define H8_3069F_P7DR   ((volatile uint8 *)0xFFFFD6)
#define H8_3069F_PADR   ((volatile uint8 *)0xFFFFD9)

#define SW_BIT_P7_SW1   (1 << 0)
#define SW_BIT_P7_SW2   (1 << 1)
#define SW_BIT_PA_SWRE  (1 << 4)

int sw_init(void)
{
  return 0;
}

uint8 sw_read(sw_target_t target)
{
  uint8 c = 0;
  switch (target) {
    case Sw1:
      c = (*H8_3069F_P7DR & SW_BIT_P7_SW1) ? 0 : 1;
      break;
    case Sw2:
      c = (*H8_3069F_P7DR & SW_BIT_P7_SW2) ? 0 : 1;
      break;
    case SwRe:
      c = (*H8_3069F_PADR & SW_BIT_PA_SWRE) ? 0 : 1;
      break;
  }
  return c;
}

