using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Timer;
using Yanesdk.Draw;
using Yamalib.Util;
using Yamalib.Yanesdkext.Draw;
using Yanesdk.Math;
using Yanesdk.Ytl;
using System.Diagnostics;

namespace Kyojin.Component.Ending
{
    public class Scene05 : Scene02
    {
        /** ʃV[NX */
        private class CutDraw
        {
            /** RXgN^ */
            public CutDraw(ITexture bgImg, ITexture nextBgImg, List<FloatageTexture> texts, Object movie)
            {
                // [r[[h
                this.movie = movie;

                // eLXg`̂\z
                flotageTex = texts;

                // bg摜ݒ
                this.bgImg = bgImg;
                this.nextBgImg = nextBgImg;

                rand = new Rand();
                rand.Randomize();

                m_alphaCounter = new InteriorCounter();
                m_alphaCounter.Set(192, -192, 320);
            }

            public void OnMove(IScreen screen)
            {
                // eNX`
                foreach (FloatageTexture ft in flotageTex)
                {
                    ft.OnMove(screen);
                }
            }

            public void OnDraw(IScreen screen)
            {

                // [r[`
                OnDrawMovie(screen);

                // `
                OnDrawText(screen);

                // wi` CX^X̂
                OnDrawBg(screen);
            }

            public void Release()
            {
                // 

                // [r[
                if (movie != null)
                {
                    //movie.Release();
                }
            }

            public List<FloatageTexture> FloatageTextures
            {
                get { return flotageTex; }
            }

            /** [r[tO */
            public bool UseMovie()
            {
                return useMovieFlg;
            }
            bool UseMovie(bool value)
            {
                return useMovieFlg = value;
            }

            public InteriorCounter AlphaCounter
            {
                get { return m_alphaCounter; }
            }

            private ITexture bgImg;
            private ITexture nextBgImg;
            private List<FloatageTexture> flotageTex;
            private Object movie;
            private bool useMovieFlg;
            private InteriorCounter m_alphaCounter;

            private Rand rand;

            private void OnDrawMovie(IScreen screen)
            {
                AlphaCounter.Inc();
            }

            private void OnDrawText(IScreen screen)
            {
                // ̕\
                foreach (FloatageTexture ft in flotageTex)
                {
                    switch (rand.GetRand(3))
                    {
                        case 0:
                            screen.BlendAddColorAlpha();
                            break;
                        case 1:
                            screen.BlendAddColorAlpha();
                            break;
                        case 2:
                            screen.BlendAddColorAlpha();
                            break;
                    }
                    if (ft.DrawInfo.Color == null)
                    {
                        byte baseColor = (byte)rand.GetRand(255);
                        ft.DrawInfo.Color = new Color4ub(baseColor, baseColor, baseColor, 96);
                    }
                    //int baseEle = rand.GetRand(255);
                    //flashInText.DrawInfo.Color.Value.SetColor(baseEle, baseEle, baseEle, 96);
                    ft.OnDraw(screen);
                }
            }

            /** wi̕` */
            private void OnDrawBg(IScreen screen)
            {
                screen.BlendSubColorAlpha();
                if (AlphaCounter.Value() > 0)
                {
                    screen.SetColor(255, 255, 255, AlphaCounter.Value());
                    screen.Blt(bgImg, 0, 0);
                }
                else
                {
                    screen.SetColor(255, 255, 255, -AlphaCounter.Value());
                    screen.Blt(nextBgImg, 0, 0);
                }
            }

        }

        #region 萔l

        private const long START_TIME = 195500 + MUSIC_OFFSET_TIME;
        // ÔߎԂłIԂ`FbN
        private const long END_TIME = 245200 + MUSIC_OFFSET_TIME;

        private const long PHASE_1_START_TIME = 130000 + MUSIC_OFFSET_TIME;
        private const long PHASE_2_1START_TIME = 206200 + MUSIC_OFFSET_TIME;
        private const long PHASE_2_2START_TIME = 209950 + MUSIC_OFFSET_TIME;

        private const long PHASE_3_1START_TIME = 214700 + MUSIC_OFFSET_TIME;
        private const long PHASE_3_2START_TIME = 218450 + MUSIC_OFFSET_TIME;
        private const long PHASE_3_3START_TIME = 222200 + MUSIC_OFFSET_TIME;
        private const long PHASE_3_4START_TIME = 225950 + MUSIC_OFFSET_TIME;

        private const long PHASE_4_1START_TIME = 229700 + MUSIC_OFFSET_TIME;
        private const long PHASE_4_2START_TIME = 233450 + MUSIC_OFFSET_TIME;
        private const long PHASE_5START_TIME = 238000 + MUSIC_OFFSET_TIME;

        #endregion

        #region otB[h

        // V[P@XRA\pϐ
        private int historyPos;
        private InteriorCounter stepCounter;
        private RootCounterS rankAlpha;
        private RootCounterS transCounter;
        private float rankRate = 1.0f;
        private float statusRate = 1.0f;
        private bool rankHistroyEnd = false;
        private bool rankFadeOut = false;

        // eNX`̃_
        private Rand rand;
        // eNX`̂߂̃|Wg
        private FontRepository fontRepositry;
        // eNX`IuWFNg̃v[
        private ObjectPool<FloatageTexture> floatageTexturePool;

        private CutDraw currentCutDraw;

        // ^C\s
        //private bool m_showTime = true;
        // [r[\s
        //private bool m_showMovie = true;
        // WIʒu̕\
        //private bool m_showAimingMark = false;
        // vC
        //private bool m_autoPlay = false;

        private CutDraw scene2_1;
        private CutDraw scene2_2;
        private CutDraw scene3_1;
        private CutDraw scene3_2;
        private CutDraw scene3_3;
        private CutDraw scene3_4;
        private CutDraw scene4_1;
        private CutDraw scene4_2;

        private RootCounterS m_scene5Alpha;

        private int m_rankId = 0;
        private int m_screenAlpha = 192;

        private bool startScene1 = true;	// lP
        private bool startScene2_1;	// lʕ
        private bool startScene2_2;	// lʕ
        private bool startScene3_1;	// lZERO
        private bool startScene3_2;	// lZERO
        private bool startScene3_3;	// lZERO
        private bool startScene3_4;	// lZERO
        private bool startScene4_1;	// l last world
        private bool startScene4_2;	// l last world
        private bool startScene5;	// E

        private GamePointCal gamePointCalLocal;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="timer"></param>
        public Scene05(FixTimer timer)
            : base(timer)
        {
            rand = new Rand();
            rand.Randomize();

            // V[Pp
            gamePointCalLocal = new GamePointCal();
            transCounter = new RootCounterS(0, 255, 4);
            rankAlpha = new RootCounterS(255, 0, 10);

            // gp摜[h
            textureLoader.IsDefRelativePath = false;
            textureLoader.LoadDefFile("img2/ending/s05/bglist.txt");
            floatageTexturePool = new ObjectPool<FloatageTexture>();
            floatageTexturePool.Max = 2048;
            for (int i = 0; i < floatageTexturePool.Max; i++)
            {
                floatageTexturePool.Stack[i] = new FloatageTexture();
            }

            // V[T
            m_scene5Alpha = new RootCounterS(0, 255, 2);
        }

        /// ׂẲ摜LbV	
        public override void CacheTexture()
        {
            CacheTextureAll(textureLoader, "img2/ending/s05/bglist.txt");
        }

        // V[͊JnĂ邩
        public override bool IisStart
        {
            get { return START_TIME <= timer.Time; }
        }

        // V[I
        public override bool IsEnd
        {
            get { return sceneEndFlg || END_TIME <= timer.Time; }
        }

        // \[X̉
        public override void Release()
        {
            textureLoader.Dispose();
        }

        /** tHg|Wg */
        public void SetFontRepository(FontRepository fontRep)
        {
            fontRepositry = fontRep;
        }


        /// ^C~Of[^쐬
        protected override void SetupTimingData()
        {
            // ȂɂȂ
        }

        public override void OnMove(IScreen screen)
        {
            CheckScene(screen);

            if (startScene1)
            {
                OnMoveScene1(screen);
            }

            if (startScene2_1)
            {
                if (scene2_1 != null)
                {
                    scene2_1.OnMove(screen);
                }
            }
            if (startScene2_2)
            {
                if (scene2_2 != null)
                {
                    scene2_2.OnMove(screen);
                }
            }
            if (startScene3_1)
            {
                if (scene3_1 != null)
                {
                    scene3_1.OnMove(screen);
                }
            }
            if (startScene3_2)
            {
                if (scene3_2 != null)
                {
                    scene3_2.OnMove(screen);
                }
            }
            if (startScene3_3)
            {
                if (scene3_3 != null)
                {
                    scene3_3.OnMove(screen);
                }
            }
            if (startScene3_4)
            {
                if (scene3_4 != null)
                {
                    scene3_4.OnMove(screen);
                }
            }
            if (startScene4_1)
            {
                if (scene4_1 != null)
                {
                    scene4_1.OnMove(screen);
                }
            }
            if (startScene4_2)
            {
                if (scene4_2 != null)
                {
                    scene4_2.OnMove(screen);
                }
            }
            if (startScene5)
            {
                OnMoveScene5(screen);
            }
        }

        public override void OnDraw(IScreen screen)
        {
            screen.SetColor(255, 255, 255, 255);
            if (startScene1)
            {
                OnDrawScene1(screen);
            }
            if (startScene2_1)
            {
                if (scene2_1 != null)
                {
                    scene2_1.OnDraw(screen);
                }
            }
            if (startScene2_2)
            {
                if (scene2_2 != null)
                {
                    scene2_2.OnDraw(screen);
                }
            }
            if (startScene3_1)
            {
                if (scene3_1 != null)
                {
                    scene3_1.OnDraw(screen);
                }
            }
            if (startScene3_2)
            {
                if (scene3_2 != null)
                {
                    scene3_2.OnDraw(screen);
                }
            }
            if (startScene3_3)
            {
                if (scene3_3 != null)
                {
                    scene3_3.OnDraw(screen);
                }
            }
            if (startScene3_4)
            {
                if (scene3_4 != null)
                {
                    scene3_4.OnDraw(screen);
                }
            }
            if (startScene4_1)
            {
                if (scene4_1 != null)
                {
                    scene4_1.OnDraw(screen);
                }
            }
            if (startScene4_2)
            {
                if (scene4_2 != null)
                {
                    scene4_2.OnDraw(screen);
                }
            }
            if (startScene5)
            {
                OnDrawScene5(screen);
            }
        }

        #region Jo

        private List<string> LoadMessage(string filename, int maxLength)
        {
            List<string> result = new List<string>();
            string strText = Yamalib.Util.YamalibUtility.ReadTextFile(filename);
            string[] strLine = strText.Split(new char[] { '\n' });
            foreach (string str in strLine)
            {
                if (str == null || str.Length == 0)
                {
                    continue;
                }
                if (str.Length > maxLength)
                {
                    result.Add(str.Substring(0, maxLength));
                }
                else
                {
                    result.Add(str);
                }
            }

            return result;
        }

        private const float RAND_SCALE = 100000.0f;

        private float GetRand(float min, float max)
        {
            return min + ((max - min) * (rand.GetRand((int)RAND_SCALE) / RAND_SCALE));
        }

        void ReleaseCutDraw(CutDraw cutDraw)
        {
            foreach (FloatageTexture ft in cutDraw.FloatageTextures)
            {
                ft.Reset();
                floatageTexturePool.Push(ft);
            }
        }

        private List<FloatageTexture> CreateFloatageTextureFromString(string text, int offsetx, int offsety, int maxWidth, int maxHeight)
        {
            return CreateFloatageTextureFromStringRate(text, offsetx, offsety, maxWidth, maxHeight, 0.0f, 0.4f);
        }

        /// eNX`𐶐(gk)
        private List<FloatageTexture> CreateFloatageTextureFromStringRate(string text, int offsetx, int offsety,
                   int maxWidth, int maxHeight, float minRate, float maxRate)
        {

            List<FloatageTexture> result = new List<FloatageTexture>();
            float ox = 0.0f;
            foreach (char ch in text.ToCharArray())
            {
                FloatageTexture ft = floatageTexturePool.Pop();
                if (ft == null)
                {
                    break;
                }

                ft.Texture = fontRepositry.GetTexture(ch, 0);
                Debug.Assert(ft.Texture != null);
                if (maxWidth > ox + offsetx)
                {
                    ft.DrawInfo.X = (int)ox + offsetx;
                }
                else
                {
                    // s
                    ox = 0;
                    offsety += (int)ft.Texture.Height;
                }
                ft.DrawInfo.Y = offsety;
                ft.DrawInfo.DrawOffset = 4;
                // g嗦
                // ]p
                // J[

                // ItZbg
                ox += ft.Texture.Width;

                // [g쐬
                RateRadMoment moment = new RateRadMoment();
                moment.AddRad = GetRand(-1.0f, 4.0f);
                moment.AddRate = GetRand(minRate, maxRate);
                //			moment.addRad = GetRand(-0.5f, 0.5f);
                //			moment.addRate = GetRand(0.0f, 0.01f);

                // [gǉ
                ft.Moments = new Moment[] { moment };

                result.Add(ft);
            }

            const int MOVE_COUNT = 100;
            foreach (FloatageTexture ft in result)
            {
                for (int i = 0; i < MOVE_COUNT; ++i)
                {
                    ft.OnMove(null);
                }
                ft.Moments[0].IsReverse = true;
            }

            return result;
        }

        /** V[āACX^Xԋp */
        private CutDraw InitScene(int textureNo, int nextTextureNo, string messageFile, Object movieFile)
        {
            List<string> messages = LoadMessage(messageFile, 512);
            List<FloatageTexture> result = new List<FloatageTexture>();
            int basey = 80;
            for (int i = 0; i < 30; ++i)
            {
                if (messages.Count <= i)
                {
                    break;
                }
                List<FloatageTexture> fts = CreateFloatageTextureFromString(messages[rand.GetRand(messages.Count)], 50,
                        basey, 630, 430);
                if (fts != null)
                {
                    basey += (int)fts[fts.Count - 1].Texture.Height + 10;
                    if (fts[fts.Count - 1].DrawInfo.Y > 430)
                    {
                        break;
                    }
                }
                else
                {
                    // Sǂݍ
                    break;
                }

                foreach (FloatageTexture floatageTex in fts)
                {
                    result.Add(floatageTex);
                }
            }

            return new CutDraw(textureLoader.GetTexture(textureNo),
                    nextTextureNo >= 0 ? textureLoader.GetTexture(nextTextureNo) : null, result, movieFile);
        }

        /// <summary>
        /// V[Jñ`FbN
        /// </summary>
        /// <param name="screen"></param>
        private void CheckScene(IScreen screen)
        {
            const int scene3Step = 150;
            if (!startScene2_1 && timer.Time > PHASE_2_1START_TIME)
            {
                startScene1 = false;
                startScene2_1 = true;
                currentCutDraw = scene2_1 = InitScene(0, 1, "img2/ending/s05/special1.txt", null);
                scene2_1.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, 160);
            }
            if (!startScene2_2 && timer.Time > PHASE_2_2START_TIME)
            {
                //Log.print("START RELEASE SCENE2.1");
                ReleaseCutDraw(scene2_1);
                //Log.print("END RELEASE SCENE2.1");
                scene2_1 = null;
                startScene2_2 = true;
                //Log.print("START InitScene for 2.2");

                currentCutDraw = scene2_2 = InitScene(1, 2, "img2/ending/s05/special2.txt", null);
                scene2_2.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, 160);
                //Log.print("END InitScene for 2.2");
            }
            if (!startScene3_1 && timer.Time > PHASE_3_1START_TIME)
            {
                //Log.print("START RELEASE SCENE2.2");
                ReleaseCutDraw(scene2_2);
                //Log.print("END RELEASE SCENE2.2");
                scene2_2 = null;
                startScene3_1 = true;
                //Log.print("START InitScene for 3.1");
                currentCutDraw = scene3_1 = InitScene(2, 3, "img2/ending/s05/zero1.txt", null);
                scene3_1.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, scene3Step);
                //Log.print("END InitScene for 3.1");
            }
            if (!startScene3_2 && timer.Time > PHASE_3_2START_TIME)
            {
                //Log.print("START RELEASE SCENE3.1");
                ReleaseCutDraw(scene3_1);
                //Log.print("END RELEASE SCENE3.1");
                scene3_1 = null;
                startScene3_2 = true;
                //Log.print("START InitScene for 3.2");
                currentCutDraw = scene3_2 = InitScene(3, 4, "img2/ending/s05/zero2.txt", null);
                scene3_2.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, scene3Step);
                //Log.print("END InitScene for 3.2");
            }
            if (!startScene3_3 && timer.Time > PHASE_3_3START_TIME)
            {
                //Log.print("START RELEASE SCENE3.2");
                ReleaseCutDraw(scene3_2);
                //Log.print("END RELEASE SCENE3.2");
                scene3_2 = null;
                startScene3_3 = true;
                //Log.print("START InitScene for 3.3");
                currentCutDraw = scene3_3 = InitScene(4, 5, "img2/ending/s05/zero3.txt", null);
                scene3_3.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, scene3Step);
                //Log.print("END InitScene for 3.3");
            }
            if (!startScene3_4 && timer.Time > PHASE_3_4START_TIME)
            {
                //Log.print("START RELEASE SCENE3.3");
                ReleaseCutDraw(scene3_3);
                //Log.print("END RELEASE SCENE3.3");
                scene3_3 = null;
                startScene3_4 = true;
                //Log.print("START InitScene for 3.4");
                currentCutDraw = scene3_4 = InitScene(5, 6, "img2/ending/s05/zero4.txt", null);
                scene3_4.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, scene3Step);
                //Log.print("END InitScene for 3.4");
            }
            if (!startScene4_1 && timer.Time > PHASE_4_1START_TIME)
            {
                //Log.print("START RELEASE SCENE3.4");
                ReleaseCutDraw(scene3_4);
                //Log.print("END RELEASE SCENE3.4");
                scene3_4 = null;
                startScene4_1 = true;
                //Log.print("START InitScene for 4.1");
                currentCutDraw = scene4_1 = InitScene(6, 7, "img2/ending/s05/last1.txt", null);
                scene4_1.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, 160);
                //Log.print("END InitScene for 4.1");
            }
            if (!startScene4_2 && timer.Time > PHASE_4_2START_TIME)
            {
                //Log.print("START RELEASE SCENE4.1");
                ReleaseCutDraw(scene4_1);
                //Log.print("END RELEASE SCENE4.1");
                scene4_1 = null;
                startScene4_2 = true;
                //Log.print("START InitScene for 4.2");
                currentCutDraw = scene4_2 = InitScene(7, -1, "img2/ending/s05/last2.txt", null);
                scene4_2.AlphaCounter.Set(m_screenAlpha, -m_screenAlpha, 160);
                //Log.print("END InitScene for 4.2");
            }
            if (!startScene5 && timer.Time > PHASE_5START_TIME)
            {
                //Log.print("START RELEASE SCENE4.2");
                startScene5 = true;
                scene4_2 = null;
                screen.SetClearColor(255, 255, 255);
                //Log.print("END InitScene for 5");
            }
        }


        /** V[P XRA\ */
        private void OnMoveScene1(IScreen screen)
        {
            if (!rankHistroyEnd)
            {
                List<HitStatus> statusHistory = GamePointcalculator().StatusHitory;
                transCounter.Inc();

                if (stepCounter == null)
                {
                    stepCounter = new InteriorCounter();
                    stepCounter.Set(0, statusHistory.Count, 300);
                }

                stepCounter.Inc();
                int nextPos = stepCounter.Value();
                if (statusHistory.Count <= historyPos)
                {
                    return;
                }

                for (int i = historyPos; i < nextPos; ++i)
                {
                    // vZ
                    gamePointCalLocal.CalcHitPoint(statusHistory[i]);
                }
                historyPos = nextPos;

                if (stepCounter.IsEnd)
                {
                    rankHistroyEnd = true;
                }
            }
            else
            {
                rankAlpha.Inc();
                rankRate += 0.04f;
                if (rankAlpha.IsEnd)
                {
                    rankFadeOut = true;
                }
            }

        }

        /// <summary>
        /// NID擾
        /// </summary>
        /// <returns></returns>
        private int GetRankID()
        {
            return m_rankId;
        }

        /// <summary>
        /// V[P XRA\
        /// </summary>
        /// <param name="screen"></param>
        void OnDrawScene1(IScreen screen)
        {
            if (rankFadeOut)
            {
                screen.BlendAddColorAlpha();
                statusRate += 0.06f;
            }

            // Xe[^X
            List<HitStatus> statusHistory = GamePointcalculator().StatusHitory;
            int offsetx = 80;
            int offsety = 22;
            int baseAlpha = 64;
            int randAlpha = 16;
            for (int i = 0; i < historyPos; ++i)
            {
                ITexture targetTexture = null;
                switch (statusHistory[i])
                {
                    case HitStatus.GREAT:
                        screen.SetColor(GREAT_COLOR.R, GREAT_COLOR.G, GREAT_COLOR.B, baseAlpha + rand.GetRand(randAlpha));
                        targetTexture = textureLoader.GetTexture(19);
                        break;
                    case HitStatus.GOOD:
                        screen.SetColor(GOOD_COLOR.R, GOOD_COLOR.G, GOOD_COLOR.B, baseAlpha + rand.GetRand(randAlpha));
                        targetTexture = textureLoader.GetTexture(20);
                        break;
                    case HitStatus.BAD:
                        screen.SetColor(BAD_COLOR.R, BAD_COLOR.G, BAD_COLOR.B, baseAlpha + rand.GetRand(randAlpha));
                        targetTexture = textureLoader.GetTexture(21);
                        break;
                    case HitStatus.POOR:
                        screen.SetColor(BAD_COLOR.R, BAD_COLOR.G, BAD_COLOR.B, baseAlpha + rand.GetRand(randAlpha));
                        targetTexture = textureLoader.GetTexture(22);
                        break;
                    case HitStatus.ERROR:
                        screen.SetColor(255, 0, 0, 128 + rand.GetRand(randAlpha));
                        targetTexture = textureLoader.GetTexture(23);
                        break;
                    default:
                        break;
                }
                screen.BltRotate(targetTexture, 40 + offsetx * (i % 8), 11 + offsety * (i / 8), 0,
                        statusRate, 4);
            }

            // F𔒂ɂĂ
            screen.SetColor(255, 255, 255, 255);

            // g[^
            TransBltter.Blt(22, screen, textureLoader.GetTexture(9), 120, 325, transCounter.Value());

            // _؂̂
            int scorePoint = (int)gamePointCalLocal.TotalPoint;
            string scorePointStr = scorePoint.ToString();
            List<ITexture> pointTexture = new List<ITexture>();
            foreach (char w in scorePointStr.ToCharArray())
            {
                pointTexture.Add(fontRepositry.GetTexture(w, 0));
            }

            // XRA̕\
            float ox = 0.0f;
            float sizeRate = 1.5f;
            foreach (ITexture texture in pointTexture)
            {
                screen.BltRotate(texture, 320 + (int)ox, 325, 0, sizeRate, 0);
                ox += texture.Width * sizeRate + 3.0f;
            }

            // N
            TransBltter.Blt(22, screen, textureLoader.GetTexture(10), 180, 382, transCounter.Value());
            ITexture rankTexture;
            if (scorePoint > 350000)
            {
                rankTexture = textureLoader.GetTexture(17);
                m_screenAlpha = 192;
                m_rankId = 6;
            }
            else if (scorePoint > 250000)
            {
                rankTexture = textureLoader.GetTexture(16);
                m_screenAlpha = 128;
                m_rankId = 5;
            }
            else if (scorePoint > 150000)
            {
                rankTexture = textureLoader.GetTexture(15);
                m_screenAlpha = 64;
                m_rankId = 4;
            }
            else if (scorePoint > 75000)
            {
                rankTexture = textureLoader.GetTexture(14);
                m_screenAlpha = 32;
                m_rankId = 3;
            }
            else if (scorePoint > 50000)
            {
                rankTexture = textureLoader.GetTexture(13);
                m_screenAlpha = 8;
                m_rankId = 2;
            }
            else if (scorePoint > 20000)
            {
                rankTexture = textureLoader.GetTexture(12);
                m_screenAlpha = 4;
                m_rankId = 1;
            }
            else
            {
                rankTexture = textureLoader.GetTexture(11);
                m_screenAlpha = 0;
                m_rankId = 0;
            }
            screen.BltRotate(rankTexture, 327, 397, 0, 1.0f, 4);


            if (stepCounter.IsEnd)
            {
                screen.SetColor(255, 255, 255, rankAlpha.Value());
                // NGtFNg
                screen.BltRotate(rankTexture, 327, 397, 0, rankRate, 4);
            }

            // ̃V[ւ̋n
            if (rankFadeOut)
            {
                screen.SetColor(255, 255, 255, m_screenAlpha);
                screen.BlendSubColorAlpha();
                screen.Blt(textureLoader.GetTexture(0), 0, 0);
            }
        }


        /** V[T 쒘 */
        void OnMoveScene5(IScreen screen)
        {
            m_scene5Alpha.Inc();
        }
        void OnDrawScene5(IScreen screen)
        {
            screen.SetColor(255, 255, 255, m_scene5Alpha.Value());
            screen.BltRotate(textureLoader.GetTexture(8), 320, 240, 0, 1.0f, 4);
        }

        #endregion



    }
}
