using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Yanesdk.Draw;

namespace Kyojin.Component.Ending
{
    /** Ȃ炩̃ANVs`C^[tF[X */
    public interface Moment
    {
        /** ړ */
        YanesdkResult Act(DrawInfo drawInfo);

        /** Ԃɖ߂ */
        void Reset();

        /** o[X[hH */
        bool IsReverse
        {
            set;
            get;
        }
    }

    /** gkE][gNX */
    public class RateRadMoment : Moment
    {
        /** ړ */
        public YanesdkResult Act(DrawInfo drawInfo)
        {
            if (!IsReverse)
            {
                drawInfo.X = drawInfo.X + AddX;
                drawInfo.Y = drawInfo.Y + AddY;
                drawInfo.Rad = drawInfo.Rad + AddRad;
                drawInfo.Rate = drawInfo.Rate + AddRate;
            }
            else
            {
                drawInfo.X = drawInfo.X - AddX;
                drawInfo.Y = drawInfo.Y - AddY;
                drawInfo.Rad = drawInfo.Rad - AddRad;
                drawInfo.Rate = drawInfo.Rate - AddRate;
            }

            return YanesdkResult.NoError;
        }


        /** Ԃɖ߂ */
        public void Reset()
        {
            // ƂɂȂł悵
        }

        private float addAlpha = 1.0f;

        public float AddAlpha
        {
            get { return addAlpha; }
            set { addAlpha = value; }
        }
        private float m_addX = 0.0f;

        public float AddX
        {
            get { return m_addX; }
            set { m_addX = value; }
        }
        private float m_addY = 0.0f;

        public float AddY
        {
            get { return m_addY; }
            set { m_addY = value; }
        }
        private float m_addRad = 0.0f;

        public float AddRad
        {
            get { return m_addRad; }
            set { m_addRad = value; }
        }
        private float m_addRate = 0.0f;

        public float AddRate
        {
            get { return m_addRate; }
            set { m_addRate = value; }
        }
        private bool m_reverse = false;

        public bool IsReverse
        {
            get { return m_reverse; }
            set { m_reverse = value; }
        }


    }

    /** `悷Ƃ̏ */
    public class DrawInfo
    {
        public Color4ub? Color
        {
            get { return m_color; }
            set { m_color = value; }
        }

        public float X
        {
            get { return m_x; }
            set { m_x = value; }
        }

        public float Y
        {
            get { return m_y; }
            set { m_y = value; }
        }

        public float Rate
        {
            get { return m_rate; }
            set { m_rate = value; }
        }

        public float Rad
        {
            get { return m_rad; }
            set { m_rad = value; }
        }


        public int DrawOffset
        {
            get { return m_drawOffset; }
            set { m_drawOffset = value; }
        }

        /** Ԃɖ߂ */
        public void Reset()
        {
            X = 0;	// `ʒu
            Y = 0;
            Rate = 1.0f;	// g嗦
            Rad = 0;	// ]px
            DrawOffset = 0;
        }

        private Color4ub? m_color;	// `F
        private float m_x = 0;	// `ʒu
        private float m_y = 0;
        private float m_rate = 1.0f;	// g嗦
        private float m_rad = 0;	// ]px
        private int m_drawOffset = 0;

    }

    public class FloatageTexture
    {

        #region otB[h

        private ITexture m_texture;

        private readonly DrawInfo m_drawInfo;	// uԂ̕`ݒlۑ
        private Moment[] m_moments;

        #endregion


        /** RXgN^ */
        public FloatageTexture()
        {
            m_drawInfo = new DrawInfo();
        }

        /** eNX`̐ݒ/擾 */
        public ITexture Texture
        {
            get { return m_texture; }
            set { m_texture = value; }
        }

        public DrawInfo DrawInfo
        {
            get { return m_drawInfo; }
        }

        /** [g̐ݒ/擾 */
        public Moment[] Moments
        {
            get { return m_moments; }
            set { m_moments = value; }
        }

        /** IuWFNgv[ɑΉ */
        public void Reset()
        {
            foreach (Moment moment in Moments)
            {
                moment.Reset();
            }
            DrawInfo.Reset();
        }

        /** ړs܂ */
        public YanesdkResult OnMove(IScreen screen)
        {
            // [gɂē삳
            foreach (Moment moment in Moments)
            {
                moment.Act(DrawInfo);
            }

            return YanesdkResult.NoError;
        }


        /** `揈s܂ */
        public YanesdkResult OnDraw(IScreen screen)
        {
            if (screen == null || Texture == null)
            {
                return YanesdkResult.InvalidParameter;
            }
            Draw(screen, Texture, DrawInfo);
            return YanesdkResult.NoError;
        }

        /** w肵ŕ`悷 */
        private static YanesdkResult Draw(IScreen screen, ITexture texture, DrawInfo drawInfo)
        {
            // ςȂ̂悱...
            if (screen == null || texture == null || drawInfo == null)
            {
                return YanesdkResult.InvalidParameter;
            }

            // ScreenColor̃obNAbv͂Ȃ...
            if (drawInfo.Color != null)
            {
                screen.SetColor(drawInfo.Color.Value);
            }
            else
            {
                screen.SetColor(255, 255, 255, 255);
            }

            if (drawInfo.Rad != 0 || drawInfo.Rate != 0.0f)
            {
                screen.BltRotate(texture, (int)drawInfo.X, (int)drawInfo.Y,
                        (int)drawInfo.Rad, drawInfo.Rate, drawInfo.DrawOffset);
            }
            else
            {
                screen.Blt(texture, (int)drawInfo.X, (int)drawInfo.Y);
            }
            return YanesdkResult.NoError;
        }
    }
}
