using System;
using System.Collections.Generic;
using System.Text;
using Kyojin.Model;
using Yanesdk.Ytl;
using Yanesdk.Draw;
using Yanesdk.Input;
using Yamalib.Draw;
using Yanesdk.System;
using Yamalib.Input;
using Yamalib.Scenario;
using Yamalib.Scenario.YaneScript;

namespace Kyojin.Component.Scenario
{
    public class KyojinScenarioModel : YaneScenarioModel
    {

        #region otB[h

        private UserStateView userStateView;
        private UserInfo userInfo;
        private int pageNo = 1;
        private ThumbnailDraw thumbnailDraw;
        private ThumbnailCreator thumbnailCreator;
        private bool showThumbnailDraw = false;

        #endregion


        /// <summary>
        /// RXgN^
        /// </summary>
        public KyojinScenarioModel()
        {
        }

        public ThumbnailCreator ThumbnailCreator
        {
            get { return thumbnailCreator; }
            set { thumbnailCreator = value; }
        }

        public bool IsShowThumbnailDraw
        {
            get { return showThumbnailDraw; }
            set { showThumbnailDraw = value; }
        }

        public ThumbnailDraw ThumbnailDraw
        {
            get { return thumbnailDraw; }
            set { thumbnailDraw = value; }
        }

        /// <summary>
        /// [U\IuWFNg
        /// </summary>
        public UserStateView UserStateView
        {
            get { return userStateView; }
            set { userStateView = value; }
        }

        /// <summary>
        /// [U
        /// </summary>
        public UserInfo UserInfo
        {
            get { return userInfo; }
            set { userInfo = value; }
        }

        public int PageNo
        {
            get { return pageNo; }
            set { pageNo = value; }
        }

        /// <summary>
        /// ړ
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        public override YanesdkResult OnMove(IScreen screen)
        {
            if (null != userStateView)
            {
                userStateView.OnMove(screen);
            }

            return base.OnMove(screen);
        }


        /// <summary>
        /// ̃y[W͂
        /// </summary>
        protected override void UpdateText()
        {
            base.UpdateText();
            // y[Wԍ𑝂₷
            PageNo++;

            // lł  BGM_STOP -> BGM_PLAY Ƃ^OɂȂĂ
            // ꂾƃNXtF[hgȂ
            Dictionary<int, int> stopPlayCmd = new Dictionary<int, int>();
            List<int> removeTagIndex = new List<int>();
            int i = 0;
            foreach (ICommandHandler cmd in currentPageTags)
            {
                if (cmd as BgmStopCommandHandler != null)
                {
                    stopPlayCmd.Add(cmd.ExecPosition, i);
                }
                if (cmd as BgmPlayCommandHandler != null)
                {
                    if (stopPlayCmd.ContainsKey(cmd.ExecPosition))
                    {
                        removeTagIndex.Add(stopPlayCmd[cmd.ExecPosition]);
                    }
                }
                ++i;
            }
            for (int j = 0; j < removeTagIndex.Count; j++)
            {
                currentPageTags[removeTagIndex[j]] = NullCommandHandler.Instance;
            }

        }


    }

    /// <summary>
    /// lViIpView
    /// </summary>
    class KyojinScenarioView : YaneScenarioView, IDisposable
    {
        #region otB[h

        private IMouseInput mouse;
        private bool showBg = true;
        private bool showText = true;
        private bool showCharacter = true;

        #endregion

        /// <summary>
        /// }EX
        /// </summary>
        public IMouseInput Mouse
        {
            get { return mouse; }
            set { mouse = value; }
        }

        #region IDisposable o

        public void Dispose()
        {
        }

        #endregion

        /// <summary>
        /// wi\邩
        /// </summary>
        public bool IsShowBG
        {
            get { return showBg; }
            set { showBg = value; }
        }
        /// <summary>
        /// eLXg\邩
        /// </summary>
        public bool IsShowText
        {
            get { return showText; }
            set { showText = value; }
        }
        /// <summary>
        /// LN^[\邩
        /// </summary>
        public bool IsShowCharacter
        {
            get { return showCharacter; }
            set { showCharacter = value; }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        /// <returns></returns>
        public override YanesdkResult OnPaint(IScreen screen)
        {
            KyojinScenarioModel model = Model as KyojinScenarioModel;
            List<IViewLayler> layers = Model.ViewLayler;

            if (IsShowBG)
            {
                OnPaintBG(screen);
                if (null != PostPaintBG)
                {
                    PostPaintBG(screen, this);
                }
            }

            if (IsShowCharacter)
            {
                OnPaintCharacter(screen);
                if (null != PostPaintCharacter)
                {
                    PostPaintCharacter(screen, this);
                }
            }

            // [U\
            model.UserStateView.OnPaint(screen);

            if (IsShowText)
            {
                OnPaintText(screen);
                if (null != PostPaintText)
                {
                    PostPaintText(screen, this);
                }
            }

            if (model.IsShowThumbnailDraw)
            {
                model.ThumbnailDraw.OnMove(screen);
                model.ThumbnailDraw.OnDraw(screen);
            }


            return YanesdkResult.NoError;
        }

    }

}
