using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Yamalib.Util;
using System.Diagnostics;
using Yanesdk.Ytl;
using Yanesdk.Movie;
using Yanesdk.Timer;
using Yanesdk.Math;
using Yanesdk.Draw;

namespace Kyojin.Component.Ending
{
    /// <summary>
    /// [r[Đ̑f[^NX
    /// </summary>
    public class MovieFileInfo : IDisposable
    {
        public static List<MovieFileInfo> CreateFromDefFile(string filename)
        {
            List<MovieFileInfo> result = new List<MovieFileInfo>();
            CSVReader reader = new CSVReader();
            YanesdkResult res = reader.Read(filename);
            if (res == YanesdkResult.NoError)
            {
                foreach (List<string> lineData in reader.CsvData)
                {
                    if (lineData.Count < 6)
                    {
                        continue;
                    }
                    // t@C
                    string moviefilename = lineData[0];
                    if (moviefilename == null || string.Empty == moviefilename) continue; // _

                    MovieFileInfo instance = new MovieFileInfo(moviefilename);

                    // Đ~b
                    instance.Length = Convert.ToInt32(lineData[1]);
                    // {
                    instance.BaseAlpha = Convert.ToInt32(lineData[2]);
                    // _Zl
                    instance.RandAlpha = Convert.ToInt32(lineData[3]);
                    // C^[o
                    instance.Interval = Convert.ToInt32(lineData[4]);
                    // ]
                    instance.Rate = Convert.ToInt32(lineData[5]);

                    result.Add(instance);
                }
            }
            return result;
        }

        #region tB[ho

        /** t@C */
        private readonly string m_filename;
        /** WJ̕KvLΓWJ */
        private FileSys.TmpFile m_movieTmpFile;
        /** ~b */
        private int m_length;
        /** {Ƃ郿l */
        private int m_baseAlpha;
        /** _ŎgpőZl */
        private int m_randAlpha = 1;
        /** tF[hCEAEgɎgpJE^ */
        private readonly RootCounterS m_fadeinAlphaCounter;
        private readonly RootCounterS m_fadeoutAlphaCounter;
        /** ɂC^[o */
        private int m_interval;
        /** ]l */
        private long m_rate;


        #endregion


        /** RXgN^ */
        public MovieFileInfo(string movieFilename)
        {
            m_movieTmpFile = FileSys.GetTmpFile(movieFilename);
            m_filename = m_movieTmpFile.FileName;
            Debug.Assert(m_filename != null);
            //Log.print("MOVIE FILENAME:%s", m_filename);
            m_fadeinAlphaCounter = new RootCounterS();
            m_fadeinAlphaCounter.Set(0, 192, 5);
            m_fadeoutAlphaCounter = new RootCounterS();
            m_fadeoutAlphaCounter.Set(192, 0, 5);
        }

        #region vpeB

        public string Filename
        {
            get { return m_filename; }
        }

        public int Length
        {
            get { return m_length; }
            set { m_length = value; }
        }

        public int BaseAlpha
        {
            get { return m_baseAlpha; }
            set { m_baseAlpha = value; }
        }

        public int RandAlpha
        {
            get { return m_randAlpha; }
            set { m_randAlpha = value; }
        }

        public RootCounterS FadeinAlphaCounter
        {
            get { return m_fadeinAlphaCounter; }
        }


        public RootCounterS FadeoutAlphaCounter
        {
            get { return m_fadeoutAlphaCounter; }
        }


        public int Interval
        {
            get { return m_interval; }
            set { m_interval = value; }
        }

        public long Rate
        {
            get { return m_rate; }
            set { m_rate = value; }
        }

        #endregion

        #region IDisposable o

        public void Dispose()
        {
            if (m_movieTmpFile != null)
            {
                m_movieTmpFile.Release();
            }
        }

        #endregion
    }

    public class MoviePlayer
    {

        #region tB[ho

        private readonly Rand rand;
        private readonly Movie movie;
        private readonly FixTimer m_intervalTimer;
        private readonly FixTimer m_timer;
        private GlTexture movieTexture;
        private bool m_intervalWait = false;
        private bool m_playing;
        private bool m_fadeout;
        private List<MovieFileInfo> m_playFilenames;
        private int playIndex;

        #endregion

        /** RXgN^ */
        public MoviePlayer()
        {
            movie = new Movie();
            movieTexture = new GlTexture();
            movieTexture.SetSurface(movie.Surface);
            rand = new Rand();
            rand.Randomize();
            m_intervalTimer = new FixTimer();
            m_intervalTimer.Reset();
            m_timer = new FixTimer();
            m_timer.Reset();
        }

        /**  */
        public void OnMove(IScreen screen)
        {
            try
            {
                m_timer.Update();
                m_intervalTimer.Update();
                if (playIndex >= m_playFilenames.Count)
                {
                    return;
                }

                if (!m_playing)
                {
                    return;
                }

                MovieFileInfo currentMovieInfo = m_playFilenames[playIndex];
                if (m_intervalWait)
                {
                    if (m_intervalTimer.Time >= currentMovieInfo.Interval)
                    {
                        m_playing = false;
                        m_intervalWait = false;
                        Next();
                    }
                }
                else if (m_playing && !movie.IsPlaying)
                {

                    // C^[oƂ񂩁H
                    if (!m_intervalWait && currentMovieInfo.Interval > 0)
                    {
                        m_intervalWait = true;
                        m_intervalTimer.Reset();
                        return;
                    }

                    m_playing = false;
                    Next();
                }
                else
                {
                    currentMovieInfo.FadeinAlphaCounter.Inc();
                    if (!m_fadeout && currentMovieInfo.Length - m_timer.Time < 1500)
                    {
                        m_fadeout = true;
                    }
                    if (m_fadeout)
                    {
                        currentMovieInfo.FadeoutAlphaCounter.Inc();
                    }
                }
            }
            catch
            {
                Console.WriteLine("Movie movie error!");
                Stop();
            }
        }

        /** ` */
        public void OnDraw(IScreen screen)
        {
            if (!m_playing || !movie.IsReadyToDraw)
            {
                return;
            }

            if (playIndex >= m_playFilenames.Count)
            {
                return;
            }

            MovieFileInfo currentMovieInfo = m_playFilenames[playIndex];

            if (!currentMovieInfo.FadeinAlphaCounter.IsEnd)
            {
                screen.SetColor(255, 255, 255,
                        currentMovieInfo.FadeinAlphaCounter.Value());
            }
            else if (m_fadeout)
            {
                screen.SetColor(255, 255, 255,
                        currentMovieInfo.FadeoutAlphaCounter.Value());
            }
            else
            {
                screen.SetColor(255, 255, 255,
                        currentMovieInfo.BaseAlpha + rand.GetRand(currentMovieInfo.RandAlpha));
            }

            movie.Draw(movieTexture);
            screen.BlendAddColorAlpha();
            screen.Blt(movieTexture, 0, 0);
        }

        /** vCt@C */
        public void SetPlayFile(List<MovieFileInfo> playFileNames)
        {
            m_playFilenames = playFileNames;
            playIndex = 0;
        }

        /** Đ */
        public void Play()
        {
            // Xgݒ肳ĂȂ
            if (0 == m_playFilenames.Count)
            {
                return;
            }
            // SI
            if (playIndex >= m_playFilenames.Count)
            {
                return;
            }
            movie.Load(m_playFilenames[playIndex].Filename);
            movieTexture = new GlTexture();
            movieTexture.SetSurface(movie.Surface);
            movie.Play();
            m_timer.Reset();
            m_playing = true;
            m_fadeout = false;
        }

        /**  */
        public void Next()
        {
            if (playIndex < m_playFilenames.Count)
            {
                ++playIndex;
                Play();
            }
        }

        /** ~ */
        public void Stop()
        {
            movie.Stop();
        }

        /**  */
        public void Release()
        {
            if (movie != null)
            {
                try
                {
                    movie.Release();
                }
                catch
                {

                }
            }
            foreach (MovieFileInfo fileInfo in m_playFilenames)
            {
                fileInfo.Dispose();
            }
        }


    }
}
