using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;

namespace Yamalib.Draw
{

    /** tORect */
    public class RectF
    {
        public float left;	//!< 
        public float top;	//!< 
        public float right;	//!< E
        public float bottom;	//!< 
        public bool enable;	//<! Lǂig͔CӁj

        public RectF()
        {
            left = .0f;
            top = .0f;
            right = .0f;
            bottom = .0f;
            enable = false;
        }

        ///	ef[^ݒ肷
        public void SetRect(float left_, float top_, float right_, float bottom_)
        {
            left = left_;
            top = top_;
            right = right_;
            bottom = bottom_;
        }

        /// PRectƂ̌݊
        public void SetRect(Rect rc)
        {
            left = rc.Left;
            top = rc.Top;
            right = rc.Right;
            bottom = rc.Bottom;
        }

        /// 擾
        /**
            left - right Ă邾B}CiXɂȂꍇ肤B
        */
        public float Width
        {
            get { return right - left; }
        }


        ///	擾
        /**
            bottom - top Ă邾B}CiXɂȂꍇ肤B
        */
        public float Height
        {
            get { return bottom - top; }
        }

        /// PRectւ̃r[Ԃ
        public Rect GetRect()
        {
            Rect rc = new Rect();
            rc.SetRect(left, top, right, bottom);
            return rc;
        }
    }

    /// <summary>
    /// [W`NX
    /// `GtFNgɎgƕ֗ł
    /// 
    /// Eʏ̕`
    /// E``̃}XN
    /// ŕ`\
    /// </summary>
    public static class ApartRegion
    {
        /// <summary>
        /// At@teNX`番`𐶐܂
        /// ʂ͓񎟌zƂĕԋp܂(񎟌łΕꂽcTCY킩)
        /// </summary>
        /// <param name="surface"></param>
        /// <param name="divWidth"></param>
        /// <param name="divHeight"></param>
        /// <returns></returns>
        public static RectF[][] ApartFromTexture(Surface surface, int divWidth, int divHeight)
        {
            if (null == surface) return null;

            Rect rc = new Rect();

            int width = (int)surface.Width;
            int height = (int)surface.Height;
            // TCY
            int sx;
            int sy;

            sx = width / divWidth;
            sy = height / divHeight;

            // TvƂ`񎟌z
            //RectF[][] rcSample = new RectF[][sy];
            RectF[][] rcSample = new RectF[sy][];
            for (int i = 0; i < rcSample.Length; i++)
            {
                rcSample[i] = new RectF[sx];
                for (int j = 0; j < rcSample[i].Length; j++)
                {
                    rcSample[i][j] = new RectF();
                }
            }

            //debug {
            //    Log.print("rcSample.length:%s\n", rcSample.length);
            //    Log.print("rcSample[].length:%s\n", rcSample[].length);
            //}

            // TvOgƂȂ`f[^
            for (int i = 0; i < sy; ++i)
            {
                for (int j = 0; j < sx; ++j)
                {
                    rcSample[i][j].left = j * divWidth;
                    rcSample[i][j].right = rcSample[i][j].left + divWidth;
                    rcSample[i][j].top = i * divHeight;
                    rcSample[i][j].bottom = rcSample[i][j].top + divHeight;
                }
            }



            // 摜ƔrLȃf[^ALȋ`̔z
            for (int i = 0; i < sy; ++i)
            {
                for (int j = 0; j < sx; ++j)
                {
                    // `L摜ɓɊ܂܂Ă
                    if (ContainRect(surface, rcSample[i][j]))
                    {
                        // tORectȂ̂[
                        rcSample[i][j].enable = true;
                    }
                }
            }

            return rcSample;
        }

        /// `̎l̃sNZAt@lOłȂtrue
        unsafe private static bool ContainRect(Surface surface, RectF rc)
        {
            int width = (int)surface.Width;
            int height = (int)surface.Height;
            // sNZf[^RGBAłȂł邩炱łnjłH
            Sdl.SDL.SDL_Color* pixels = (Sdl.SDL.SDL_Color*)surface.Pixels;
            int x, y;

            // 
            x = (int)rc.left;
            y = (int)rc.top;
            if (pixels[(y * width) + x].unused == 0)
            {
                return false;
            }

            // E
            x = (int)rc.right;
            y = (int)rc.top;
            if (pixels[(y * width) + x].unused == 0)
            {
                return false;
            }

            // 
            x = (int)rc.left;
            y = (int)rc.bottom;
            if (pixels[(y * width) + x].unused == 0)
            {
                return false;
            }

            // E
            x = (int)rc.right;
            y = (int)rc.bottom;
            if (pixels[(y * width) + x].unused == 0)
            {
                return false;
            }

            return true;
        }

        /// 񎟌z
        /// ʂ̔z͂PَzƂȂ
        public static List<RectF> UniteRect(RectF[][] rects, int uniteX, int uniteY)
        {
            int sx = rects[0].Length;
            int sy = rects.Length;
            List<RectF> rectResult = new List<RectF>(); ;
            bool[][] flags;

            // ȂȂƃTCYƂւ̂H
            sx = sy = 0;
            foreach (RectF[] rectLine in rects)
            {
                sy++;
                foreach (RectF rc in rectLine)
                {
                    sx++;
                }
            }
            sx /= sy;
            //debug {
            //    Log.print("sx : %s\n", sx);
            //    Log.print("sy : %s\n", sy);
            //}

            //assert( (sy - uniteY) > 0 );
            //assert( (sx - uniteX) > 0 );

            //flags.Length = sy;
            flags = new bool[sy][];

            for (int j = 0; j < flags.Length; j++)
            {
                flags[j] = new bool[sx];
                for (int i = 0; i < flags[j].Length; i++)
                {
                    flags[j][i] = false;
                }
            }

            for (int i = 0; i < (sy - uniteY); ++i)
            {
                for (int j = 0; j < (sx - uniteX); ++j)
                {
                    // ł납H
                    if (IsUnitable(rects, flags, j, i, uniteX, uniteY))
                    {
                        // ł邻...
                        RectF rc = new RectF(); ;

                        // ʒu
                        rc.left = rects[i][j].left;
                        rc.top = rects[i][j].top;

                        // Eʒu
                        rc.right = rects[i + uniteY - 1][j + uniteX - 1].right;
                        rc.bottom = rects[i + uniteY - 1][j + uniteX - 1].bottom;

                        // LۃtO
                        rc.enable = rects[i][j].enable;

                        rectResult.Add(rc);

                        // ꂽ̂̃tOĂĂ
                        FlagOn(flags, j, i, uniteX, uniteY);
                    }
                }
            }

            // Ȃ̂Ă
            for (int i = 0; i < sy; ++i)
            {
                for (int j = 0; j < sx; ++j)
                {
                    if (!flags[i][j])
                    {
                        rectResult.Add(rects[i][j]);
                    }
                }
            }

            return rectResult;
        }


        /// zposx,posÿʒuunitex,uniteyTCY̋`͌\ł邩H
        private static bool IsUnitable(RectF[][] rects, bool[][] flags, int posx, int posy, int uniteX, int uniteY)
        {
            int result = 0;

            for (int i = 0; i < uniteY; ++i)
            {
                for (int j = 0; j < uniteX; ++j)
                {

                    // ̋悪łɎgpς݂łΌs
                    if (flags[posy + i][posx + j])
                    {
                        return false;
                    }

                    if (rects[posy + i][posx + j].enable)
                    {
                        result += 1;
                    }
                }
            }

            // ʂ0(ʂׂČŒ), ܂ׂ͂ėLȂ true
            return (bool)((result == 0) || (result == (uniteX * uniteY)));
        }

        /// ̃tOĂ
        private static void FlagOn(bool[][] flags, int posx, int posy, int uniteX, int uniteY)
        {
            for (int i = 0; i < uniteY; ++i)
            {
                for (int j = 0; j < uniteX; ++j)
                {
                    flags[posy + i][posx + j] = true;
                }
            }
        }


    }
}
