using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Math;
using Yanesdk.Draw;
using Yamalib.Util;

namespace Yamalib.Draw.Effect
{

    public class FilmNoise
    {
        /// <summary>
        /// FilmNoiseNX̓߂GbZX
        /// </summary>
        public class FilmNoiseEssence
        {
            #region tB[ho

            private readonly Rand rand;
            private ITexture m_texture;	//!< mCYeNX`

            public ITexture Texture
            {
                get { return m_texture; }
                set { m_texture = value; }
            }
            private int m_alpha;

            public int Alpha
            {
                get { return m_alpha; }
                set { m_alpha = value; }
            }
            private bool m_reverse;	//!< ܂Ԃ`s

            public bool Reverse
            {
                get { return m_reverse; }
                set { m_reverse = value; }
            }
            private float m_speed;	// ړx

            public float Speed
            {
                get { return m_speed; }
                set { m_speed = value; }
            }
            private int m_startY;	// Jnʒu

            public int Start
            {
                get { return m_startY; }
                set { m_startY = value; }
            }
            private int m_endY;	// Iʒu

            public int End
            {
                get { return m_endY; }
                set { m_endY = value; }
            }
            private int m_posRand = 5;	//! `ʒũY

            public int PosRand
            {
                get { return m_posRand; }
                set { m_posRand = value; }
            }

            private float m_y;
            private bool m_revesing;
            private bool m_finish;


            #endregion

            /// <summary>
            /// RXgN^
            /// </summary>
            public FilmNoiseEssence()
            {
                rand = new Rand();
                rand.Randomize();
            }

            public bool IsFinish
            {
                get { return m_finish; }
                set { m_finish = value; }
            }

            /// LȃGbZX
            public bool IsValid()
            {
                if (this.Texture == null)
                {
                    return false;
                }
                return true;
            }

            /// ϐAē\ɂ܂
            public void Reset()
            {
                m_y = m_startY;
                m_revesing = false;
                IsFinish = false;
            }

            /// ړ
            public void OnMove(IScreen screen)
            {
                if (!IsValid() || m_finish)
                {
                    return;
                }

                if ((Start > End))
                {
                    // E獶

                    if (m_revesing)
                    {
                        m_y += m_speed;
                        if (m_y > Start)
                        {
                            CheckFlg();
                        }
                    }
                    else
                    {
                        m_y -= m_speed;
                        if (m_y < End)
                        {
                            CheckFlg();
                        }
                    }
                }
                else
                {
                    // E

                    if (m_revesing)
                    {
                        m_y = m_speed;
                        if (m_y < Start)
                        {
                            CheckFlg();
                        }
                    }
                    else
                    {
                        m_y += m_speed;
                        if (m_y > End)
                        {
                            CheckFlg();
                        }
                    }
                }
            }

            /// `揈
            public void OnDraw(IScreen screen)
            {
                if (!IsValid() || m_finish)
                {
                    return;
                }

                Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);
                screen.SetColor(colorOrg.R, colorOrg.G, colorOrg.B, this.m_alpha);
                screen.Blt(this.m_texture, (int)m_y + rand.GetRand(this.m_posRand), 0);
                screen.SetColor(colorOrg);
            }

            /// `g傠
            public void OnDraw(IScreen screen, float rate)
            {
                if (!IsValid() || m_finish)
                {
                    return;
                }

                Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);
                screen.SetColor(colorOrg.R, colorOrg.G, colorOrg.B, this.m_alpha);
                screen.BltRotate(this.m_texture,
                            (int)((m_y + rand.GetRand(this.m_posRand) * rate)), 0,
                            0,
                            rate,
                            0);
                screen.SetColor(colorOrg);
            }

            /// <summary>
            /// tOJڂs܂
            /// </summary>
            private void CheckFlg()
            {
                if (m_reverse)
                {
                    if (m_revesing)
                    {
                        m_finish = true;
                    }
                    else
                    {
                        m_revesing = true;
                    }
                }
                else
                {
                    m_finish = true;
                }
            }
        }

        /// <summary>
        /// FilmNoiseNX̑Ŝ̓߂GbZX
        /// </summary>
        public class FilmNoiseEssenceManager
        {
            #region otB[h

            private readonly Rand rand = new Rand();
            private readonly List<FilmNoiseEssence> m_essencese = new List<FilmNoiseEssence>();
            private TextureLoader m_noiseTextureLoader;
            private int m_noiseTextureNum = 0;
            private int m_showNum = 3;	//!< ʂɕ\őmCY
            private int m_createInterval = 100;
            private int m_drawNoiseMax;
            private int m_drawNoiseRand;
            private readonly List<bool> m_unuseFlg = new List<bool>();
            private float m_rate = 1.0f;

            #endregion

            /// <summary>
            /// RXgN^
            /// </summary>
            public FilmNoiseEssenceManager()
            {
                rand.Randomize();
            }

            /// mCYeNX`Zbg̐ݒ		
            public void SetNoiseTextureLoader(TextureLoader tl, int elementNum)
            {
                this.m_noiseTextureLoader = tl;
                m_noiseTextureNum = elementNum;
            }
            public TextureLoader GetNoiseTextureLoader()
            {
                return this.m_noiseTextureLoader;
            }
            public int GetNoiseTextureNum()
            {
                return m_noiseTextureNum;
            }

            /// mCY`悷鐔
            public void SetDrawNoiseNum(int max_, int rand_)
            {
                this.m_drawNoiseMax = max_;
                this.m_drawNoiseRand = rand_;
            }
            public int GetDrawNoiseMax()
            {
                return this.m_drawNoiseMax;
            }
            public int GetDrawNoiseRand()
            {
                return this.m_drawNoiseRand;
            }

            /// ʂɕ\ő僉CmCY
            public void SetMaxShowNum(int num)
            {
                m_showNum = num;
            }
            public int GetMaxShowNum()
            {
                return this.m_showNum;
            }

            /// mCY𐶐܂ł̃C^[oݒ肷
            public void SetCreateInterval(int interval)
            {
                this.m_createInterval = interval;
            }
            public int GetCreateInterval()
            {
                return this.m_createInterval;
            }

            /// g嗦̐ݒ
            public void SetRate(float rate)
            {
                this.m_rate = rate;
            }
            public float GetRate()
            {
                return this.m_rate;
            }


            /// ׂẴGbZX擾
            public List<FilmNoiseEssence> GetEssenceAll()
            {
                return this.m_essencese;
            }

            /// w肵GbZX擾		
            public FilmNoiseEssence GetEssence(int index)
            {
                if (index >= this.m_essencese.Count)
                {
                    return null;
                }
                return this.m_essencese[index];
            }

            /// gp̃GbZX_Ŏ擾
            /// gp^gp̃}[J[͂ŕt^̂ŁA̎QƂŎgĂĂ֒mȂ
            public FilmNoiseEssence GetUnuseEssenceRand()
            {
                List<int> unuseIndex = new List<int>();
                int i = 0;
                foreach (bool b in m_unuseFlg)
                {
                    if (b)
                    {
                        unuseIndex.Add(i);
                    }
                    ++i;
                }

                int index = rand.GetRand(unuseIndex.Count);
                int num = unuseIndex[index];

                //printf(" %d", num);
                return GetEssence(num);
            }

            /// gpEgp}[J[񂵁AÎ𖢎gpɃ}[N
            public void CheckUsedEssence()
            {
                int i = 0;
                foreach (bool b in m_unuseFlg)
                {
                    if (!b)
                    {
                        if (m_essencese[i].IsFinish)
                        {
                            m_unuseFlg[i] = true;
                        }
                    }
                    ++i;
                }
            }

            /// 폜
            public void Clear()
            {
                m_essencese.Clear();
                m_unuseFlg.Clear();
            }

            /// ǉ
            public void AddEssence(FilmNoiseEssence essence)
            {
                if (essence.IsValid())
                {
                    m_unuseFlg.Add(true);
                    m_essencese.Add(essence);
                }
            }
        }

        #region otB[h

        private readonly Rand rand = new Rand();
        private FilmNoiseEssenceManager m_essenceMgr;	//!< ̃NX̓߂GbZX
        private List<FilmNoiseEssence> m_useEssence;
        private long m_intervalCount;
        private long m_nextCreate;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public FilmNoise(FilmNoiseEssenceManager essence)
        {
            rand.Randomize();
            this.m_essenceMgr = essence;
            this.m_useEssence = new List<FilmNoiseEssence>();
            // mCY𐶐鎞Ԃ߂Ă
            m_nextCreate = rand.GetRand(this.m_essenceMgr.GetCreateInterval());
        }

        /// }l[W擾
        public FilmNoiseEssenceManager GetManager()
        {
            return this.m_essenceMgr;
        }

        /// ړ
        public void OnMove(IScreen screen)
        {

            if (m_intervalCount >= m_nextCreate)
            {

                // ܂͏ImCYNA
                int idx = 0;
                List<int> delIndex = new List<int>();
                foreach (FilmNoiseEssence essence in m_useEssence)
                {
                    if (essence.IsFinish)
                    {
                        delIndex.Add(idx);
                    }
                    ++idx;
                }
                for (int i = delIndex.Count - 1; i >= 0; --i)
                {
                    m_useEssence.RemoveAt(i);
                }
                this.m_essenceMgr.CheckUsedEssence();

                // TCY`FbN
                if (m_useEssence.Count < this.m_essenceMgr.GetMaxShowNum())
                {
                    m_useEssence.Add(GetEssence());
                }
            }

            foreach (FilmNoiseEssence essence in m_useEssence)
            {
                essence.OnMove(screen);
            }

            ++m_intervalCount;
        }

        /// }l[WGbZX̎擾
        public FilmNoiseEssence GetEssence()
        {
            FilmNoiseEssence essence = this.m_essenceMgr.GetUnuseEssenceRand();
            essence.Reset();
            m_nextCreate = rand.GetRand(this.m_essenceMgr.GetCreateInterval());
            m_intervalCount = 0;
            return essence;
        }

        public ITexture GetNoiseTextureRand()
        {
            if (m_essenceMgr.GetNoiseTextureLoader() == null)
            {
                return null;
            }
            TextureLoader noiseTextureLoader = m_essenceMgr.GetNoiseTextureLoader();
            return noiseTextureLoader.GetTexture(rand.GetRand(m_essenceMgr.GetNoiseTextureNum()));
        }

        /// `揈
        public void OnDraw(IScreen screen)
        {

            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);
            float rate = m_essenceMgr.GetRate();

            // mCY`
            if (!(m_essenceMgr.GetNoiseTextureLoader() == null))
            {
                int drawNum = m_essenceMgr.GetDrawNoiseRand() == 0 ?
                    m_essenceMgr.GetDrawNoiseMax() :
                     m_essenceMgr.GetDrawNoiseMax() - rand.GetRand(m_essenceMgr.GetDrawNoiseRand());
                int sx = screen.Width;
                int sy = screen.Height;
                screen.SetColor(colorOrg.R, colorOrg.G, colorOrg.B, 128);

                if (rate == 1.0f || rate == float.NaN)
                {
                    for (int i = 0; i < drawNum; ++i)
                    {
                        screen.Blt(GetNoiseTextureRand(), rand.GetRand(sx), rand.GetRand(sy));
                    }
                }
                else
                {
                    for (int i = 0; i < drawNum; ++i)
                    {
                        screen.BltRotate(GetNoiseTextureRand(),
                                    (int)(rand.GetRand(sx) * rate),
                                    (int)(rand.GetRand(sy) * rate),
                                    0,
                                    rate,
                                    0);
                    }
                }

                screen.SetColor(colorOrg);
            }

            foreach (FilmNoiseEssence essence in m_useEssence)
            {
                if (rate == 1.0f || rate == float.NaN)
                {
                    essence.OnDraw(screen);
                }
                else
                {
                    essence.OnDraw(screen, rate);
                }
            }
        }
    }

    public static class FilmNoiseEssenceCreator
    {
        #region otB[h

        private static readonly Rand rand = new Rand();
        private static int maxWidthRand = 0;
        private static int maxWidth = 100;
        private static int maxAlpha = 255;
        private static int maxAlphaRand = 0;
        private static int start;
        private static int end;
        private static float maxSpeed = 1.0f;
        private static float maxSpeedRand = 0.0f;
        private static bool reverseDefault = false;
        private static bool reverseDefaultRand = true;

        #endregion


        /// GbZX̍ő啝ƁA̍ő啝̃_l
        public static void SetMaxWidth(int width, int randWidth)
        {
            maxWidth = width;
            maxWidthRand = randWidth;
        }

        /// GbZX̍ő呬xƁA̍ő呬x̃_l
        public static void SetMaxSpeed(float maxSpeed_, float randSpeed_)
        {
            maxSpeed = maxSpeed_;
            maxSpeedRand = randSpeed_;
        }

        /// JnʒuƏIʒû͈̔
        public static void SetRange(int start_, int end_)
        {
            if (start > end)
            {
                start = end_;
                end = start_;
            }
            else
            {
                start = start_;
                end = end_;
            }
        }

        /// GbZX̍őAt@ƁA̍őAt@̃_l
        public static void SetMaxAlpha(int maxAlpha_, int alphaRand_)
        {
            maxAlpha = maxAlpha_;
            maxAlphaRand = alphaRand_;
        }

        /// GbZX̃ftHg̐܂ԂݒƁA̐܂Ԃ_Ō肷邩
        public static void SetReverseDefault(bool def, bool reverseRand)
        {
            reverseDefault = def;
            reverseDefaultRand = reverseRand;
        }

        /// GbZX쐬ԋp
        public static FilmNoise.FilmNoiseEssence Create()
        {
            FilmNoise.FilmNoiseEssence essence = new FilmNoise.FilmNoiseEssence();

            int width = maxWidthRand == 0 ? maxWidth : maxWidth - rand.GetRand(maxWidthRand);
            int alpha = maxAlphaRand == 0 ? maxAlpha : maxAlpha - rand.GetRand(maxAlphaRand);
            float speed = (maxSpeedRand == 0.0f || maxSpeedRand == float.NaN) ? maxSpeed :
                maxSpeed - (rand.GetRand((int)(maxSpeedRand * 256)) / 256.0f);
            bool reverse = reverseDefaultRand ? rand.GetRand(2) == 0 : reverseDefault;

            essence.Start = start + rand.GetRand(end - start);
            essence.End = rand.GetRand(2) == 0 ? essence.Start - width : essence.Start + width;
            essence.Speed = speed;
            essence.Alpha = alpha;
            essence.Reverse = reverse;

            return essence;
        }


    }

    public class FilmNoiseBgDraw
    {
        #region otB[h

        private Rand rand;
        private int m_interval;
        private int m_duration;
        private int m_orgDuration;
        private int m_yRand;

        private ITexture m_oldTexture;
        private bool m_noiseDraw;
        private int m_randSize;
        private long m_nextCount;
        private long m_durationCount;
        private long m_intervalCount;

        #endregion

        /// RXgN^
        public FilmNoiseBgDraw(int interval, int yRand, int duration)
        {
            rand = new Rand();
            rand.Randomize();
            m_interval = interval;
            m_yRand = yRand;
            m_orgDuration = m_duration = duration;
            m_nextCount = rand.GetRand(interval);
        }

        /// mCYnmɂ
        public void NoiseDrawNow(int dy, int duration)
        {
            NoiseDrawOn(dy);
            m_duration = duration;
        }

        /// A`悵ĂƂ납H
        public bool IsNoising()
        {
            return this.m_noiseDraw;
        }

        /// ړ
        public void OnMove(IScreen screen)
        {

            if (m_noiseDraw)
            {
                ++m_durationCount;
                if (m_durationCount >= m_duration)
                {
                    m_noiseDraw = false;
                    m_durationCount = 0;
                    m_duration = m_orgDuration;
                    m_oldTexture = null;
                }
            }
            else
            {
                if (m_intervalCount >= m_nextCount)
                {
                    NoiseDrawOn(rand.GetRand(m_yRand) - (m_yRand / 2));
                }
                else
                {
                    m_noiseDraw = false;
                }
                ++m_intervalCount;
            }
        }

        /// `揈
        public void OnDraw(IScreen screen, ITexture texture, int x, int y)
        {
            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);

            if (m_noiseDraw)
            {
                if (m_oldTexture == null)
                {
                    screen.Blt(texture, x, y);
                }
                else
                {
                    screen.Blt(m_oldTexture, x, y);
                }
                screen.SetColor(255, 255, 255, colorOrg.A / 2);
                screen.Blt(texture, x, y + m_randSize);
            }
            else
            {
                screen.Blt(texture, x, y);
                m_oldTexture = texture;

            }

            screen.SetColor(colorOrg);
        }

        /// DrawAssistgpĕ`
        public void OnDraw(DrawAssist.Context context,
                IScreen screen, ITexture texture, int x, int y)
        {
            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);

            if (m_noiseDraw)
            {
                if (m_oldTexture == null)
                {
                    DrawAssist.Blt(screen, texture, x, y, context);
                }
                else
                {
                    DrawAssist.Blt(screen, m_oldTexture, x, y, context);
                }
                screen.SetColor(255, 255, 255, colorOrg.A / 2);
                DrawAssist.Blt(screen, texture, x, y + m_randSize, context);
            }
            else
            {
                DrawAssist.Blt(screen, texture, x, y, context);
                m_oldTexture = texture;
            }

            screen.SetColor(colorOrg);
        }

        /// <summary>
        /// noiseDraw̏ dy = ꕝ
        /// </summary>
        /// <param name="dy"></param>
        private void NoiseDrawOn(int dy)
        {
            m_nextCount = rand.GetRand(m_interval);
            m_randSize = dy;
            m_intervalCount = 0;
            m_noiseDraw = true;
        }
    }
}
