using System;
using System.Collections.Generic;
using System.Text;
using Yamalib.Util;
using Yanesdk.Draw;
using System.Diagnostics;
using Yanesdk.Timer;
using Yanesdk.System;
using Yanesdk.Ytl;

namespace Yamalib.Draw.Effect
{
    public class SlideShadeDraw
    {

        public class DrawObj
        {
            #region 萔l

            /// ItZbg̃^Cv
            public enum OFFSET_TYPE { LT, CENTER };
            /// `̃^Cv
            public enum DRAW_TYPE : int { NORMAL = 0, DUAL_LR, DUAL_TB };

            private const int MAX_RESOLUTION = 64;
            //private static int SOFT_SIZE = 2;

            #endregion

            /// \̐ݒ
            public void SetResolution(int res)
            {
                if (res > 0)
                {
                    resolution = res;
                }
            }

            /// eNX`[_ݒ肷
            public void SetTextureLoader(TextureLoader tl, int elementNum)
            {
                Debug.Assert(tl != null);
                imgTextures = tl;
                //			Texture =  textureLoader.Get(0);
                SetResolution(elementNum);
                // HĂ
                for (int i = 0; i < elementNum; ++i)
                {
                    imgTextures.GetTexture(i);
                }
            }

            public bool IsEnable(int[] index, int val)
            {
                foreach (int i in index)
                {
                    if (i == val)
                    {
                        return true;
                    }
                }
                return false;
            }

            /// IĂ邩
            public bool IsEnd()
            {
                return m_index.IsEnd;
            }

            /// Xs[h̐ݒ
            public void SetSpeed(int speed_)
            {
                m_index.Set(0, resolution - 1, speed_);
                m_alpha.Set(0, 255, speed_);
                m_alphaDiv.Set(0, 255, (int)(255 / (speed_ / (float)resolution)));
            }

            /// `ʒu̐ݒ
            public void SetDrawPos(int x_, int y_, OFFSET_TYPE type)
            {
                m_x = x_;
                m_y = y_;
                m_type = type;
            }

            /// `^Cv̐ݒ
            public void SetDrawType(DRAW_TYPE type_, int dstPos)
            {
                m_drawType = type_;

                int startPos;
                int endPos;

                if (!m_reverse)
                {
                    // ڕWʒuɋ߂Â
                    startPos = dstPos;
                    endPos = 0;
                }
                else
                {
                    // ڕWʒu牓̂
                    endPos = dstPos;
                    startPos = 0;
                }

                switch (m_drawType)
                {
                    case DRAW_TYPE.DUAL_TB:
                        m_offsetx.Set(0, 0, 0);
                        m_offsety.Set(startPos, endPos, m_index.StepValue);
                        break;

                    case DRAW_TYPE.DUAL_LR:
                        m_offsetx.Set(startPos, endPos, m_index.StepValue);
                        m_offsety.Set(0, 0, 0);
                        break;

                    default:
                        m_offsetx.Set(0, 0, 0);
                        m_offsety.Set(0, 0, 0);
                        break;
                }
            }

            /// Đ̐ݒ
            public void SetReverse(bool b)
            {
                if (m_reverse != b)
                {
                    m_index.Reset();
                    m_offsetx.Reset();
                    m_offsety.Reset();
                    m_alpha.Reset();
                }
                m_reverse = b;

            }

            /// Đ̎擾
            public bool IsReverse()
            {
                return m_reverse;
            }

            /// 쏈
            public void OnMove(IScreen screen)
            {
                int pre = m_index.Value();
                //			m_alphaDiv.inc();
                m_index.Inc();
                int now = m_index.Value();
                if (now != pre)
                {
                    m_textureSub = m_texture;
                    if (!m_reverse)
                    {
                        m_texture = imgTextures.GetTexture(resolution - now - 1);
                    }
                    else
                    {
                        m_texture = imgTextures.GetTexture(now);
                    }
                    m_alphaDiv.Reset();
                }

                m_offsetx.Inc();
                m_offsety.Inc();
                m_alpha.Inc();
            }

            /// `揈
            public void OnDraw(IScreen screen)
            {
                if (m_texture == null)
                {
                    return;
                }
                int x, y;
                switch (m_type)
                {
                    case OFFSET_TYPE.CENTER:
                        int w = (int)m_texture.Width;
                        int h = (int)m_texture.Height;
                        x = m_x - (w / 2);
                        y = m_y - (h / 2);
                        break;

                    default:
                        x = m_x;
                        y = m_y;
                        break;
                }

                // `^Cvɍ킹ĕ`
                switch (m_drawType)
                {
                    case DRAW_TYPE.DUAL_TB:
                    case DRAW_TYPE.DUAL_LR:
                        if (m_offsetx.Value() == 0 && m_offsety.Value() == 0)
                        {
                            screen.SetColor(255, 255, 255, m_alpha.Value());
                            screen.Blt(m_texture, x, y);
                        }
                        else
                        {
                            int alpha;
                            if (m_reverse)
                            {
                                alpha = 255 - m_alpha.Value();
                            }
                            else
                            {
                                alpha = m_alpha.Value();
                            }
                            screen.SetColor(255, 255, 255, alpha);

                            screen.Blt(m_texture, x + m_offsetx.Value(), y + m_offsety.Value());
                            screen.Blt(m_texture, x - m_offsetx.Value(), y - m_offsety.Value());
                        }
                        break;

                    default:
                        screen.SetColor(255, 255, 255, m_alpha.Value());
                        screen.Blt(m_texture, x, y);
                        //				screen.bltRotate(Texture, X, Y, 0,2,4);
                        break;
                }

            }

            /// 
            public void Release()
            {
            }

            /// RXgN^
            public DrawObj()
            {
                m_index = new InteriorCounter();
                m_index.Set(0, resolution, resolution - 1);

                m_offsetx = new InteriorCounter();
                m_offsetx.Set(0, 0, 1);
                m_offsety = new InteriorCounter();
                m_offsety.Set(0, 0, 1);

                m_alpha = new InteriorCounter();
                m_alpha.Set(0, 128, 128);

                m_type = OFFSET_TYPE.LT;
                m_drawType = DRAW_TYPE.NORMAL;

                m_alphaDiv = new RootCounter();
            }

            ///// fXgN^
            //~this() {
            //    Release();
            //}

            #region otB[h

            private int resolution = 96;
            private TextureLoader imgTextures;
            private ITexture m_texture;
            private ITexture m_textureSub;
            private RootCounter m_alphaDiv;
            private bool m_reverse;		//!< ӁII ڂOڂĂȂture
            private InteriorCounter m_index;
            private int m_x;
            private int m_y;
            private InteriorCounter m_offsetx;
            private InteriorCounter m_offsety;
            private InteriorCounter m_alpha;
            private OFFSET_TYPE m_type;
            private DRAW_TYPE m_drawType;

            #endregion
        }

        /// <summary>
        /// `NX
        /// </summary>
        public class DrawInfo
        {
            private DrawObj.DRAW_TYPE drawtype;

            public DrawObj.DRAW_TYPE Drawtype
            {
                get { return drawtype; }
                set { drawtype = value; }
            }
            private int moveto;

            public int Moveto
            {
                get { return moveto; }
                set { moveto = value; }
            }
            private long time;

            /// <summary>
            /// Jnms
            /// </summary>
            public long Time
            {
                get { return time; }
                set { time = value; }
            }
            private long wait;

            /// <summary>
            /// \
            /// </summary>
            public long Wait
            {
                get { return wait; }
                set { wait = value; }
            }
            private long waitMark;

            /// <summary>
            /// ~Jnms
            /// </summary>
            public long WaitMark
            {
                get { return waitMark; }
                set { waitMark = value; }
            }
            private bool waitFlg;

            public bool IsWait
            {
                get { return waitFlg; }
                set { waitFlg = value; }
            }
            private bool finish;

            public bool IsFinish
            {
                get { return finish; }
                set { finish = value; }
            }
            private DrawObj drawobj;

            public DrawObj Drawobj
            {
                get { return drawobj; }
                set { drawobj = value; }
            }
        }

        #region 萔l

        private static readonly char[] DELIM = ",".ToCharArray();
        // 
        private static readonly string PROP_KEY_OBJECTS = "objects";
        //private static readonly string PROP_KEY_RESOLUTION = "resolution";
        private static readonly string PROP_KEY_FADETIME = "fadetime";
        // JԂ
        private static readonly string PROP_KEY_FILENAME = ".filename";
        private static readonly string PROP_KEY_DRAWTYPE = ".drawtype";
        private static readonly string PROP_KEY_POSX = ".posx";
        private static readonly string PROP_KEY_POSY = ".posy";
        private static readonly string PROP_KEY_SIZEX = ".sizex";
        private static readonly string PROP_KEY_SIZEY = ".sizey";
        private static readonly string PROP_KEY_TIME = ".time";
        private static readonly string PROP_KEY_MOVETO = ".moveto";
        private static readonly string PROP_KEY_WAIT = ".IsWait";

        #endregion

        #region otB[h

        private readonly FixTimer m_timer;
        private List<DrawInfo> draws = new List<DrawInfo>();
        private bool init = false;

        #endregion

        /// `悷IuWFNg쐬	
        public static DrawInfo CreateDrawInfo(TextureLoader textureLoader, int imgElementNum, int drawType, int x, int y, int sizex,
               int sizey, int time, int moveto, int wait, int fadeTime)
        {
            //textureLoader.setCacheSize(-1);
            DrawObj dobj = new DrawObj();
            dobj.SetTextureLoader(textureLoader, imgElementNum);
            dobj.SetSpeed(fadeTime);
            dobj.SetDrawPos(x, y, DrawObj.OFFSET_TYPE.CENTER);

            DrawInfo di = new DrawInfo();
            di.Drawobj = dobj;
            di.Time = time;
            di.Wait = wait;
            di.Drawtype = (DrawObj.DRAW_TYPE)drawType;
            di.Moveto = moveto;
            return di;
        }

        /// RtBOǂݍ
        public static SlideShadeDraw CreateInstance(string configFile, SmartTextureLoader smartTextureLoader)
        {
            SlideShadeDraw instance = new SlideShadeDraw();
            try
            {
                Properties prop = Properties.GetInstance(configFile);
                //auto objSig = std.string.split( prop.getProperty((string) PROP_KEY_OBJECTS), DELIM );
                string[] objSig = prop.GetProperty(PROP_KEY_OBJECTS).Split(DELIM);
                Debug.Assert(objSig != null);

                string filename;
                int drawType;
                int posx;
                int posy;
                int sizex;
                int sizey;
                int time;
                int moveto;
                int wait;
                int fadetime = (int)prop.GetPropertyNum(PROP_KEY_FADETIME, -1);
                foreach (string sig in objSig)
                {
                    filename = prop.GetProperty(sig + PROP_KEY_FILENAME);
                    drawType = (int)prop.GetPropertyNum(sig + PROP_KEY_DRAWTYPE, -1);
                    posx = (int)prop.GetPropertyNum(sig + PROP_KEY_POSX, -1);
                    posy = (int)prop.GetPropertyNum(sig + PROP_KEY_POSY, -1);
                    sizex = (int)prop.GetPropertyNum(sig + PROP_KEY_SIZEX, -1);
                    sizey = (int)prop.GetPropertyNum(sig + PROP_KEY_SIZEY, -1);
                    time = (int)prop.GetPropertyNum(sig + PROP_KEY_TIME, -1);
                    moveto = (int)prop.GetPropertyNum(sig + PROP_KEY_MOVETO, -1);
                    wait = (int)prop.GetPropertyNum(sig + PROP_KEY_WAIT, -1);

                    //Log.printLook("NOW LOAD name=[%s], time=%s moveto=%s, IsWait=%s", filename, time, moveto, IsWait);

                    instance.AddDrawInfo(CreateDrawInfo(smartTextureLoader.LoadDefFile(filename, false), GetElementNum(filename), drawType, posx, posy, sizex, sizey,
                        time, moveto, wait, fadetime));
                }
            }
            catch (Exception e)
            {
                //Log.printFatal("SlideShadeDraw#onLoad : [%s]", e.toString());
                throw e;
            }

            //Log.print("Load FINISH");
            return instance;
        }

        /// <summary>
        /// `t@CAvfJEgĕԋp
        /// </summary>
        /// <param name="filename"></param>
        /// <returns></returns>
        private static int GetElementNum(string filename)
        {
            FilenamelistReader reader = new FilenamelistReader();
            YanesdkResult result = reader.LoadDefFile(filename, 1);
            if (result == YanesdkResult.NoError)
            {
                return reader.Data.Count;
            }
            return 0;
        }

        /// `IuWFNgǉ
        public void AddDrawInfo(DrawInfo drawInfo)
        {
            if (drawInfo != null)
            {
                draws.Add(drawInfo);
            }
        }

        /// Ăяo
        public int OnMove(IScreen screen)
        {
            m_timer.Update();
            int now = m_timer.Time;

            if (!init)
            {
                // ^C}[Zbg
                init = true;
                m_timer.Reset();
            }

            foreach (DrawInfo di in draws)
            {
                if (now >= di.Time && !di.IsFinish)
                {
                    di.Drawobj.OnMove(screen);
                    if (di.Drawobj.IsEnd())
                    {
                        if (!di.Drawobj.IsReverse())
                        {
                            if (!di.IsWait)
                            {
                                di.IsWait = true;
                                di.WaitMark = now;
                            }
                            // Ă
                            if (now >= di.WaitMark + di.Wait)
                            {
                                di.Drawobj.SetReverse(true);
                                di.Drawobj.SetDrawType(di.Drawtype, di.Moveto);
                            }
                        }
                        else
                        {
                            // I
                            di.IsFinish = true;
                        }
                    }
                }
            }

            return 0;
        }

        /// `揈
        public int OnDraw(IScreen screen)
        {
            long now = m_timer.Time;
            foreach (DrawInfo di in draws)
            {
                if (now >= di.Time && !di.IsFinish)
                {
                    di.Drawobj.OnDraw(screen);
                }
            }
            return 0;
        }

        public bool IsEnd()
        {
            if (draws == null)
            {
                return true;
            }
            foreach (DrawInfo di in draws)
            {
                if (!di.IsFinish)
                {
                    return false;
                }
            }
            return true;
        }

        /// ԂZbg
        public void Reset()
        {
            Destroy();
            draws = null;
            init = false;
        }

        /// f[^擾
        public List<DrawInfo> GetDrawInfo()
        {
            return draws;
        }

        /// LĂ郁
        public void Destroy()
        {
            foreach (DrawInfo di in draws)
            {
                if (di.Drawobj != null)
                {
                    di.Drawobj.Release();
                }
            }
        }

        /// RXgN^
        public SlideShadeDraw()
        {
            m_timer = new FixTimer();
        }


        /// <summary>
        /// T[tFCX̃Rs[Ԃ
        /// </summary>
        /// <param name="surface_"></param>
        /// <returns></returns>
        private static Surface CopySurface(Surface surface_)
        {
            int width = (int)surface_.Width;
            int height = (int)surface_.Height;

            bool alpha = surface_.Alpha;

            // createDIBē]ق͂₢łȂ...
            Surface surface = new Surface();
            surface.CreateDIB(width, height, alpha);

            surface.Blt(surface_, 0, 0);
            return surface;
        }

    }
}
