using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using System.Diagnostics;
using Yanesdk.Math;
using Yanesdk.System;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// ɎԂLȂ`悷鉉o`NX
    /// </summary>
    public class SpreadString
    {
        #region 萔l

        public enum BASE_POS { LEFT, CENTER, RIGHT };

        #endregion

        #region otB[h

        static SinTable sin = null;

        // `敶̃|Wg
        FontRepository fontRepository;
        // `敶̑傫
        float rate = 1.0f;
        // px
        int rad = 0;
        // `撆̕eNX`
        Textures textureVec;
        // `悵Ă镶
        string drawString;
        /// `At@
        int alpha = 255;
        ///@ԃJE^[
        IDecimalCounter spaceCounter;

        #endregion


        /// RXgN^
        public SpreadString(FontRepository fontRepository_)
        {
            Debug.Assert(fontRepository_ != null);
            fontRepository = fontRepository_;
        }

        /// `悷镶ݒ肷
        public void SetStringUnicode(string str)
        {
            Debug.Assert(str != null);
            drawString = str;
            textureVec = fontRepository.GetTexture(str, 0);
        }
        public string GetStringUnicode()
        {
            return drawString;
        }

        /// g嗦ݒ
        public void SetRate(float rate_)
        {
            rate = rate_;
        }
        public float GetRate()
        {
            return rate;
        }

        public void SetRad(int rad_)
        {
            rad = rad_ % 512;
        }
        public int GetRad()
        {
            return rad;
        }

        /// At@ݒ
        public void SetAlpha(int alpha_)
        {
            alpha = alpha_;
        }
        public int GetAlpha()
        {
            return alpha;
        }

        /// ԃJE^[̐ݒ
        public void SetSpaceCounter(IDecimalCounter spaceCounter_)
        {
            Debug.Assert(spaceCounter_ != null);
            spaceCounter = spaceCounter_;
        }
        public IDecimalCounter GetSpaceCounter()
        {
            return spaceCounter;
        }

        public void OnMove(IScreen screen)
        {
            if (spaceCounter == null || textureVec == null)
            {
                return;
            }
            spaceCounter.Inc();
        }

        /// ݂̐ݒŕ`悷
        public void OnDraw(IScreen screen, int x, int y, BASE_POS basePos)
        {
            if (spaceCounter == null || textureVec == null)
            {
                return;
            }
            // IWiJ[ۑ
            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(screen);

            // At@ݒ
            screen.SetColor(colorOrg.R, colorOrg.G, colorOrg.B, alpha);
            float addWidth = 0;
            float spaceRate = (float)spaceCounter.GetDecimal();

            switch (basePos)
            {
                case BASE_POS.LEFT:
                    int i = 0;
                    foreach (Textures.TextureInfo textureInfo in textureVec.Infos)
                    {
                        screen.BltRotate(textureInfo.Texture,
                            (int)((x + textureInfo.PosX + addWidth)), y, 0, rate, 0);
                        addWidth += (spaceRate * rate);
                        ++i;
                    }
                    break;
                case BASE_POS.CENTER:
                    if (0 == rad)
                    {
                        DrawBaseCenter(screen, x, y);
                    }
                    else
                    {
                        DrawBaseCenterRad(screen, x, y);
                    }
                    break;
                case BASE_POS.RIGHT:
                    break;
            }

            // J[ǂ
            screen.SetColor(colorOrg);
        }

        /// Ԃ	
        public void Reset()
        {
            spaceCounter.Reset();
            drawString = null;
        }

        #region Jo


        private void DrawBaseCenterRad(IScreen screen, int x, int y)
        {
            if (sin == null)
            {
                sin = SinTable.Instance;
            }
            float addWidth = 0.0f;
            float spaceRate = (float)spaceCounter.GetDecimal();
            float offsetPos = GetConterOffsetPos();
            double r;
            int i = 0;
            foreach (Textures.TextureInfo textureInfo in textureVec.Infos)
            {
                r = (addWidth - offsetPos);
                screen.BltRotate(textureInfo.Texture,
                    (int)(x + (sin.CosDouble(rad) * r)),
                        (int)(y + sin.SinDouble(rad) * r), rad, rate, 4);
                addWidth += spaceRate + textureInfo.Texture.Width * rate;
                ++i;
            }
        }

        private void DrawBaseCenter(IScreen screen, int x, int y)
        {
            float addWidth = 0;
            float spaceRate = (float)spaceCounter.GetDecimal();
            float offsetPos = GetConterOffsetPos();
            int i = 0;
            foreach (Textures.TextureInfo textureInfo in textureVec.Infos)
            {
                screen.BltRotate(textureInfo.Texture,
                    (int)(x + addWidth - offsetPos),
                    y, 0, rate, 4);
                addWidth += spaceRate + textureInfo.Texture.Width * rate;
                ++i;
            }
        }

        private float GetConterOffsetPos()
        {
            List<Textures.TextureInfo> textureInfos = textureVec.Infos;
            if (textureInfos == null)
            {
                return 0.0f;
            }
            float spaceRate = (float)spaceCounter.GetDecimal();
            return ((textureVec.Width * rate) + (spaceRate * (textureInfos.Count - 1))) / 2.0f;
        }

        #endregion

    }

    /// <summary>
    /// SpreadString gpāA^u[sNX
    /// </summary>
    public class SpreadStringBlur
    {
        /// <summary>
        /// SpreadStringBlurNX̃GbZXIuWFNg
        /// </summary>
        public class EssencePram
        {
            private FontRepository frontFont;

            public FontRepository FrontFont
            {
                get { return frontFont; }
                set { frontFont = value; }
            }
            private FontRepository backFont;

            public FontRepository BackFont
            {
                get { return backFont; }
                set { backFont = value; }
            }
            private int spreadStartWidth;

            public int SpreadStartWidth
            {
                get { return spreadStartWidth; }
                set { spreadStartWidth = value; }
            }
            private int spreadEndWidth;

            public int SpreadEndWidth
            {
                get { return spreadEndWidth; }
                set { spreadEndWidth = value; }
            }
            private int spreadSpeed;

            public int SpreadSpeed
            {
                get { return spreadSpeed; }
                set { spreadSpeed = value; }
            }
            private int rad;

            public int Rad
            {
                get { return rad; }
                set { rad = value; }
            }
            private float frontRate = 1.0f;

            public float FrontRate
            {
                get { return frontRate; }
                set { frontRate = value; }
            }
            private float backRate = 1.0f;

            public float BackRate
            {
                get { return backRate; }
                set { backRate = value; }
            }
            private ICounter frontAlpha;

            public ICounter FrontAlpha
            {
                get { return frontAlpha; }
                set { frontAlpha = value; }
            }
            private ICounter backAlpha;

            public ICounter BackAlpha
            {
                get { return backAlpha; }
                set { backAlpha = value; }
            }

            public bool isValid()
            {
                return (frontFont != null) && (backFont != null);
            }
        }


        #region 萔l

        #endregion

        #region otB[h

        private EssencePram essenceParam;
        // `p
        private SpreadString frontString;
        // u[p
        private SpreadString backString;
        // X^[gҋ@
        private int startWait = 0;

        private int posx;
        private int posy;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="essenceParam_"></param>
        public SpreadStringBlur(EssencePram essenceParam_)
        {
            Debug.Assert(essenceParam_ != null);
            essenceParam = essenceParam_;

            if (!essenceParam.isValid())
            {
                throw new Exception("SpreadStringBlur : Invalid essenceParam");
            }

            frontString = new SpreadString(essenceParam.FrontFont);
            frontString.SetRad(essenceParam.Rad);
            frontString.SetRate(essenceParam.FrontRate);
            {
                IDecimalCounter widthCounter = new PowIncCounter();
                widthCounter.Set(essenceParam.SpreadStartWidth, essenceParam.SpreadEndWidth,
                    essenceParam.SpreadSpeed);
                frontString.SetSpaceCounter(widthCounter);
            }

            backString = new SpreadString(essenceParam.BackFont);
            backString.SetRad(essenceParam.Rad);
            backString.SetRate(essenceParam.BackRate);
            {
                IDecimalCounter widthCounter = new PowIncCounter();
                widthCounter.Set(essenceParam.SpreadStartWidth, essenceParam.SpreadEndWidth,
                    essenceParam.SpreadSpeed);
                backString.SetSpaceCounter(widthCounter);
            }
        }

        public void SetCounterBase(float baseValue)
        {
            PowIncCounter frontCounter = (PowIncCounter)frontString.GetSpaceCounter();
            if (frontCounter != null)
            {
                frontCounter.SetBase(baseValue);
            }
            PowIncCounter backCounter = (PowIncCounter)backString.GetSpaceCounter();
            if (backCounter != null)
            {
                backCounter.SetBase(baseValue);
            }
        }

        public EssencePram GetEssence()
        {
            return essenceParam;
        }

        public bool IsEndAlpha()
        {
            if (essenceParam.FrontAlpha != null)
            {
                if (!essenceParam.FrontAlpha.IsEnd)
                {
                    return false;
                }
            }
            if (essenceParam.BackAlpha != null)
            {
                if (!essenceParam.BackAlpha.IsEnd)
                {
                    return false;
                }
            }
            return true;
        }

        public void SetX(int x)
        {
            posx = x;
        }
        public int GetX()
        {
            return posx;
        }

        public void SetY(int y)
        {
            posy = y;
        }
        public int GetY()
        {
            return posy;
        }

        public void SetPosXY(int x, int y)
        {
            posx = x;
            posy = y;
        }

        public void GetPosXY(out int x, out int y)
        {
            x = posx;
            y = posy;
        }

        public void SetStartWait(int startWait_)
        {
            startWait = startWait_;
        }
        public int GetStatWait()
        {
            return startWait;
        }

        /// ̐ݒ
        public void SetStringUnicode(string str)
        {
            backString.SetStringUnicode(str);
            frontString.SetStringUnicode(str);
        }

        /// Ԃ
        public void Reset()
        {
            if (essenceParam.FrontAlpha != null)
            {
                essenceParam.FrontAlpha.Reset();
            }
            if (essenceParam.BackAlpha != null)
            {
                essenceParam.BackAlpha.Reset();
            }
            frontString.Reset();
            backString.Reset();
        }

        /// \̕摜擾
        public SpreadString GetFront()
        {
            return frontString;
        }

        /// ̕摜擾
        public SpreadString GetBack()
        {
            return backString;
        }

        public void OnMove(IScreen screen)
        {
            if (startWait > 0)
            {
                --startWait;
                return;
            }

            if (essenceParam.FrontAlpha != null)
            {
                essenceParam.FrontAlpha.Inc();
            }
            if (essenceParam.BackAlpha != null)
            {
                essenceParam.BackAlpha.Inc();
            }
            frontString.OnMove(screen);
            backString.OnMove(screen);
        }

        public void OnDraw(IScreen screen)
        {
            if (startWait > 0)
            {
                return;
            }

            if (essenceParam.FrontAlpha != null)
            {
                frontString.SetAlpha(essenceParam.FrontAlpha.Value());
            }
            if (essenceParam.BackAlpha != null)
            {
                backString.SetAlpha(essenceParam.BackAlpha.Value());
            }
            frontString.OnDraw(screen, posx, posy, SpreadString.BASE_POS.CENTER);
            backString.OnDraw(screen, posx, posy, SpreadString.BASE_POS.CENTER);
        }


    }
}
