using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Math;

namespace Yamalib.Draw.Effect
{
    public class SwallowDraw
    {
        #region tB[ho

        private readonly SinTable sin = SinTable.Instance;
        private readonly Rand rand = new Rand();

        private bool init;
        private bool fadein;
        private readonly RootCounter angle;
        private readonly InteriorCounter length;
        private readonly InteriorCounter rate;
        private readonly InteriorCounter alpha;
        private int x;
        private int y;
        private int endStep;
        private int length_val;
        private int drawWait;
        private ITexture texture;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public SwallowDraw()
        {
            rand.Randomize();

            angle = new RootCounter();
            angle.Set(0, 512, 1);

            length = new InteriorCounter();
            rate = new InteriorCounter();

            alpha = new InteriorCounter();

            length_val = 120;
        }

        /// \eNX`̐ݒ
        public void SetTexture(ITexture t_)
        {
            texture = t_;
        }

        /// \ʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// I܂ł̃Xebv̐ݒ
        public void SetEndStep(int n)
        {
            endStep = n;
            rate.Set(8 * 128, 64, n);
            length.Set(length_val, 0, n);
            alpha.Set(0, 255, 10);
            angle.opAssign(rand.GetRand(512));
        }

        /// S_̋̐ݒ
        public void SetLength(int n)
        {
            length_val = n;
        }

        /// px̐ݒ
        public void SetAngleSpeed(int n)
        {
            angle.StepValue = (n);
        }

        /// `悪I
        public bool IsEnd()
        {
            return (bool)(alpha.Value() == 0 && drawWait <= 0);
        }

        public void SetDrawWait(int n)
        {
            drawWait = n;
        }

        /// Ԃ̃Zbg
        public void Reset()
        {
            init = false;
            fadein = true;
            SetEndStep(endStep);
        }

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {

            if (texture == null) return;
            if (drawWait > 0)
            {
                drawWait--;
                return;
            }

            if (!init)
            {
                init = true;
            }

            int cx, cy, tx, ty;

            cx = (int)(screen.Width / 2);
            cy = (int)(screen.Height / 2);
            tx = (int)texture.Width;
            ty = (int)texture.Height;

            angle++;
            length++;
            rate++;
            alpha++;

            if (alpha.IsEnd && fadein)
            {
                fadein = false;
                alpha.Set(255, 0, endStep);
            }

            x = cx + sin.Sin(angle.Value(), length.Value());
            y = cy + sin.Cos(angle.Value(), length.Value());
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {
            if (texture == null) return;
            if (drawWait > 0)
            {
                return;
            }

            Color4ub color = YanesdkUtil.GetNowScreenColor(screen);
            screen.SetColor(255, 255, 255, alpha.Value());
            screen.BltRotate(texture, x, y, angle.Value(), rate.Value() / 128.0f, 4);

            screen.SetColor(color);
        }


    }
}
