using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// eNX`̃eLXgiɕ\Ă܂
    /// </summary>
    public class TexutralTextDraw
    {
        #region tB[ho

        private ITexture texture;
        private int tx;	// eNX`TCY
        private int ty;
        private int x;
        private int y;
        private int drawedLine;
        private bool drawEnd;
        private readonly RootCounter counter = new RootCounter();
        private int lineHeight;
        private readonly Rect drawRc = new Rect();

        #endregion

        /// <summary>
        /// \eNX`̐ݒ
        /// </summary>
        public ITexture Texture
        {
            get { return texture; }
            set
            {
                texture = value;
                // eNX`̃TCYۑ
                tx = (int)texture.Width;
                ty = (int)texture.Height;
                // JE^[Zbg
                counter.Set(0, tx, 1);
            }
        }

        /// <summary>
        /// eLXg̈s̍ݒ肵܂
        /// </summary>
        public int LineHeight
        {
            get { return lineHeight; }
            set { lineHeight = value; }
        }

        /// <summary>
        /// I
        /// </summary>
        public bool IsFinish
        {
            get { return drawEnd; }
        }

        /// <summary>
        /// `ʒu̐ݒ
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// <summary>
        /// `ʒu̎擾
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// <summary>
        /// \x̐ݒ
        /// </summary>
        /// <param name="n"></param>
        public void SetStep(int n)
        {
            counter.StepValue = n;
        }


        /// <summary>
        /// Zbg
        /// </summary>
        public void Reset()
        {
            drawEnd = false;
            drawedLine = 0;
        }

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {
            if (texture == null || drawEnd) return;

            counter.incS();

            if (counter.IsLapAround)
            {
                ++drawedLine;
                // `͏IH			
                if (drawedLine * lineHeight > ty)
                {
                    drawEnd = true;
                }
                counter.Reset();
            }
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {
            // eNX`ZbgĂ
            if (texture == null) return;


            // `
            if (drawedLine > 0)
            {
                drawRc.Left = 0;
                drawRc.Right = tx;
                drawRc.Top = 0;
                drawRc.Bottom = drawedLine * lineHeight;

                screen.Blt(texture, x, y, drawRc);
            }

            drawRc.Top = drawedLine * lineHeight;
            drawRc.Left = 0;
            drawRc.Right = counter.Value();
            drawRc.Bottom = drawRc.Top + lineHeight;

            if (drawRc.Bottom > ty)
            {
                drawRc.Bottom = ty;
            }

            screen.Blt(texture, x, y + drawedLine * lineHeight, drawRc);
        }

    }
}
