using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.GUIParts;
using Yanesdk.Draw;
using Yamalib.Input;
using Yamalib.Util;
using Yanesdk.Input;

namespace Yamalib.GUI
{
    /// <summary>
    /// Xg{bNX̍ڃf[^
    /// </summary>
    public interface ListBoxItem
    {
        void OnMove(IScreen screen);
        void OnDraw(IScreen screen);

        void SetPos(int x, int y);
        void GetPos(out int x, out int y);

        void SetSize(Size size);
        Size GetSize();

        bool IsSelect();
        void SetSelect(bool b);

        bool IsLClick();
        bool IsRClick();
    }

    /// <summary>
    /// Xg{bNX\ڂ̃VvȎ
    /// </summary>
    public class SimpleListBoxItem : ListBoxItem
    {

        #region otB[h

        private readonly static FontRepository fontRepository = new FontRepository(YamalibConst.FONT_REP_TEXTURE_FACTORY);

        private IMouseInput m_mouse;
        private int x;
        private int y;
        private Color4ub m_fontColor;			// tHg̃J[	
        private Color4ub m_selectedBackColor;	// IꂽwiJ[	
        private float m_rate;		// tHg̕TCY
        private bool m_select;
        private string m_text;
        private readonly List<ITexture> m_tex = new List<ITexture>();
        private bool m_lclick;
        private bool m_rclick;
        private Size m_areaSz;

        #endregion

        public static FontRepository FontRepository
        {
            get { return SimpleListBoxItem.fontRepository; }
        }


        /// RXgN^
        public SimpleListBoxItem(IMouseInput mouse_)
        {
            m_mouse = mouse_;
            m_rate = 1.0f;
            m_fontColor.SetColor(255, 255, 255);
            m_selectedBackColor.SetColor(0, 0, 0);
        }

        /// \
        public void SetText(string str)
        {
            m_tex.Clear();
            m_text = str;
            foreach (char c in m_text)
            {
                ITexture t = FontRepository.GetTexture(c, 0);
                if (t == null) continue;
                m_tex.Add(t);
            }
        }

        /// \eLXg擾
        public string GetText()
        {
            return m_text;
        }

        /// tHg̃[gݒ
        public void SetRate(float f_)
        {
            this.m_rate = f_;
        }

        /// tHg̐Fݒ
        public void SetFontColor(Color4ub color_)
        {
            this.m_fontColor = color_;
        }

        /// I𒆂̔wiJ[	
        public void SetSelBackColor(Color4ub color_)
        {
            this.m_selectedBackColor = color_;
        }

        #region ListBoxItem o

        public void OnMove(IScreen screen)
        {
            m_lclick = false;
            m_rclick = false;

            int mx, my;
            m_mouse.GetPos(out mx, out my);

            if (PtInRect(mx, my, x, y, x + (int)m_areaSz.Cx, y + (int)m_areaSz.Cy))
            {
                //Console.WriteLine("mx={0}, my={1}, left={2}, top={3}, right={4}, bottom={5}\n", mx, my, X, Y, X + m_areaSz.Cx, Y + m_areaSz.Cy);
                if (m_mouse.IsPush(MouseInput.Button.Left))
                {
                    m_lclick = true;
                }

                if (m_mouse.IsPush(MouseInput.Button.Right))
                {
                    m_rclick = true;
                }
            }
        }

        public void OnDraw(IScreen screen)
        {
            // n`
            if (m_select)
            {
                DrawSelected(screen, x, y);
            }

            Color4ub colOrg = YanesdkUtil.GetNowScreenColor(screen);

            screen.SetColor(this.m_fontColor);

            // ͎wɂȂ炤ƂāAۏ
            float sumW = 0.0f;
            foreach (ITexture t in m_tex)
            {
                float w = t.Width * m_rate;
                if (m_areaSz.Cx < sumW + w) break;
                screen.BltRotate(t, (int)(x + sumW), y, 0, m_rate, 0);
                sumW += w;
            }

            screen.SetColor(colOrg);
        }

        public void SetPos(int x, int y)
        {
            this.x = x;
            this.y = y;
        }

        public void GetPos(out int x, out int y)
        {
            x = this.x;
            y = this.y;
        }

        public void SetSize(Size size)
        {
            this.m_areaSz = size;
        }

        public Size GetSize()
        {
            return this.m_areaSz;
        }

        public bool IsSelect()
        {
            return this.m_select;
        }

        public void SetSelect(bool b)
        {
            this.m_select = b;
        }

        public bool IsLClick()
        {
            return m_lclick;
        }

        public bool IsRClick()
        {
            return m_rclick;
        }

        #endregion


        #region Jo

        /// _`̓ɂ邩ǂ
        private static bool PtInRect(int px, int py, int left, int top, int right, int bottom)
        {
            return (px >= left && px < right && py >= top && py < bottom);
        }

        /// Iwi̕`
        private void DrawSelected(IScreen screen, int x, int y)
        {
            Color4ub colOrg = YanesdkUtil.GetNowScreenColor(screen);
            screen.SetColor(m_selectedBackColor);

            screen.DrawPolygon(
                x, y,
                x + (int)m_areaSz.Cx, y,
                x + (int)m_areaSz.Cx, y + (int)m_areaSz.Cy,
                x, y + (int)m_areaSz.Cy
            );

            screen.SetColor(colOrg);
        }

        #endregion

    }

    /// <summary>
    /// WindowsListboxG~[g
    /// </summary>
    public class GUIListBox : ITextureGUI
    {

        #region otB[h

        private int x;
        private int y;
        private int m_topIndex;
        private ITexture m_base;
        private readonly List<ListBoxItem> items = new List<ListBoxItem>();
        private Scrollbar m_bar = new Scrollbar();
        private Rect m_area;
        private bool m_multiSel;
        private bool m_newSelect;
        private ControlContext controlContext;
        private bool visible = true;
        private IMouseInput mouse;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public GUIListBox()
        {
            m_bar = new Scrollbar();
        }

        #region ITextureGUI o

        public void OnInit(ControlContext cc)
        {
            controlContext = cc;
        }

        public void OnPaint(IScreen scr, ControlContext cc, int x, int y)
        {
        }

        public bool Visible
        {
            get
            {
                return visible;
            }
            set
            {
                visible = value;
            }
        }

        #endregion


        /// \GA̐ݒ
        public void SetArea(Rect rc)
        {
            m_area = rc;
            m_bar.SetSize(10, (int)rc.Height);
        }

        /// Xg{bNX̉nƂȂeNX`
        public void SetBaseTexture(ITexture t_)
        {
            this.m_base = t_;
        }

        /// XN[o[̐ݒ
        public void SetScrollbar(Scrollbar bar)
        {
            m_bar = bar;
        }

        /// XN[o[̎擾
        public Scrollbar GetScrollbar()
        {
            return m_bar;
        }

        /// I^s
        public void SetMultiSelectable(bool b)
        {
            m_multiSel = b;
        }

        /// ʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            this.x = x_;
            this.y = y_;
            m_bar.SetXY(x_, y_);
        }

        /// }EXݒ
        public void SetMouse(IMouseInput mouse_)
        {
            mouse = mouse_;
            //m_bar.SetMouse(mouse_);
        }

        /// Xg{bNXɃ}EXJ[\邩
        public bool IsInBox()
        {
            int mx, my;
            mouse.GetPos(out mx, out my);
            return PtInRect(mx, my, (int)m_area.Left, (int)m_area.Top, (int)m_area.Right, (int)m_area.Bottom);
        }

        /// IԂɂ
        public void SetSelect(int n)
        {
            if (n < 0) return;
            if (n >= this.items.Count) return;
            this.items[n].SetSelect(true);
            int i = 0;
            foreach (ListBoxItem item in items)
            {
                if (i != n)
                {
                    item.SetSelect(false);
                }
                ++i;
            }
        }

        /// IĂ΂OȏԋpBłȂ-1;
        public int GetSelectedNum()
        {
            int i = 0;
            foreach (ListBoxItem item in this.items)
            {
                if (item.IsSelect())
                {
                    return i;
                }
                ++i;
            }
            return -1;
        }


        /// VKIꂽ
        public bool IsNewSelect()
        {
            return this.m_newSelect;
        }

        /// z̎擾
        public int GetVHieght()
        {
            int size = 0;
            foreach (ListBoxItem item in items)
            {
                size += (int)item.GetSize().Cy;
            }
            return size;
        }

        /// ڂŌɒǉ
        public void AddItem(ListBoxItem item)
        {
            this.items.Add(item);
            m_bar.SetScrollSize(GetVHieght());
        }

        /// ڂǉ
        public void AddItemAll(List<ListBoxItem> items_)
        {
            foreach (ListBoxItem item in items_)
            {
                this.items.Add(item);
            }
        }

        /// Xg{bNXڂ̎擾
        public List<ListBoxItem> GetItemAll()
        {
            return this.items;
        }

        /// IĂACez擾
        public ListBoxItem GetSelectedItem()
        {
            int selectedIndex = GetSelectedNum();
            if (-1 == selectedIndex)
            {
                return null;
            }
            return GetItem(selectedIndex);
        }

        /// Xg{bNXڂ̎擾
        public ListBoxItem GetItem(int i)
        {
            if (i < 0 || i >= items.Count)
            {
                return null;
            }
            return items[i];
        }

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {
            m_newSelect = false;
            int newSel = -1;

            int i = 0;
            foreach (ListBoxItem item in items)
            {
                // ȌԂƂĕێ
                bool select = item.IsSelect();
                item.OnMove(screen);
                // Aꂽǂ̔
                if (item.IsLClick())
                {
                    if (!select)
                    {
                        newSel = i;
                        item.SetSelect(true);
                    }
                }
                ++i;
            }

            if (-1 != newSel && !m_multiSel)
            {
                m_newSelect = true;
                // IsŐVKI΁ASڃtOĐݒ
                int j = 0;
                foreach (ListBoxItem item in items)
                {
                    if (j != newSel)
                    {
                        item.SetSelect(false);
                    }
                    ++j;
                }
            }

            int scrollx, scrolly;
            m_bar.GetXY(out scrollx, out scrolly);
            m_bar.SetXY(scrollx, this.y);
            m_bar.OnMove(screen);

            float pos = m_bar.GetScrollPos();
            m_topIndex = (int)(pos * items.Count);
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {

            if (m_base != null)
            {
                screen.Blt(m_base, (int)m_area.Left, (int)m_area.Top);
            }

            int oy = 0;
            // ACe`
            for (int i = m_topIndex; i < items.Count; ++i)
            {
                Size sz = items[i].GetSize();

                if (sz.Cy + oy > m_area.Bottom)
                {
                    break;
                }

                items[i].SetPos(x, y + oy);
                items[i].OnDraw(screen);
                oy += (int)sz.Cy;
            }

            m_bar.OnDraw(screen);
        }

        #region Jo

        private static bool PtInRect(int px, int py, int left, int top, int right, int bottom)
        {
            return px >= left && px < right && py >= top && py < bottom;
        }

        #endregion


    }
}
