using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Input;

namespace Yamalib.Input
{
    /// <summary>
    /// KeyInput  NULL foCX
    /// </summary>
    public class KeyInputNullDevice : IKeyInput
    {
        #region IKeyInput o

        public bool IsPress(int nButtonNo)
        {
            return false;
        }

        public bool IsPush(int nButtonNo)
        {
            return false;
        }

        public bool IsPull(int nButtonNo)
        {
            return false;
        }

        public bool IsFree(int nButtonNo)
        {
            return true;
        }

        public void Update()
        {
        }

        public string DeviceName
        {
            get { return "KeyInputNullDevice"; }
        }

        public int ButtonNum
        {
            get { return 0; }
        }

        public IntPtr Info
        {
            get { return IntPtr.Zero; }
        }

        public void Dispose()
        {
        }

        #endregion
    }

    /// <summary>
    /// foCX NULL foCXɎRɐ؂ւ KeyInput 񋟂
    /// </summary>
    public class NullableKeyInput : IKeyInput
    {
        public bool IsPush(int nButtonNo) { return Get().IsPush(nButtonNo); }
        public bool IsPress(int nButtonNo) { return Get().IsPress(nButtonNo); }
        public bool IsPull(int nButtonNo)
        {
            return Get().IsPull(nButtonNo);;
        }

        public bool IsFree(int nButtonNo)
        {
            return Get().IsFree(nButtonNo); ;
        }
        public void Update() { Get().Update(); }
        public string DeviceName
        {
            get { return Get().DeviceName; }
        }

        public int ButtonNum
        {
            get { return Get().ButtonNum; }
        }

        public IntPtr Info
        {
            get { return Get().Info; }
        }

        /// kfoCXɐ؂ւ
        public void Disable()
        {
            this.enableDevice = false;
        }
        /// m[}foCXɐ؂ւ
        public void Enable()
        {
            this.enableDevice = true;
        }
        /// foCXLɂȂĂ邩H
        public bool IsEnable()
        {
            return this.enableDevice;
        }
        /// IWĩfoCX擾
        public IKeyInput GetOriginal()
        {
            return this.key;
        }
        /// RXgN^
        public NullableKeyInput(IKeyInput key_)
        {
            this.key = key_;
            this.enableDevice = true;
        }

        public void Dispose()
        {
            GetOriginal().Dispose();
        }

        private IKeyInput Get()
        {
            return enableDevice ? this.key : nullKey;
        }

        private static IKeyInput nullKey = new KeyInputNullDevice();
        private IKeyInput key;
        private bool enableDevice;
    }
}
