using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Input;

namespace Yamalib.Input
{
    class MultiMouse : IMouseInput
    {
        ///	}EXJ[\\
        public void Show()
        {
            m_primaryMouse.Show();
            foreach (IMouseInput mouse in m_optionalMouse)
            {
                mouse.Show();
            }
        }

        ///	}EXJ[\\ɂ
        public void Hide()
        {
            m_primaryMouse.Hide();
            foreach (IMouseInput mouse in m_optionalMouse)
            {
                mouse.Hide();
            }
        }

        ///	}EẌʒu擾
        /**
            }EXʊOɂƂ͍ŌɎ擾lԂ܂B
            Ȃ킿AʃTCY640~480Ȃ΁Ax0`639,y0`479܂ł
            lԂȂƂۏ؂܂B
        */
        public void GetPos(out int x, out int y)
        {
            m_primaryMouse.GetPos(out x, out y);
        }

        ///	}EẌʒuݒ
        /**
            SDL̃}EẌʒuݒCxgB
        */
        public void SetPos(int x, int y)
        {
            m_primaryMouse.SetPos(x, y);
        }

        ///	{^Ă邩𔻒肷֐
        public bool IsPress(MouseInput.Button e)
        {
            if (m_primaryMouse.IsPress(e))
            {
                return true;
            }
            else
            {
                foreach (IMouseInput mouse in m_optionalMouse)
                {
                    if (mouse.IsPress(e))
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public bool IsPush(MouseInput.Button e)
        {
            if (m_primaryMouse.IsPush(e))
            {
                return true;
            }
            else
            {
                foreach (IMouseInput mouse in m_optionalMouse)
                {
                    if (mouse.IsPush(e))
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public bool IsWheelUp
        {
            get
            {
                if (m_primaryMouse.IsWheelUp)
                {
                    return true;
                }
                else
                {
                    foreach (IMouseInput mouse in m_optionalMouse)
                    {
                        if (mouse.IsWheelUp)
                        {
                            return true;
                        }
                    }
                }
                return false;
            }
        }

        public bool IsWheelDown
        {
            get
            {
                if (m_primaryMouse.IsWheelDown)
                {
                    return true;
                }
                else
                {
                    foreach (IMouseInput mouse in m_optionalMouse)
                    {
                        if (mouse.IsWheelDown)
                        {
                            return true;
                        }
                    }
                }
                return false;
            }
        }


        /// <summary>
        /// _ʒu̐ݒ
        /// </summary>
        /// <param name="X"></param>
        /// <param name="Y"></param>
        public void SetLogicalPos(int x, int y)
        {
            m_primaryMouse.SetLogicalPos(x, y);
            foreach (IMouseInput mouse in m_optionalMouse)
            {
                mouse.SetLogicalPos(x, y);
            }
        }

        /// <summary>
        /// Ԃ̃Zbg
        /// </summary>
        public void Reset()
        {
            m_primaryMouse.Reset();
            foreach (IMouseInput mouse in m_optionalMouse)
            {
                mouse.Reset();
            }
        }

        /// <summary>
        /// ԂXV
        /// ̊֐Ă΂ꂽuԂ̏ێA
        /// updateĂ΂܂Ń}EX̏Ԃ͓ԂԂ
        /// </summary>
        public void Update()
        {
            //m_primaryMouse.Update();
            foreach (IMouseInput mouse in m_optionalMouse)
            {
                mouse.Update();
            }
        }

        /// <summary>
        /// vC}}EX̂disposeI
        /// </summary>
        public void Dispose()
        {
            m_primaryMouse.Dispose();
        }

        /// }EXǉ
        public void AddMouse(IMouseInput mouse)
        {
            m_optionalMouse.Add(mouse);
        }

        /// RXgN^
        public MultiMouse(IMouseInput primary)
        {
            m_primaryMouse = primary;
        }

        private IMouseInput m_primaryMouse;
        private List<IMouseInput> m_optionalMouse = new List<IMouseInput>();

        #region IMouseInput o

        #endregion

        #region IMouseInput o


        #endregion
    }
}
