using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yanesdk.Ytl;
using Yanesdk.System;
using Yamalib.Util;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Scenario;

namespace Yamalib.Scenario
{
    /// <summary>
    /// ViI`掞̃ReLXgw肷f[^NX
    /// </summary>
    public class ScenarioDrawContext
    {
        #region 萔tB[h

        #endregion

        public ScenarioDrawContext Colne()
        {
            ScenarioDrawContext instance = new ScenarioDrawContext();
            instance.DisplayWidth = this.DisplayWidth;
            instance.DrawWidth = this.DrawWidth;
            instance.BlankHeight = this.BlankHeight;
            instance.BlankLineHeight = this.BlankLineHeight;
            instance.CharacterInterval = this.CharacterInterval;
            instance.TextColor = this.TextColor;
            instance.TextShadowColor = this.TextShadowColor;
            instance.HorizontalAlign = this.HorizontalAlign;
            instance.VerticalAlign = this.VerticalAlign;
            instance.Vartical = this.Vartical;
            instance.SetText(this.ScenarioText);
            instance.TextOffsetPos = this.TextOffsetPos;
            instance.PageHeadTextOffset = this.PageHeadTextOffset;

            return instance;
        }

        /// RXgN^
        public ScenarioDrawContext()
        {
            width = 530;
            blankHeight = 2;
            align1 = 0;
            align2 = 0;
            hInterval = 4; // ƕƂ̊Ԋu
            textPos = 0;
            viewWidth = 640;
        }

        # region tB[hƃvpeB

        private int viewWidth = YamalibConst.DEFAULT_SCRENN_WIDTH;		//	ʃTCY

        /// <summary>
        /// ʂ̕
        /// </summary>
        public int DisplayWidth
        {
            get { return viewWidth; }
            set { viewWidth = value; }
        }
        private int width;			//	őŕ\鉡
        /// <summary>
        /// eLXg̍ő\
        /// A֑͋܂܂Ȃ
        /// </summary>
        public int DrawWidth
        {
            get { return width; }
            set { width = value; }
        }
        private int blankHeight;	//	s

        /// <summary>
        /// s
        /// </summary>
        public int BlankHeight
        {
            get { return blankHeight; }
            set { blankHeight = value; }
        }
        private int blankHeight2;	//	s̍

        /// <summary>
        /// s̍
        /// </summary>
        public int BlankLineHeight
        {
            get { return blankHeight2; }
            set { blankHeight2 = value; }
        }

        private int hInterval;		//	ƕƂ̊Ԋu

        /// <summary>
        /// 
        /// </summary>
        public int CharacterInterval
        {
            get { return hInterval; }
            set { hInterval = value; }
        }

        /// <summary>
        /// ̐F
        /// ftHgł 255:255:255:255 ()
        /// </summary>
        private Color4ub textColor = YanesdkUtil.WHITE_COLOR;

        /// <summary>
        /// obNOp̃eLXgJ[
        /// </summary>
        private Color4ub backLogTextColor = new Color4ub(128, 128, 128, 255);

        /// <summary>
        /// ̐F
        /// </summary>
        public Color4ub TextColor
        {
            get { return textColor; }
            set { textColor = value; }
        }

        public Color4ub BackLogTextColor
        {
            get { return backLogTextColor; }
            set { backLogTextColor = value; }
        }

        private Color4ub textShadowColor = YanesdkUtil.BLOCK_COLOR;		//	obN̐̕F(fBtHgłCLR_INVALIDȂ̂ŕ`łȂ)

        /// <summary>
        /// ̉AF
        /// ftHgł 0:0:0 ()
        /// </summary>
        public Color4ub TextShadowColor
        {
            get { return textShadowColor; }
            set { textShadowColor = value; }
        }

        private int align1;			//	0:(ʏ) 1:Z^[ 2:E

        public int HorizontalAlign
        {
            get { return align1; }
            set { align1 = value; }
        }
        private int align2;			//	0:(ʏ) 1:Z^[ 2:

        public int VerticalAlign
        {
            get { return align2; }
            set { align2 = value; }
        }

        private bool vartical;

        /// <summary>
        /// cǂ
        /// </summary>
        public bool Vartical
        {
            get { return vartical; }
            set { vartical = value; }
        }

        private String strText;	//	݂̃ReNXgʒu
        private int textPos;		// ǂ݊Ƃ܂ł̈ʒu
        private int prevTextPos;		// ǂݍły[W̍ŏ̈ʒu
        private bool backTextFlg;

        /// <summary>
        /// ǂݍłViIeLXgiǂݎpj
        /// </summary>
        public String ScenarioText
        {
            get { return strText; }
        }


        /// <summary>
        /// ǂłƂ̈ʒuݒ擾
        /// </summary>
        public int TextOffsetPos
        {
            get { return textPos; }
            set { textPos = value; }
        }

        /// <summary>
        /// ݂̂Pŕ̃XNvg̐擪ItZbgl
        /// </summary>
        public int PageHeadTextOffset
        {
            get { return prevTextPos; }
            set { prevTextPos = value; }
        }

        # endregion

        public void LoadTextFile(String filename)
        {
            SetText(Util.YamalibUtility.ReadTextFile(filename));
        }

        /// ViIŜ̕ݒ
        public void SetText(String text)
        {
            strText = text;
            textPos = 0;
        }

        /// <HR> ܂ł̕Ԃ
        public String GetNextText()
        {

            if (backTextFlg)
            {
                backTextFlg = false;
                if (textPos != 0)
                {
                    textPos += 3;
                }
            }

            int startpos0 = textPos;
            prevTextPos = textPos;

            if (textPos >= strText.Length) return null;

            do
            {
            CONTINUE:
                ;
                char c = strText[textPos++];

                if (c == '<')
                {
                    //	^O̎擾
                    //	O '>'T[`
                    int startpos = textPos;
                    while (true)
                    {

                        if (textPos >= strText.Length)
                        {
                            throw new YanesdkException(this, "^OĂȂ");
                        }

                        char wc = strText[textPos];
                        if (wc == '>')
                        {
                            String tag = strText.Substring(startpos, (textPos - startpos));
                            if (tag == "HR" || tag == "hr")
                            {
                                ++textPos;
                                String ww = strText.Substring(startpos0, (textPos - startpos0));
                                return ww;
                            }
                            else
                            {
                                goto CONTINUE;
                            }
                        }
                        textPos++;
                    }
                }

            } while (textPos < strText.Length);

            return strText.Substring(startpos0, textPos - startpos0);
        }

        /// O<HR> ܂ł̕Ԃ
        public String GetPreText()
        {

            if (textPos < 0)
            {
                // EOF܂ŒBĂ
                textPos = 0;
            }

            if (!backTextFlg)
            {
                GetPrevHRPos();
            }

            if (textPos == 0) return null;

            int endpos0 = textPos;
            prevTextPos = textPos;

            do
            {
            CONTINUE:
                ;
                char c = strText[textPos--];

                if (c == '>')
                {
                    //	^O̎擾
                    //	O '>'T[`
                    int tailpos = textPos;
                    while (true)
                    {

                        if (textPos < 0)
                        {
                            throw new YanesdkException(this, "^OĂȂ");
                        }

                        char wc = strText[textPos];
                        if (wc == '<')
                        {
                            String tag = strText.Substring(textPos + 1, tailpos - textPos);

                            if (tag == "HR" || tag == "hr")
                            {
                                backTextFlg = true;
                                String ww = strText.Substring(tailpos + 2, endpos0 - (tailpos + 2));
                                return ww;
                            }
                            else
                            {
                                goto CONTINUE;
                            }
                        }
                        textPos--;
                    }
                }

            } while (textPos >= 0);



            return strText.Substring(0, endpos0);
        }

        /// ȑO<HR>^Öʒuԋp
        private int GetPrevHRPos()
        {

            // ܂y[Ŵgd`c|WV
            do
            {
            CONTINUE:
                ;
                char c = strText[textPos--];

                if (c == '>')
                {
                    int tailpos = textPos;
                    while (true)
                    {
                        if (textPos < 0)
                        {
                            textPos = 0;
                            throw new YanesdkException(this, "^OĂȂ");
                        }
                        char wc = strText[textPos];
                        if (wc == '<')
                        {
                            String tag = strText.Substring(textPos + 1, tailpos - textPos);
                            if (tag == "HR" || tag == "hr")
                            {
                                return textPos;
                            }
                            else
                            {
                                goto CONTINUE;
                            }
                        }
                        textPos--;
                    }
                }

            } while (textPos >= 0);

            textPos = 0;
            return 0;
        }
        /// obNOp̃tO߂
        public void ResetBackLogFlg()
        {
            backTextFlg = false;
        }

    }

    /// <summary>
    /// ViI͂Af[^ɕϊ
    /// </summary>
    public class ScenarioParser : IDisposable
    {
        /// <summary>
        /// \ׂ摜ێf[^NX
        /// </summary>
        public class DrawLetter : ILetterDeta
        {
            private ITexture texture;	//!< 	̓eNX`[
            private float size = 1.0f;	//!<	lɔ䂷{
            private Color4ub color = YanesdkUtil.WHITE_COLOR;		//!<	`悷F
            private Position pos = new Position();		//!<	`悷镶̕`|WV
            private List<String> tags = new List<string>();		//!<	̈ʒuɏĂ^O(FwEsw蓙͎菜)
            private List<ILetterDeta> rubi = new List<ILetterDeta>();		//!<    ̕ɕtт郋r
            private char letter;			//!<	eNX`ɂ
            private int angle;

            /// <summary>
            /// RXgN^
            /// </summary>
            public DrawLetter()
            {
            }

            /// <summary>
            /// V[Rs[łB
            /// C[WIuWFNg͂̎QƂłB
            /// </summary>
            /// <returns></returns>
            public ILetterDeta Clone()
            {
                DrawLetter instance = new DrawLetter();
                instance.Texture = this.texture;
                instance.Size = this.size;
                instance.Color = this.color;
                instance.Pos.X = this.pos.X;
                instance.Pos.Y = this.pos.Y;
                instance.Tags = this.Tags;
                instance.Letter = this.letter;
                instance.Angle = this.angle;

                for (int i = 0; i < rubi.Count; i++)
                {
                    instance.RubiChara.Add(rubi[i].Clone());
                }

                return instance;
            }

            /// <summary>
            /// Rs[RXgN^
            /// AeNX`̃f[^̓Rs[Ȃ̂
            /// IȃRs[ƃRs[͓̎ƎvĎg
            /// </summary>
            /// <param name="drawChar"></param>
            public DrawLetter(DrawLetter drawChar)
            {
                this.texture = drawChar.texture;
                this.size = drawChar.size;
                this.color = drawChar.color;
                this.pos.X = drawChar.pos.X;
                this.pos.Y = drawChar.pos.Y;
                this.tags = drawChar.Tags;
                this.letter = drawChar.letter;
                this.angle = drawChar.Angle;
            }

            public ITexture Texture
            {
                get { return texture; }
                set { texture = value; }
            }

            public virtual Object ImgObj
            {
                get { return texture; }
                set { texture = value as ITexture; }
            }

            public virtual float ImgObjWidth
            {
                get { return texture.Width; }
            }

            public virtual float ImgObjHeight
            {
                get { return texture.Height; }
            }

            public float Size
            {
                get { return size; }
                set { size = value; }
            }

            /// <summary>
            /// px
            /// K0 - 511 ͈̔
            /// </summary>
            public int Angle
            {
                get { return angle; }
                set { angle = value % 512; }
            }

            public Color4ub Color
            {
                get { return color; }
                set { color = value; }
            }

            public List<String> Tags
            {
                get { return tags; }
                set { tags = value; }
            }

            public List<ILetterDeta> RubiChara
            {
                get { return rubi; }
                set { rubi = value; }
            }

            public char Letter
            {
                get { return letter; }
                set { letter = value; }
            }

            public Position Pos
            {
                get { return pos; }
                set
                {
                    // Rs[Ȃ...
                    pos = new Position(value.X, value.Y);
                }
            }
        }

        /// <summary>
        /// ftHg̃^OȊÖӖ̃^Oێf[^NX
        /// </summary>
        public struct UnknownTagInfo
        {
            private String tag;
            /// <summary>
            /// ^O̕
            /// </summary>
            public String Tag
            {
                get { return tag; }
                set { tag = value; }
            }
            private int pos;
            /// <summary>
            /// oʒu
            /// </summary>
            public int Pos
            {
                get { return pos; }
                set { pos = value; }
            }
        }

        /// <summary>
        /// ViIł̑IێNX
        /// </summary>
        public struct SelectTagInfo
        {
            private static int pos;		//!< ʏI͘AĔzuB]ĕ\ʒu̓NXϐƂ

            public static int Pos
            {
                get { return SelectTagInfo.pos; }
                set { SelectTagInfo.pos = value; }
            }
            Textures texture;	//!< IeNX`

            public Textures Texture
            {
                get { return texture; }
                set { texture = value; }
            }
            int x;

            public int X
            {
                get { return x; }
                set { x = value; }
            }
            int y;

            public int Y
            {
                get { return y; }
                set { y = value; }
            }
            int width;		//!< ̕

            public int Width
            {
                get { return width; }
                set { width = value; }
            }
            int height;		//!< ̍

            public int Height
            {
                get { return height; }
                set { height = value; }
            }
            String nextSceneId;	//!< ȊJڐ

            public String NextSceneId
            {
                get { return nextSceneId; }
                set { nextSceneId = value; }
            }
            Color4ub color;		//!<	`悷F

            public Color4ub Color
            {
                get { return color; }
                set { color = value; }
            }
        }

        /// <summary>
        /// tHgێf[^NX
        /// </summary>
        internal class FontInfo
        {
            private float size = 1.0f;	//!< tHg̃TCY
            /// <summary>
            /// tHgTCY
            /// </summary>
            public float Size
            {
                get { return size; }
                set { size = value; }
            }
            private Color4ub color = YanesdkUtil.WHITE_COLOR; 		//!< F

            /// <summary>
            /// tHgJ[
            /// </summary>
            public Color4ub Color
            {
                get { return color; }
                set { color = value; }
            }
        }

        #region 萔l

        private static readonly String FONT_TAG_SIZE = "size=";
        private static readonly String FONT_TAG_COLOR = "color=";

        //	ǂ̃^OɊY邩𒲂ׂ
        private static readonly String[] DEF_TAGS = {
					    "br", 		// s
					    "space", 	// 󔒍s
					    "rubi",		// r
                        //"select",	// I
                        "",
					    "font",		// tHgJn
					    "/font"		// tHgI
				    };

        #endregion

        # region otB[h

        // ֑ΏەZbg
        private static readonly String prohibitionChar = "BAv@BDFHbIH";
        private static readonly String VARTICAL_LETTER = "uv[`ijwxyzst{}mn";
        private static readonly String VARTICAL_AJUST_LETTER = "AB";

        private FontRepository textFontRepository; 		//	tHg
        private FontRepository rubifontrep;		// rtHg
        private FontRepository backlogFontRep;	// obNOptHg

        private String pageText;				//	ݒ肳Ă镶
        private List<ILetterDeta> drawCharacter = new List<ILetterDeta>();		//	`悷eLXg
        private List<ILetterDeta> backLogDrawCharacter = new List<ILetterDeta>();		//	`悷eLXg
        private List<UnknownTagInfo> unknownTag = new List<UnknownTagInfo>();	// m^O̔z
        private List<SelectTagInfo> selectTagInfo = new List<SelectTagInfo>();	// Iz
        private List<FontInfo> fontInfos = new List<FontInfo>();	// tHgX^bN

        private bool m_useRubi = true;	//!< rgp邩

        private int textPosOrg;			//!< obNOpҔ
        private int headerTextPosOrg;	//!< obNOpҔ
        private String textOrg;
        private bool backLogMode;

        private bool parseFinish;

        private ScenarioDrawContext scenarioDrawContext;	// ReNXg
        private bool adjust;	// tO
        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ScenarioParser()
        {
            fontInfos.Add(new FontInfo());
        }

        /// <summary>
        /// \[X̔j
        /// </summary>
        public void Dispose()
        {
            YamalibUtility.Dispose(textFontRepository);
            YamalibUtility.Dispose(rubifontrep);
            YamalibUtility.Dispose(backlogFontRep);
        }

        public void SetScenarioDrawContext(ScenarioDrawContext v)
        {
            // ݂̏Ԃ͏Ă
            drawCharacter.Clear();
            unknownTag.Clear();
            selectTagInfo.Clear();
            backLogDrawCharacter.Clear();


            // ftHgtHgƂĐFݒ
            fontInfos[0].Color = v.TextColor;
            scenarioDrawContext = v;
        }
        public ScenarioDrawContext GetScenarioDrawContext()
        {
            return scenarioDrawContext;
        }

        public void SetTextOffset(int pos)
        {
            scenarioDrawContext.TextOffsetPos = pos;
        }

        public int GetTextOffset()
        {
            if (backLogMode)
            {
                return this.textPosOrg;
            }
            return scenarioDrawContext.TextOffsetPos;
        }

        public int GetHeadTextOffset()
        {
            if (backLogMode)
            {
                return this.headerTextPosOrg;
            }
            return scenarioDrawContext.PageHeadTextOffset;
        }

        public FontRepository TextFontRepository
        {
            get { return textFontRepository; }
            set { textFontRepository = value; }
        }

        public FontRepository RubiFontRepository
        {
            get { return rubifontrep; }
            set { rubifontrep = value; }
        }

        public FontRepository BacklogFontRepository
        {
            get { return backlogFontRep; }
            set { backlogFontRep = value; }
        }

        public List<SelectTagInfo> SelectTagInfos
        {
            get { return selectTagInfo; }
        }

        public List<UnknownTagInfo> UnknownTags
        {
            get { return unknownTag; }
        }

        public List<ILetterDeta> DrawCharacterData
        {
            get { return drawCharacter; }
        }

        public List<ILetterDeta> BackLogDrawCharacter
        {
            get { return backLogDrawCharacter; }
        }

        /// <summary>
        /// ViI͂s
        /// </summary>
        /// <returns></returns>
        public bool UpdateText()
        {
            return UpdateText(false);
        }

        /// <summary>
        /// Õy[W\gpƂꍇɁAĂׂ΁AOʂ̃ViI͂
        /// </summary>
        /// <returns></returns>
        public bool UpdateTextBack()
        {
            return UpdateText(true);
        }

        /// rgp
        public void EnableRubiText()
        {
            m_useRubi = true;
        }

        /// rgpȂ
        public void DisenableRubiText()
        {
            m_useRubi = false;
        }

        /// <summary>
        /// Săp[XI
        /// </summary>
        public bool IsParseFinish
        {
            get { return parseFinish; }
            set { parseFinish = value; }
        }

        /* obNOʒuݒ肷 */
        public void SetBackLogMode(bool backMode)
        {
            if (!backLogMode && backMode)
            {
                // on v
                textPosOrg = scenarioDrawContext.TextOffsetPos;
                headerTextPosOrg = scenarioDrawContext.PageHeadTextOffset;
                textOrg = GetText();
                backLogMode = true;
            }
            else if (backLogMode && !backMode)
            {
                // off v
                scenarioDrawContext.TextOffsetPos = textPosOrg;
                scenarioDrawContext.PageHeadTextOffset = headerTextPosOrg;
                scenarioDrawContext.ResetBackLogFlg();
                backLogMode = false;
            }
        }

        ///	eLXg̎擾
        /**
            ݒ肵ĂeLXg̎擾BŎ擾̂ɒǉ
            ēxsetTextĂяoȂǂĂǂB
        */
        public String GetText()
        {
            if (backLogMode)
            {
                return textOrg;
            }
            return pageText;
        }

        ///	̕`
        /**
            Color4ubw肵Ă΁A̐Fɕψڂ̂`悳
        */
        public static void ScenarioOnPaint(IScreen dst, List<ILetterDeta> src, int x, int y)
        {
            foreach (DrawLetter d in src)
            {
                dst.SetColor(d.Color);
                if (d.Angle != 0 || d.Size != 1.0f)
                {
                    dst.BltRotate(d.Texture, (int)(d.Pos.X + x), (int)(d.Pos.Y + y), d.Angle, d.Size, 0);
                }
                else
                {
                    dst.Blt(d.Texture, (int)(d.Pos.X + x), (int)(d.Pos.Y + y));
                }
            }
        }

        public static void ScenarioOnPaint(IScreen dst, List<ILetterDeta> src, int x, int y, Color4ub color)
        {
            foreach (DrawLetter d in src)
            {
                dst.SetColor(color);
                if (d.Angle != 0 || d.Size != 1.0f)
                {
                    dst.BltRotate(d.Texture, (int)(d.Pos.X + x), (int)(d.Pos.Y + y), d.Angle, d.Size, 0);
                }
                else
                {
                    dst.Blt(d.Texture, (int)(d.Pos.X + x), (int)(d.Pos.Y + y));
                }
            }
        }

        ///	̕`
        /**
            Color4ubw肵Ă΁A̐Fɕψڂ̂`悳
        */
        public void OnPaint(IScreen dst, int x, int y)
        {
            ScenarioOnPaint(dst, DrawCharacterData, x, y);
        }

        public void OnPaint(IScreen dst, int x, int y, Color4ub color)
        {
            ScenarioOnPaint(dst, DrawCharacterData, x, y, color);
        }


        /// <summary>
        /// obNOƒʏ`ł́AFontRepository؂ւB
        /// ȂƁAʏ@ obNOʏ탂[hɕƂ
        /// |WgύXĂ邽߂ɁA\łȂłĂB
        /// </summary>
        /// <returns></returns>

        /// <summary>
        /// ֑ǂ𒲍
        /// </summary>
        /// <param name="c_"></param>
        /// <returns></returns>
        private bool IsProhibition(char letter)
        {
            foreach (char c in prohibitionChar)
            {
                if (c == letter)
                {
                    //Console.WriteLine("prohibition : {0}", letter);
                    return true;
                }
            }
            return false;
        }

        /// <summary>
        /// tHg^O͂AFontInfo𐶐
        /// </summary>
        /// <param name="tagPram"></param>
        /// <returns></returns>
        private static FontInfo CreateFontTagInfo(String[] tagPram)
        {
            FontInfo fontInfo = new FontInfo();
            if (null == tagPram || 1 >= tagPram.Length)
            {
                return fontInfo;
            }

            for (int i = 1; i < tagPram.Length; ++i)
            {
                if (tagPram[i].StartsWith(FONT_TAG_SIZE))
                {
                    // sizew
                    fontInfo.Size = (float)Convert.ToDecimal(GetFontTagPramValue(tagPram[i]));
                }
                else if (tagPram[i].StartsWith(FONT_TAG_COLOR))
                {
                    // colorw
                    fontInfo.Color = YanesdkUtil.ToColor4ub(GetFontTagPramValue(tagPram[i]));
                }
            }
            return fontInfo;
        }

        /// <summary>
        /// tHg^Ȏl擾
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        private static String GetFontTagPramValue(String str)
        {
            return str.Split('=')[1].Trim(' ', '"');
        }

        /// <summary>
        /// ̃p[TŗLȃ^Oꗗ
        /// </summary>
        public virtual String[] EnableTags
        {
            get { return DEF_TAGS; }
        }

        /// <summary>
        /// rpDrawCharƂďꂽCX^Xԋp
        /// </summary>
        /// <returns></returns>
        private ILetterDeta CreateRubiDrawChar()
        {
            ILetterDeta dc = CreateDrawLetter();
            if (!backLogMode)
            {
                dc.Color = scenarioDrawContext.TextColor;
            }
            else
            {
                dc.Color = scenarioDrawContext.BackLogTextColor;
            }
            return dc;
        }

        /// <summary>
        /// ViI͂Af[^ێ
        /// </summary>
        /// <param name="back"></param>
        /// <returns></returns>
        private bool UpdateText(bool back)
        {
            // <HR> ܂ŒT
            if (!back)
            {
                pageText = scenarioDrawContext.GetNextText();
                if (null == pageText)
                {
                    parseFinish = true;
                    return false;
                }
            }
            else
            {
                pageText = scenarioDrawContext.GetPreText();
                if (null == pageText)
                {
                    return false;
                }
            }

            InitializeForNewPage();

            int currentPos = 0; 		// ̓|WV
            float nowLineHeight = 0;	//	̃C̍
            Position nextDrawPt = new Position();		//	݂̕`ʒu
            int lineStartIndex = 0;		//	s̊Jndracharindex

            do
            {
                char letter = GetNextLetter(ref currentPos);
                if (IsStartTag(letter))
                {
                    AnalyzeTag(ref currentPos, nextDrawPt, ref nowLineHeight, ref lineStartIndex);
                    continue;
                }

                // ȕȂXLbv
                if (IsInvalidLetter(letter)) continue;

                Object letterTexture = GetLetterImg(letter);
                if (null == letterTexture)
                {
                    // Ȃ񂾂̕
                    continue;
                }

                ILetterDeta newDrawChar = CreateDrawChar(currentPos, ref nowLineHeight, nextDrawPt, ref lineStartIndex, letter, letterTexture);

                if (!backLogMode)
                {
                    drawCharacter.Add(newDrawChar);
                }
                else
                {
                    backLogDrawCharacter.Add(newDrawChar);
                }
            } while (currentPos < pageText.Length);

            return true;
        }

        /// <summary>
        /// VłJnɂāAϐ
        /// </summary>
        protected virtual void InitializeForNewPage()
        {
            if (!backLogMode)
            {
                drawCharacter.Clear();
                unknownTag.Clear();
                selectTagInfo.Clear();
                SelectTagInfo.Pos = int.MinValue;
            }
            else
            {
                backLogDrawCharacter.Clear();
            }
        }

        /// <summary>
        /// R[hȂ̃ViIɖȕǂH
        /// </summary>
        /// <param name="letter"></param>
        /// <returns></returns>
        protected static bool IsInvalidLetter(char letter)
        {
            return letter == '\t' || letter == '\n' || letter == '\r';
        }

        /// <summary>
        /// ^ÕX^[g
        /// </summary>
        /// <param name="letter"></param>
        /// <returns></returns>
        protected static bool IsStartTag(char letter)
        {
            return letter == '<';
        }

        /// <summary>
        /// ̕擾
        /// </summary>
        /// <param name="currentPos"></param>
        /// <returns></returns>
        protected virtual char GetNextLetter(ref int currentPos)
        {
            return pageText[currentPos++];
        }

        /// <summary>
        /// FłȂ^O
        /// </summary>
        /// <param name="tagStr"></param>
        /// <param name="position"></param>
        protected virtual void UnknownTag(String tagStr, int position)
        {
            //	FłȂ^OȂ̂Ń^OXgɒǉ
            UnknownTagInfo uti = new UnknownTagInfo();
            uti.Tag = tagStr;
            uti.Pos = position;
            unknownTag.Add(uti);
        }

        /// <summary>
        /// ݂̃ReNXgA摜𐶐ԋp
        /// </summary>
        /// <param name="currentPos"></param>
        /// <param name="nowLineHeight"></param>
        /// <param name="nextDrawPt"></param>
        /// <param name="lineStartIndex"></param>
        /// <param name="letter"></param>
        /// <param name="letterTexture"></param>
        /// <returns></returns>
        private ILetterDeta CreateDrawChar(int currentPos, ref float nowLineHeight, Position nextDrawPt, ref int lineStartIndex, char letter, Object letterTexture)
        {
            // tHgTCYŊgk̃TCY
            float charRate = fontInfos[fontInfos.Count - 1].Size;
            float charImgWidth = GetImgObjWidth(letterTexture) * charRate;
            float charImgHeight = GetImgObjHeight(letterTexture) * charRate;
            ILetterDeta newDrawChar = CreateDrawLetter();
            newDrawChar.Letter = letter;
            {
                if (scenarioDrawContext.Vartical)
                {
                    // c
                    if ((nextDrawPt.Y > scenarioDrawContext.DrawWidth) && !IsProhibition(letter))
                    {
                        nextDrawPt.X -= (nowLineHeight + scenarioDrawContext.BlankHeight);
                        nextDrawPt.Y = 0;
                        nowLineHeight = 0;
                        lineStartIndex = currentPos;
                        adjust = false;
                    }

                    newDrawChar.ImgObj = letterTexture;
                    newDrawChar.Color = fontInfos[fontInfos.Count - 1].Color;	// tHg^OŎw肳ĂF
                    newDrawChar.Size = charRate;	// tHg^OŎw肳ĂTCY
                    newDrawChar.Pos = nextDrawPt;
                    if (IsRotateLetterWithVartical(letter))
                    {
                        newDrawChar.Angle = 128;
                    }
                    if (IsAjustLetterWithVartical(letter))
                    {
                        newDrawChar.Pos.X += newDrawChar.ImgObjWidth / 2;
                        newDrawChar.Pos.Y -= newDrawChar.ImgObjHeight / 2;
                    }

                    nextDrawPt.Y += charImgHeight + scenarioDrawContext.CharacterInterval;
                    if (nowLineHeight < charImgWidth)
                    {
                        //	̃C̃x[Xʒuς̂ŁA̍̕A
                        //	ZKvB
                        float d = charImgWidth - nowLineHeight;
                        for (int i = lineStartIndex; i < drawCharacter.Count; ++i)
                        {
                            drawCharacter[i].Pos.X -= d;
                        }
                        nowLineHeight = charImgWidth;
                    }

                }
                // 
                else
                {
                    // ֑ł͂ȂA`ʒuw͈͂𒴂ĂΉs
                    if ((nextDrawPt.X > scenarioDrawContext.DrawWidth) && !IsProhibition(letter))
                    {
                        // s
                        nextDrawPt.X = 0;
                        nextDrawPt.Y += nowLineHeight + scenarioDrawContext.BlankHeight;
                        nowLineHeight = 0;
                        lineStartIndex = currentPos;
                        adjust = false;
                    }

                    newDrawChar.ImgObj = letterTexture;
                    newDrawChar.Color = fontInfos[fontInfos.Count - 1].Color;	// tHg^OŎw肳ĂF
                    newDrawChar.Size = charRate;	// tHg^OŎw肳ĂTCY
                    newDrawChar.Pos = nextDrawPt;

                    nextDrawPt.X += charImgWidth + scenarioDrawContext.CharacterInterval;
                    if (nowLineHeight < charImgHeight)
                    {
                        //	̃C̃x[Xʒuς̂ŁA̍̕A
                        //	̍sŜɉZKvB
                        float d = charImgHeight - nowLineHeight;
                        for (int i = lineStartIndex; i < drawCharacter.Count; ++i)
                        {
                            drawCharacter[i].Pos.Y += d;
                        }
                        nowLineHeight = charImgHeight;
                    }
                }
            }

            // obNO[hł΋Iɂ
            if (backLogMode)
            {
                newDrawChar.Color = scenarioDrawContext.BackLogTextColor;
            }

            return newDrawChar;
        }

        /// <summary>
        /// c̎]镶ǂ
        /// </summary>
        /// <param name="letter"></param>
        /// <returns></returns>
        private static bool IsRotateLetterWithVartical(char letter)
        {
            return VARTICAL_LETTER.IndexOf(letter) >= 0;
        }

        /// <summary>
        /// c̎ɕ\ʒu𒲐Kv镶
        /// </summary>
        /// <param name="letter"></param>
        /// <returns></returns>
        private static bool IsAjustLetterWithVartical(char letter)
        {
            return VARTICAL_AJUST_LETTER.IndexOf(letter) >= 0;
        }

        /// <summary>
        /// ^Ỏ͂s
        /// </summary>
        /// <param name="pos"></param>
        /// <param name="nextDrawPt"></param>
        /// <param name="nowLineHeight"></param>
        /// <param name="lineStartIndex"></param>
        /// <returns></returns>
        private bool AnalyzeTag(ref int currentPos, Position nextDrawPt, ref float nowLineHeight, ref int lineStartIndex)
        {
            //	^O̎擾
            //	O '>'T[`
            String tag = GetTagString(ref currentPos);
            // ̕ɐi߂Ă
            currentPos++;

            // A󔒏AȂ
            String[] tagParam = SplitTag(tag);
            String tagStr = tagParam[0];
            int found = -1; // not found marker
            for (int i = 0; i < EnableTags.Length; ++i)
            {
                if (tagStr == EnableTags[i])
                {
                    found = i;
                    break;
                }
            }

            if (found == -1)
            {
                //	FłȂ^OȂ̂Ń^OXgɒǉ
                UnknownTag(tag, drawCharacter.Count);
                return true;
            }

            //	̃^Ȍ
            switch (found)
            {
                case 0: // <BR> : s菈
                    if (scenarioDrawContext.Vartical)
                    {
                        if (nextDrawPt.Y == 0)
                        {
                            // ͋sƂ݂Ȃ
                            nextDrawPt.X -= scenarioDrawContext.BlankLineHeight;
                            break;
                        }
                        nextDrawPt.Y = 0;
                        nextDrawPt.X -= (nowLineHeight + scenarioDrawContext.BlankHeight);
                        nowLineHeight = 0;
                        lineStartIndex = currentPos;
                        adjust = false;
                    }
                    else
                    {
                        if (nextDrawPt.X == 0)
                        {
                            // ͋sƂ݂Ȃ
                            nextDrawPt.Y += scenarioDrawContext.BlankLineHeight;
                            break;
                        }
                        nextDrawPt.X = 0;
                        nextDrawPt.Y += (nowLineHeight + scenarioDrawContext.BlankHeight);
                        nowLineHeight = 0;
                        lineStartIndex = currentPos;
                        adjust = false;
                    }
                    break;

                case 1:	//<space X>
                    int space = Convert.ToInt32(tagParam[1]);
                    nextDrawPt.X = 0;
                    nextDrawPt.Y += (nowLineHeight * space) / 2;
                    nowLineHeight = 0;
                    lineStartIndex = currentPos;
                    adjust = false;
                    break;

                case 2:	// <RubiChara,X,str>
                    //					    Log.print("RUBI TAG");
                    if (!m_useRubi)
                    {
                        break;
                    }

                    int backNum = (int)Convert.ToInt32(tagParam[1]);
                    String moji = tagParam[2];
                    // w`FbN
                    if ((backNum == -1) || (moji.Length == 0) || (drawCharacter.Count < backNum)) break;

                    // reNX`̐
                    List<Object> tt = new List<Object>();
                    int i = 0, j = 0;
                    for (i = 0; i < moji.Length; ++i)
                    {
                        tt.Add(GetRubiLetterImg(moji[i]));
                    }

                    // ȓ傫擾
                    int tWidth = (int)GetImgObjWidth(tt[0]);
                    int tHeight = (int)GetImgObjWidth(tt[0]);

                    // P̃rtѐ
                    float perChar = moji.Length / backNum;
                    float rubiRest = perChar;
                    int index = drawCharacter.Count - backNum;

                    for (i = 0; i < tt.Count && index < drawCharacter.Count; ++i)
                    {
                        for (; rubiRest >= 1.0 && j < tt.Count; j++, rubiRest -= 1.0f)
                        {
                            ILetterDeta dc = CreateRubiDrawChar();
                            dc.ImgObj = tt[j];
                            drawCharacter[index].RubiChara.Add(dc);
                        }
                        index++;
                        rubiRest += perChar;
                    }
                    if (j < tt.Count)
                    {
                        for (i = j; i < tt.Count; ++i)
                        {
                            ILetterDeta dc = CreateRubiDrawChar();
                            dc.ImgObj = tt[i];
                            drawCharacter[index - 1].RubiChara.Add(dc);
                        }
                    }

                    // ϓts
                    index = drawCharacter.Count - backNum;

                    // ܂Ar̒Zo
                    int sumWidthRubi = 0;
                    int sumWidth = 0;
                    for (j = index; j < drawCharacter.Count; ++j)
                    {
                        sumWidth += (int)drawCharacter[j].ImgObjWidth;
                        // ɂōsԃ}[WZ
                        sumWidth += scenarioDrawContext.CharacterInterval * (backNum - 1);

                        // r̘Ả擾
                        foreach (ILetterDeta rubiChara in drawCharacter[j].RubiChara)
                        {
                            sumWidthRubi += (int)rubiChara.ImgObjWidth;
                        }
                    }

                    int moji_len = moji.Length;
                    int dx, ox;
                    // ꕶɂԊu
                    int widthPerChar = 0;
                    // Ar̐Aeɑ΂ĂQ{łȂΔp炷Kv
                    bool posAdjust = (bool)(moji.Length != backNum * 2);

                    if (sumWidth >= sumWidthRubi)
                    {
                        // r̒Aêق傫
                        widthPerChar = sumWidth - sumWidthRubi;
                        ox = sumWidth / moji_len;
                        dx = (int)drawCharacter[index].Pos.X;
                    }
                    else
                    {
                        // r̒Aêق
                        widthPerChar = sumWidthRubi - sumWidth;
                        dx = widthPerChar / 2;
                        //ox = (int)(drachar[index].RubiChara[0].Texture.GetWidth()/2);
                        ox = 0;
                    }

                    // reArɉsĂ邩Ȃ
                    int newLinePos = -1; // not found marker
                    // Ut̍ŏ̃CfbNX
                    int target = drawCharacter.Count - backNum;
                    int baseY = (int)drawCharacter[target].Pos.Y;
                    for (i = 0; i < backNum; ++i, ++target)
                    {
                        if (baseY != (int)drawCharacter[target].Pos.Y)
                        {
                            // `ʒuύXɂȂĂs...
                            newLinePos = i;
                            break;
                        }
                    }

                    // e
                    for (i = index; i < drawCharacter.Count; ++i)
                    {
                        if (sumWidth < sumWidthRubi && i > index)
                        {
                            // r̂قƂȂAÕ̕rAItZbgʒuZo
                            List<ILetterDeta> rubi = drawCharacter[i - 1].RubiChara;
                            ox = (int)(rubi[rubi.Count - 1].Pos.X - drawCharacter[i].Pos.X) + dx + tWidth;
                        }

                        if (i - index == newLinePos)
                        {
                            // ŉs͂₪I
                            dx = 0;
                        }

                        // rꕶ
                        for (j = 0; j < drawCharacter[i].RubiChara.Count; ++j)
                        {

                            if (sumWidth >= sumWidthRubi)
                            {
                                // r̒Aêق傫
                                drawCharacter[i].RubiChara[j].Pos.X = dx;
                                if (posAdjust)
                                {
                                    drawCharacter[i].RubiChara[j].Pos.X += tWidth / 2;
                                }
                                drawCharacter[i].RubiChara[j].Pos.Y = drawCharacter[i].Pos.Y;
                                dx += ox;

                                //								    debug {
                                //									    Log.print("i = %s,j = %s,X = %s,ox = %s\n",i,j,drachar[i].rubi[j].Pos.X,ox);
                                //								    }

                            }
                            else
                            {
                                // r̒Aêق
                                drawCharacter[i].RubiChara[j].Pos.X = drawCharacter[i].Pos.X - dx + ox;
                                drawCharacter[i].RubiChara[j].Pos.Y = drawCharacter[i].Pos.Y;
                                int rubiWidth = (int)drawCharacter[i].RubiChara[j].ImgObjWidth;
                                ox += rubiWidth;
                            }

                            if (adjust)
                            {
                                drawCharacter[i].RubiChara[j].Pos.Y -= tHeight;
                            }
                        }
                    }

                    // srtȂAO̍sɂłɃrǂ
                    // sPŖsA͐삵Ȃ
                    bool bPreLineRubied = false;
                    if (-1 != newLinePos)
                    {
                        int preLineEnd = drawCharacter.Count - backNum - 1;
                        int preY = (int)drawCharacter[preLineEnd].Pos.Y;

                        // OsɂărUĂ邩ׂ
                        while (preLineEnd >= 0 && drawCharacter[preLineEnd].Pos.Y == preY)
                        {
                            if (drawCharacter[preLineEnd].RubiChara.Count != 0)
                            {
                                bPreLineRubied = true;
                                break;
                            }

                            preY = (int)drawCharacter[preLineEnd].Pos.Y;
                            --preLineEnd;
                        }
                    }

                    //					    Log.print("bPreLineRubied %s", bPreLineRubied);

                    // sԒ
                    int end = drawCharacter.Count - 1;
                    int ly = (int)drawCharacter[end].Pos.Y;
                    // srł΁AO̕ƍ̍sAQ̃Xy[XKv
                    int spaceRate = ((-1 != newLinePos) && !bPreLineRubied) ? 2 : 1;

                    if (drawCharacter[index].Pos.Y != 0 && !adjust)
                    {

                        int loopCnt = 0;
                        bool rubiAdust = false;
                        while (end >= 0 && (drawCharacter[end].Pos.Y == ly || end >= index))
                        {

                            // rsłAš㕪
                            if (-1 != newLinePos)
                            {
                                if (loopCnt == backNum - newLinePos)
                                {
                                    rubiAdust = true;
                                }
                            }

                            if (rubiAdust)
                            {

                                // rsΉAOs̏
                                if (bPreLineRubied)
                                {
                                    // O̍sɂrāAłɍsԂ͂Ă
                                    foreach (ILetterDeta dc in drawCharacter[end].RubiChara)
                                    {
                                        dc.Pos.Y -= tHeight;
                                    }
                                }

                            }
                            else
                            {
                                ly = (int)drawCharacter[end].Pos.Y;
                                drawCharacter[end].Pos.Y += (tHeight * spaceRate);

                                // srőOs̍sԏĂȂ΁ÄʒuꕪA
                                // ǉłȂ΂ȂȂ
                                if (((-1 != newLinePos) && !bPreLineRubied))
                                {
                                    foreach (ILetterDeta dc in drawCharacter[end].RubiChara)
                                    {
                                        dc.Pos.Y += tHeight;
                                    }
                                }
                            }
                            end--;
                            loopCnt++;
                        }

                        // srőO̍sȂAO̍s̍sԂɊm
                        if (-1 != newLinePos && !bPreLineRubied)
                        {
                            end = index + (newLinePos - 1);
                            ly = (int)drawCharacter[end].Pos.Y;

                            while (end >= 0 && drawCharacter[end].Pos.Y == ly)
                            {
                                ly = (int)drawCharacter[end].Pos.Y;
                                drawCharacter[end].Pos.Y += tHeight;
                                --end;
                            }
                        }

                        nextDrawPt.Y += (tHeight * spaceRate);
                        adjust = true;

                    }
                    else if (drawCharacter[index].Pos.Y == 0)
                    {
                        // ͊ɁA̍sɃr邽߂̍sԂݒς
                        for (i = index; i < drawCharacter.Count; ++i)
                        {
                            foreach (ILetterDeta rubiChar in drawCharacter[i].RubiChara)
                            {
                                rubiChar.Pos.Y -= tHeight;
                            }
                        }
                    }
                    break;

                case 3:	// <select,str,str>
                    if (null == tagStr || 3 > tagParam.Length)
                    {
                        return false;
                    }
                    SelectTagInfo tagInfo = new SelectTagInfo();
                    String selectText = tagParam[1];
                    tagInfo.NextSceneId = tagParam[2];
                    if (null == tagInfo.NextSceneId)
                    {
                        return false;
                    }

                    if (SelectTagInfo.Pos < 0)
                    {
                        SelectTagInfo.Pos = drawCharacter.Count;
                    }

                    tagInfo.Texture = GetInnerFontRepository().GetTexture(selectText, 0);
                    tagInfo.Width = (int)tagInfo.Texture.Width;
                    tagInfo.Height = (int)tagInfo.Texture.Height;
                    tagInfo.X = (int)nextDrawPt.X;
                    tagInfo.Y = (int)nextDrawPt.Y;

                    nextDrawPt.X = 0;
                    nextDrawPt.Y += tagInfo.Height;

                    selectTagInfo.Add(tagInfo);
                    break;

                case 4: // <font>
                    //					    printf("----------------- find font tag ------------------\n");
                    fontInfos.Add(CreateFontTagInfo(tagParam));
                    break;

                case 5: // </font>
                    // pop

                    // IȃX^bNȂ΁A
                    if (fontInfos.Count >= 2)
                    {
                        fontInfos.RemoveAt(fontInfos.Count - 1);
                        //						    fontInfos.Count = fontInfos.Count - 1; 
                    }
                    else
                    {
                        //						    Log.printWarn("</font> appeared before <font>");
                    }

                    break;
                default:
                    //					    assert(false);
                    break;
            }

            return true;
        }

        /// <summary>
        /// u,vZp[^Ń^O𕪊A󔒂菜ĕԋp
        /// </summary>
        /// <param name="tag"></param>
        /// <returns></returns>
        protected static String[] SplitTag(String tag)
        {
            char[] sep = { ',' };
            String[] tagParam = tag.Split(sep);
            for (int i = 0; i < tagParam.Length; i++)
            {
                tagParam[i] = tagParam[i].Trim().ToLower();
            }
            return tagParam;
        }

        /// <summary>
        /// ^O擾
        /// </summary>
        /// <param name="currentPos"></param>
        /// <returns></returns>
        private String GetTagString(ref int currentPos)
        {
            int startpos = currentPos;
            while (true)
            {
                if (currentPos >= pageText.Length)
                {
                    throw new YanesdkException(this, "^OĂȂ");
                }
                char wc = pageText[currentPos];
                if (wc == '>')
                {
                    break;
                }
                currentPos++;
            }
            return pageText.Substring(startpos, currentPos - startpos);
        }

        protected virtual ILetterDeta CreateDrawLetter()
        {
            return new DrawLetter();
        }

        protected virtual Object GetLetterImg(char c)
        {
            return GetInnerFontRepository().GetTexture(c, 0);
        }

        protected virtual Object GetRubiLetterImg(char c)
        {
            return RubiFontRepository.GetTexture(c, 0);
        }

        protected virtual float GetImgObjWidth(Object imgObj)
        {
            return ((ITexture)imgObj).Width;
        }

        protected virtual float GetImgObjHeight(Object imgObj)
        {
            return ((ITexture)imgObj).Height;
        }

        /// <summary>
        /// obNOƒʏ`ł́AFontRepository؂ւB
        /// ȂƁAʏ@ obNOʏ탂[hɕƂ
        /// |WgύXĂ邽߂ɁA\łȂłĂB
        /// </summary>
        /// <returns></returns>
        protected virtual FontRepository GetInnerFontRepository()
        {
            return backLogMode ? backlogFontRep : TextFontRepository;
        }
    }

    /// <summary>
    /// 摜f[^SurfaceɂĎĂScenarioParser
    /// </summary>
    public class ScenarioParserSurface : ScenarioParser
    {
        /// <summary>
        /// `敶̃f[^NX(Surface)
        /// </summary>
        public class DrawLetterSurface : ScenarioParser.DrawLetter
        {
            #region otB[h

            Surface surface;

            #endregion

            public Surface Surface
            {
                get { return surface; }
                set { surface = value; }
            }

            public override Object ImgObj
            {
                get
                {
                    return Surface;
                }
                set
                {
                    Surface = value as Surface;
                }
            }

            public override float ImgObjWidth
            {
                get
                {
                    return Surface.Width;
                }
            }

            public override float ImgObjHeight
            {
                get
                {
                    return Surface.Height;
                }
            }

        }


        #region 萔l

        private static readonly string[] TAGS = {
		    "br", 		// s
		    "space", 	// 󔒍s
		    "rubi",		// r
		    "******",	// I͖
		    "font",		// tHgJn
		    "/font"		// tHgI
        };

        #endregion

        #region otB[h

        private SurfaceFontRepository fontrep; 		//	tHg
        private SurfaceFontRepository rubifontrep;		// rtHg
        //private SurfaceFontRepository backlogFontRep;	// obNOptHg

        #endregion

        /// RXgN^
        public ScenarioParserSurface()
        {
            fontrep = new SurfaceFontRepository(null);
            rubifontrep = new SurfaceFontRepository(null);
        }

        ///	̕`
        /**
            Color4ubw肵Ă΁A̐Fɕψڂ̂`悳
        */
        public void OnPaint(Surface dst, int x, int y)
        {
            ScenarioOnPaint(dst, base.DrawCharacterData, x, y);
        }
        ///	̕`
        /**
            Color4ubw肵Ă΁A̐Fɕψڂ̂`悳
        */
        public static void ScenarioOnPaint(Surface dst, List<ILetterDeta> src, int x, int y)
        {
            foreach (ILetterDeta d in src)
            {
                DrawLetterSurface drawLetter = d as DrawLetterSurface;
                if (drawLetter == null)
                {
                    continue;
                }
                dst.Blt(drawLetter.Surface, (int)(drawLetter.Pos.X + x), (int)(drawLetter.Pos.Y + y), 0);
            }
        }

        public SurfaceFontRepository GetSurfaceFontRepository() { return fontrep; }
        public SurfaceFontRepository GetRubiSurfaceFontRepository() { return rubifontrep; }
        //public SurfaceFontRepository GetBackLogSurfaceFontRepository() { return backlogFontRep; }

        protected override ILetterDeta CreateDrawLetter()
        {
            return new DrawLetterSurface();
        }

        protected override Object GetLetterImg(char c)
        {
            return fontrep.GetSurface(c, 0);
        }

        protected override Object GetRubiLetterImg(char c)
        {
            return rubifontrep.GetSurface(c, 0);
        }

        protected override float GetImgObjWidth(Object imgObj)
        {
            return ((Surface)imgObj).Width;
        }
        protected override float GetImgObjHeight(Object imgObj)
        {
            return ((Surface)imgObj).Height;
        }

        /// Lȃ^Oԋp
        public override string[] EnableTags
        {
            get { return TAGS; }
        }
    }

}
