using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Sdl;

namespace Yamalib.Yanesdkext.System
{
    /// <summary>
    /// SDLWindowgƂɂ́AbZ[WpumpȂ
    /// ȂBpumpsȂ߂framework
    /// </summary>
    /// <code>
    /// while (sdlFrame.PollEvent() == YanesdkResult.NoError
    ///     && !info.taskController.End)
    /// {
    ///     info.taskController.CallTask(info);
    /// }
    /// sdlFrame.Quit();
    /// </code>
    public class SDLFrameEx
    {
        /// <summary>
        /// SDLWindowpꍇ́AKIɂĂяoƁB
        /// </summary>
        /// <returns></returns>
        public static YanesdkResult PollEvent()
        {
            //	Application.DoEvents(); // ĂȂWindow؂ւł悤(?)
            #region 
            /*

146 i}GF@2006/04/04() 12:17 [*.yournet.ne.jp] [Opera8.53/WindowsXP]

IMEo[^XNo[oA\ɂ邩A
ڍׂȃeLXgT[rXItɂ邩ŉނłB 

150 i}GFavin@2006/04/04() 14:37 [*.ocn.ne.jp] [MSIE6.0/WindowsXP]

>>149
FXmFĂ݂܂ɓ삵Ă悤łB
Ă݂܂łiGL`j
͉̌ƂƂŁA͂ĂFlL܂m(_ _)m
*/
            #endregion

            unsafe
            {
                wheelup = wheeldown = false;
                SDL.SDL_Event evt = new SDL.SDL_Event();
                while (SDL.SDL_PollEvent(ref evt) != 0)
                {
                    if (evt.type == SDL.SDL_QUIT)
                    {
                        return YanesdkResult.ShouldBeQuit;
                    }

                    switch (evt.type)
                    {
                        case (byte)SDL.SDL_MOUSEBUTTONDOWN:
                            switch (evt.button.button)
                            {
                                case 4:
                                    wheelup = true;
                                    break;
                                case 5:
                                    wheeldown = true;
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default:
                            break;
                    }
                }
                return YanesdkResult.NoError;
            }
        }

        private static bool wheelup;
        private static bool wheeldown;

        public static bool IsWheelUp
        {
            get
            {
                return wheelup;
            }
        }

        public static bool IsWheelDown
        {
            get
            {
                return wheeldown;
            }
        }

        /// <summary>
        /// IƂɌĂяoBISDL.QuitĂяoĂB
        /// MacOS̏ꍇ͕KĂяoKvB
        /// </summary>
        /// <returns></returns>
        public static void Quit()
        {
            SDL.SDL_Quit();

            if (Yanesdk.System.Platform.IsMac)
                Yanesdk.Sdl.MacAPI.MacAPI.ExitToShell();
        }
    }
}
