module kyojintati4d.component.ending.floatagetexture;

private import y4d_draw.drawbase;
private import y4d_draw.screen;
private import y4d_draw.texture;
private import ytl.y4d_result;


/** なんらかのアクションを行う動作定義するインターフェース */
interface Moment {
	/** 移動処理 */
	y4d_result act(DrawInfo drawInfo);
	
	/** 初期状態に戻す */
	void reset();

	/** 逆に動かす */
	void reverse(bool value);
	
	/** リバースモードか？ */
	bool isReverse();
}

/** 描画するときの情報 */
public class DrawInfo {
	/** 描画色の設定/取得 (アルファ値もここで設定する) */
	Color4ub* color() {
		return m_color;
	}
	Color4ub* color(Color4ub* value) {
		return m_color = value;
	}
	
	/** 描画位置のX */
	float x() {
		return m_x;
	}
	float x(float value) {
		return m_x = value;
	}

	/** 描画位置のY */
	float y() {
		return m_y;
	}
	float y(float value) {
		return m_y = value;
	}
	
	/** 描画するときの拡大率 */
	float rate() {
		return m_rate;
	}
	float rate(float value) {
		return m_rate = value;
	}
	
	/** 描画するときの回転角 */
	float rad() {
		return m_rad;
	}
	float rad(float value) {
		return m_rad = value;
	}

	/** 描画するとき「拡大率が1.0」でない、または「回転角が0」ときに使用する描画位置オフセット */
	int drawOffset() {
		return m_drawOffset;
	}
	int drawOffset(int value) {
		return m_drawOffset = value;
	}
	
	/** 初期状態に戻す */
	void reset() {
		m_x = 0;	// 描画位置
		m_y = 0;
		m_rate = 1.0f;	// 拡大率
		m_rad = 0;	// 回転角度
		m_drawOffset = 0;
	}
	
private:
	Color4ub* m_color = null;	// 描画色
	float m_x = 0;	// 描画位置
	float m_y = 0;
	float m_rate = 1.0f;	// 拡大率
	float m_rad = 0;	// 回転角度
	int m_drawOffset = 0;
}


/**
 *  浮遊するテクスチャクラス
 */
public class FloatageTexture {
	
	/** コンストラクタ */
	this() {
		m_drawInfo = new DrawInfo();
	}
	
	/** テクスチャの設定/取得 */
	Texture texture() {
		return m_texture;
	}
	Texture texture(Texture value) {
		return m_texture = value;
	}
	
	/** 描画情報を取得 */
	DrawInfo drawInfo() {
		return m_drawInfo;
	}
	
	/** モーメントの設定/取得 */
	Moment[] moments() {
		return m_moments;
	}
	Moment[] moments(Moment[] value) {
		return m_moments = value;
	}
	
	/** オブジェクトプールに対応させる */
	void reset() {
		foreach (moment;m_moments) {
			moment.reset();
		}
		m_drawInfo.reset();
	}

	/** 移動処理を行います */
	y4d_result onMove(Screen screen) {
		// モーメントによって動作させる
		foreach (moment;m_moments) {
			moment.act(m_drawInfo);
		}
		
		return y4d_result.no_error;
	}
	
	
	/** 描画処理を行います */
	y4d_result onDraw(Screen screen) {
		if (screen is null || texture is null) {
			return y4d_result.invalid_parameter;
		}
		draw(screen, m_texture, m_drawInfo);
		return y4d_result.no_error;
	}
	
private:
	
	/** 指定した情報で描画する */
	static y4d_result draw(Screen screen, Texture texture, DrawInfo drawInfo) {
		// 変なのよこすな...
		if (screen is null || texture is null || drawInfo is null) {
			return y4d_result.invalid_parameter;
		}
		
		// ScreenColorのバックアップはしないよ...
		if (drawInfo.color !is null) {
			screen.setColor(*drawInfo.color);
		} else {
			screen.setColor(255,255,255,255);
		}

		if (drawInfo.rad != 0 || drawInfo.rate != 0.0f) {
			screen.bltRotate(texture, cast(int) drawInfo.x, cast(int) drawInfo.y, 
					cast(int) drawInfo.rad, drawInfo.rate, drawInfo.drawOffset);
		} else {
			screen.blt(texture, cast(int) drawInfo.x, cast(int) drawInfo.y);
		}
		return y4d_result.no_error;
	}
	
private:
	Texture m_texture;
	DrawInfo m_drawInfo;	// 瞬間の描画設定値を保存
	Moment[] m_moments;
	
}