﻿module y4d_input.key;

private import y4d_input.virtualkey;
private import y4d_input.joystick;
private import y4d_input.keyboardinput;

///	上下左右＋２ボタンのゲーム用　仮想キー設定済みクラス。
/**
　　キーデバイス登録済み、仮想キー設定済みのクラスです。
	ＫｅｙＢｏａｒｄ　＋　ＪｏｙＳｔｉｃｋ判定
<PRE>
ボタン番号
０：ＥＳＣキー
１：テンキー８，↑キー，ジョイスティック↑
２：テンキー２，↓キー，ジョイスティック↓
３：テンキー４，←キー，ジョイスティック←
４：テンキー２，→キー，ジョイスティック→
５：スペースキー，ジョイスティック　ボタン１
６：テンキーEnter,リターンキー，左シフト，右シフト。ジョイスティック　ボタン２

使用例)
//	(メインとしてSDLのフレームを用いる場合)
int main(){
	if(SDL_Init(SDL_INIT_VIDEO)<0) {
		printf("failed to initialize SDL.\n");
		return -1;
	}

	SDL_SetVideoMode(640,480,16,SDL_SWSURFACE);

	Key1 key = new Key1;

	while(1){
		SDL_Event event;
		while(SDL_PollEvent(&event))
			if(event.type==SDL_QUIT)
			{ 	SDL_Quit(); return 0; }
		// ゲームならここで何か処理する

		key.update();

		for(int i=0;i<7;++i){
			printf("%d ",key.isPress(i));
		}
		printf("\n");
	}
</PRE>
*/
class Key1 : VirtualKey {

	///	コンストラクタで仮想キーの登録を行なう
	this() {
		keyboard = new KeyBoardInput;
		joystick = new JoyStick(0);

		addDevice(keyboard);
		addDevice(joystick);

		//	0	:	Escape
		addKey(0,0,KeyCode.ESCAPE);

		//	1	:	Up
		addKey(1,0,KeyCode.KP8);
		addKey(1,0,KeyCode.UP);
		addKey(1,1,0);

		//	2	:	Down
		addKey(2,0,KeyCode.KP2);
		addKey(2,0,KeyCode.DOWN);
		addKey(2,1,1);

		//	3	:	Left
		addKey(3,0,KeyCode.KP4);
		addKey(3,0,KeyCode.LEFT);
		addKey(3,1,2);

		//	4	:	Right
		addKey(4,0,KeyCode.KP6);
		addKey(4,0,KeyCode.RIGHT);
		addKey(4,1,3);

		//	5	:	Space
		addKey(5,0,KeyCode.SPACE);
		addKey(5,1,4);

		//	6	:	Return
		addKey(6,0,KeyCode.RETURN);
		addKey(6,0,KeyCode.KP_ENTER);
		addKey(6,0,KeyCode.LSHIFT);
		addKey(6,0,KeyCode.RSHIFT);
		addKey(6,1,5);
	}

private:
	KeyBoardInput keyboard;
	JoyStick joystick;
}

///	上下左右＋６ボタンのゲーム用　仮想キー設定済みクラス。
/**
ＫｅｙＢｏａｒｄ　＋　ＪｏｙＳｔｉｃｋ判定
→　Key1も参照のこと。
<PRE>
こちらは、上下左右＋６ボタンのゲーム用

ボタン配置：
０：ＥＳＣキー,ジョイスティック　ボタン７，８，９
１：テンキー８，↑キー，ジョイスティック↑
２：テンキー２，↓キー，ジョイスティック↓
３：テンキー４，←キー，ジョイスティック←
４：テンキー２，→キー，ジョイスティック→
５：スペースキー，Ｚキー，ジョイスティック　ボタン１
６：テンキーEnter,リターンキー，Ｘキー，ジョイスティック　ボタン２
７：Ｃキー，ジョイスティック　ボタン３
８：Ａキー，ジョイスティック　ボタン４
９：Ｓキー，ジョイスティック　ボタン５
１０：Ｄキー，ジョイスティック　ボタン６
</PRE>
*/
class Key2 : VirtualKey {

	///	コンストラクタで仮想キーの登録を行なう
	this() {
		keyboard = new KeyBoardInput;
		joystick = new JoyStick(0);

		addDevice(keyboard);
		addDevice(joystick);

		//	0	:	Escape
		addKey(0,0,KeyCode.ESCAPE);
		addKey(0,1,10);
		addKey(0,1,11);
		addKey(0,1,12);

		//	1	:	Up
		addKey(1,0,KeyCode.KP8);
		addKey(1,0,KeyCode.UP);
		addKey(1,1,0);

		//	2	:	Down
		addKey(2,0,KeyCode.KP2);
		addKey(2,0,KeyCode.DOWN);
		addKey(2,1,1);

		//	3	:	Left
		addKey(3,0,KeyCode.KP4);
		addKey(3,0,KeyCode.LEFT);
		addKey(3,1,2);

		//	4	:	Right
		addKey(4,0,KeyCode.KP6);
		addKey(4,0,KeyCode.RIGHT);
		addKey(4,1,3);

		//	5	:	Space
		addKey(5,0,KeyCode.SPACE);
		addKey(5,0,KeyCode.z);
		addKey(5,1,4);

		//	6	:	Return
		addKey(6,0,KeyCode.RETURN);
		addKey(6,0,KeyCode.KP_ENTER);
		addKey(6,0,KeyCode.LSHIFT);
		addKey(6,0,KeyCode.RSHIFT);
		addKey(6,0,KeyCode.x);
		addKey(6,1,5);

		//	7	:	Button C
		addKey(7,0,KeyCode.c);
		addKey(7,1,6);

		//	8	:	Button A
		addKey(8,0,KeyCode.a);
		addKey(8,1,7);

		//	9	:	Button S
		addKey(9,0,KeyCode.s);
		addKey(9,1,8);

		//	10	:	Button D
		addKey(10,0,KeyCode.d);
		addKey(10,1,9);

	}

private:
	KeyBoardInput keyboard;
	JoyStick joystick;
}


///	Key1 から、ジョイスティックサポートを取り除いたもの。
class Key3 : VirtualKey {

	///	コンストラクタで仮想キーの登録を行なう
	this() {
		keyboard = new KeyBoardInput;

		addDevice(keyboard);

		//	0	:	Escape
		addKey(0,0,KeyCode.ESCAPE);

		//	1	:	Up
		addKey(1,0,KeyCode.KP8);
		addKey(1,0,KeyCode.UP);

		//	2	:	Down
		addKey(2,0,KeyCode.KP2);
		addKey(2,0,KeyCode.DOWN);

		//	3	:	Left
		addKey(3,0,KeyCode.KP4);
		addKey(3,0,KeyCode.LEFT);

		//	4	:	Right
		addKey(4,0,KeyCode.KP6);
		addKey(4,0,KeyCode.RIGHT);

		//	5	:	Space
		addKey(5,0,KeyCode.SPACE);

		//	6	:	Return
		addKey(6,0,KeyCode.RETURN);
		addKey(6,0,KeyCode.KP_ENTER);
		addKey(6,0,KeyCode.LSHIFT);
		addKey(6,0,KeyCode.RSHIFT);
	}

private:
	KeyBoardInput keyboard;
}

///	Key2 から、ジョイスティックサポートを取り除いたもの。
class Key4 : VirtualKey {

	///	コンストラクタで仮想キーの登録を行なう
	this() {
		keyboard = new KeyBoardInput;

		addDevice(keyboard);

		//	0	:	Escape
		addKey(0,0,KeyCode.ESCAPE);

		//	1	:	Up
		addKey(1,0,KeyCode.KP8);
		addKey(1,0,KeyCode.UP);

		//	2	:	Down
		addKey(2,0,KeyCode.KP2);
		addKey(2,0,KeyCode.DOWN);

		//	3	:	Left
		addKey(3,0,KeyCode.KP4);
		addKey(3,0,KeyCode.LEFT);

		//	4	:	Right
		addKey(4,0,KeyCode.KP6);
		addKey(4,0,KeyCode.RIGHT);

		//	5	:	Space
		addKey(5,0,KeyCode.SPACE);
		addKey(5,0,KeyCode.z);

		//	6	:	Return
		addKey(6,0,KeyCode.RETURN);
		addKey(6,0,KeyCode.KP_ENTER);
		addKey(6,0,KeyCode.LSHIFT);
		addKey(6,0,KeyCode.RSHIFT);
		addKey(6,0,KeyCode.x);

		//	7	:	Button C
		addKey(7,0,KeyCode.c);

		//	8	:	Button A
		addKey(8,0,KeyCode.a);

		//	9	:	Button S
		addKey(9,0,KeyCode.s);

		//	10	:	Button D
		addKey(10,0,KeyCode.d);
	}

private:
	KeyBoardInput keyboard;
}
