﻿module y4d_math.round;

///	丸めに関するテンプレート
template round(T) {
/**
	丸め(四捨五入)つきの右シフト
		tをnRShiftCountだけ右シフトして返す

正と負の対称性を考えると、負数に関しては四捨五入の“入”
の場合は 0から遠い方の整数に行って欲しい気がします。
負数の四捨五入について議論されるのをほとんど見たことが
無いのですが、そのほうが自然でしょう。ここで四捨五入
と言うとき、この定義に基づくものとします。また、
この定義に基づくと、-3.5は四捨五入されて-4になるべきで
しょうし、-3.4ならば四捨五入の“捨”で、-3になるべきです。

逆にこうならなければ、sin,cosで円を描くときに非対称(3.5は
4になるのに-3.5は-4になる)ので歪んだものになる可能性があります。
*/
	
	
T RShift(T t,int nRShiftCount)
{
	T r;
	r = t + (nRShiftCount<=0?0:(cast(T)1) << (nRShiftCount-1))
		- !(t >= 0);
	r >>= nRShiftCount;
	return r;
}

   

/**
	丸め(四捨五入)つきの割り算
		r = x/yを返す
	xが負数のときも正しく答えが返る
<PRE>
	round.Div(4/3) = 1 , round.Div(-4,3) = -1
	round.Div(3/2) = 2 , round.Div(-3,2) = -2(-1ではないことに注意)
</PRE>
*/
T Div(T x,T y)
{
	T r;
	if (x>=0)
		r = ( x + (y>>1) ) / y;
	else
		r = ( x - (y>>1) ) / y;
	return r;
}
}
