﻿module ytl.singleton;

//	double checked lockingだとJavaのようなメモリモデルで失敗する
//	http://www-6.ibm.com/jp/developerworks/java/020726/j_j-dcl.html
//	ので、double checked lockingはあきらめたほうがよさげ．．

/+
template singleton(T) {
///	singletonの実体
class singleton {
public:
	static T get() {
		if (!t) {
			synchronized {
				if (!t) t = new T;
			}
		}
		return t;
	}
private:
	static T t;
}}
+/

//template singleton(T)
///	singletonテンプレート
/**
	アプリケーションに唯一のオブジェクトを生成する。
	最初に参照されたときにインスタンスを生成する。

	foo_classに対するsingletonなオブジェクトを作成するには、
		foo_class get_foo_class() {
			return singleton!(foo_class).get();
		}
	のような取得関数を用意さえすれば、ok。
*/
//{
///	singletonの実体
class singleton(T) {
	static T get() {
		synchronized {
			if(!me) { me = new T; }
		}
		return me;
	}
	static T me;
		
	static ~this() {
		me = null;
	}
}//}
