﻿module yamalib.draw.texturaltextdraw;

private import y4d;
private import yamalib.counterfsp;

/// テクスチャのテキストを段落順に表示していきます
class TexutralTextDraw {
	
	/// 表示するテクスチャの設定
	void setTexture(Texture t_) {
		texture = t_;
		
		// テクスチャのサイズを保存
		tx = cast(int) t_.getWidth();
		ty = cast(int) t_.getHeight();
		
		// カウンターセット
		counter.set(0, tx, 1);
	}
	
	/// テキストの一行の高さを設定します
	void setLineHeight(int lineHeight_) {
		lineHeight = lineHeight_;
	}
	
	/// 描画位置の設定
	void setXY(int x_, int y_) {
		x = x_;
		y = y_;
	}
	
	/// 描画位置の取得
	void getXY(out int x_, out int y_) {
		x_ = x;
		y_ = y;
	}
	
	/// 毎回呼び出すなり
	void onMove(Screen screen) {
		if (texture == null || drawEnd) return;
		
		counter.incS();
		
		if ( counter.isLapAround() ) {
			++drawedLine;
			// 描画は終了したか？			
			if ( drawedLine * lineHeight > ty ) {
				drawEnd = true;
			}
			counter.reset();
		}
	}
	
	/// 表示速度の設定
	void setStep(int n) {
		counter.setStep(n);
	}
	
	/// 毎回呼び出すなり
	void onDraw(Screen screen) {
		// テクスチャセットしてけれ
		if (texture == null) return;

		Rect rc;
		// 描画
		if (drawedLine > 0) {
			rc.left = 0;
			rc.right = tx;
			rc.top = 0;
			rc.bottom = drawedLine * lineHeight;
			
			screen.blt(texture,x,y, &rc);	
		}
		
		rc.top = drawedLine * lineHeight;
		rc.left = 0;
		rc.right = counter.get();
		rc.bottom = rc.top + lineHeight;
		
		if (rc.bottom > ty) {
			rc.bottom = ty;
		} 
		
		screen.blt(texture, x, y + drawedLine * lineHeight, &rc);
	}
	
	/// 描画か完了したか？
	bool isEnd() {
		return drawEnd;
	}
	
	/// リセット
	void reset() {
		drawEnd = false;
		drawedLine = 0;
	}
	
	/// コンストラクタ
	this() {
		counter = new RootCounter();
	}
	
private:
	Texture texture;
	int tx;	// テクスチャサイズ
	int ty;
	int x;
	int y;
	int drawedLine;
	bool drawEnd;
	RootCounter counter;
	int lineHeight;	

}