﻿/+
module kyojintati4d.taskmovie;

private import SDL;
private import SDL_smpeg;
private import opengl;
private import y4d;
private import y4d_aux.filesys;
private import kyojintati4d.myapp;
private import kyojintati4d.gameinfo;
private import yamalib.log.log;

class TaskMovie : GameTaskBase {

	/// タスク名を返却する
	/**
		このタスク名称を使って、コントローラ部でタスク判別を行う可能性があるので
		ユニークな名前で、実装しておくべきである
	*/	
	override char[] getTaskName() {
		with (kyojintati4d.val.kyojinconst) {
			return KyojinConst.TASK_NAME[KyojinConst.Task.Task_Movie];
		}
	}

	/// 移動の処理を行います
	override int onMove(Object o) {
		return 0;
	}

	/// 描画の処理を行います
	override int onDraw(Object o) {
		try {
			info = cast(GameInfo)o;
	
			if (!init) {
				init = true;
				onInit();
			}
	
			if (SMPEG_status(smpeg) == SMPEG_PLAYING) {
			} else {
			}
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onMove : [%s] [%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	/// メインタスク
	override int task(Object o) {
		try {
			info = cast(GameInfo)o;
	
			if (!init) {
				init = true;
				onInit();
			}
	
			if (SMPEG_status(smpeg) == SMPEG_PLAYING) {
			} else {
			}
	
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onMove : [%s] [%s]", super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	/// 占有しているメモリを解放する
	override void destroy() {

		Log.print("%s#destroy : destroyed.", super.toString());
	}

	/// コンストラクタ
	this() {
	}

private:

	/// 初期化
	void onInit() {
		// メモリー状況をプリント
		GameInfo.printMemoryState();

		smpeg = SMPEG_new(FileSys.makeFullName("kyojin.mpeg"),&smpeg_info,1);
		Log.print("INPUT:%s", SMPEG_error(smpeg));

		SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
		SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);
		SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);
		SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);
		SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
		SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);
		scr = SDL_SetVideoMode(640, 480, 16, SDL_SWSURFACE);
		glEnable(GL_TEXTURE_2D);

		SMPEG_setdisplay(smpeg, scr, null, null);

		SMPEG_play(smpeg);
	}

private:
	GameInfo info;
	SDL_Surface* scr;
	bool init = false;
	SMPEG* smpeg;
	SMPEG_Info smpeg_info;


}
+/



///+
module kyojintati4d.taskmovie;

private import std.thread;

private import SDL;

private import y4d;
private import y4d_aux.filesys;

private import kyojintati4d.myapp;
private import kyojintati4d.gameinfo;

private import yamalib.draw.movie;
private import yamalib.log.log;

class TaskMovie : GameTaskBase {

	/// タスク名を返却する
	/**
		このタスク名称を使って、コントローラ部でタスク判別を行う可能性があるので
		ユニークな名前で、実装しておくべきである
	*/	
	override char[] getTaskName() {
		with (kyojintati4d.val.kyojinconst) {
			return KyojinConst.TASK_NAME[KyojinConst.Task.Task_Movie];
		}
	}

	/// 移動の処理を行います
	override int onMove(Object o) {
		return 0;
	}
	
	ulong count = 0;
	/// 描画の処理を行います
	override int onDraw(Object o) {
		try {
			info = cast(GameInfo)o;
	
			if (!init) {
				init = true;
				onInit();
			}
			info.screen.clear();
			
			if (movie.isReadyToDraw) 
			{
				movie.draw(viewTexture);
				info.screen.blt(viewTexture,0,0);
			}
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onDraw : [%s] [%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	/// メインタスク
	override int task(Object o) {
		try {
			info = cast(GameInfo)o;
	
			if (!init) {
				init = true;
				onInit();
			}
	
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#task : [%s] [%s]", super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	/// 占有しているメモリを解放する
	override void destroy() {
		if (movie !is null) {
			movie.release();
		}
		Log.print("%s#destroy : destroyed.", super.toString());
	}

	/// コンストラクタ
	this() {
	}

private:

	/// 初期化
	void onInit() {
		// メモリー状況をプリント
		GameInfo.printMemoryState();
		

		Log.print("create Instance");
		movie = new Movie();
		Log.print("load movie file");
		if (y4d_result.no_error != movie.load("kyojin.mpeg") ) {;
			Log.printError("load error");
		}
		viewTexture = new Texture();
//		viewTexture.disableAlpha();
		Log.print("set texture");
		viewTexture.setSurface(movie.surface.clone());
		Log.print("set loop true");
		movie.isLoop = true;
		Log.print("play movie");
		movie.play();
		movie.volume = 0.1;
		
//		Thread.getThis.setPriority(Thread.PRIORITY.IDLE);
		
		Log.print("onInit finish");
	}

private:
	GameInfo info;
	bool init = false;
	
	Movie movie;
	Texture viewTexture; 

}

//+/
