﻿module y4d_aux.gameframe;

private import SDL;
private import ytl.y4d_result;

///	ゲームで用いると便利なフレームクラス
class GameFrame {

	///	SDLのイベントをpollする
	/**
		windowsで言うところのメッセージポンプ。
		これを行なわないと、画面が更新されなかったり、キー入力を
		受け付けてくれなかったりする。
	<PRE>
		使用例)
		int main(){
			while (!GameFrame.pollEvent()){
				//	1フレーム分の処理
			}
			return 0;
		}
	</PRE>
	*/
	static y4d_result pollEvent() {
		SDL_Event event;
		wheelup = wheeldown = false;
		while(SDL_PollEvent(&event)) {
			if(event.type==SDL_QUIT)
				return y4d_result.should_be_quit;

			switch(event.type) {

			case SDL_MOUSEBUTTONDOWN:
				switch(event.button.button) {
				case 4:
					wheelup = true;
					break;
				case 5:
					wheeldown = true;
					break;
				default:
					wheelup = wheeldown = false;
					break;
				}
				break;

			default:
				break;
			}
		}
		return y4d_result.no_error;
	}

	static bool isWheelUp() {
		return wheelup;
	}

	static bool isWheelDown() {
		return wheeldown;
	}

protected:
	static bool wheelup;
	static bool wheeldown;
}
