﻿module ytl.struct2class;

///	structをclassに見せかけるためのテンプレート
/**
	必要性:
		structをテンプレートに渡す場合、
<PRE>
		T t;
		if (!t) t = new T;
</PRE>
		のような構文において、Tがstructだと、tは参照ではないため、
		!tを正しく判定できない。また、newを行なってそれを代入することも
		出来ない。そのため、structをclassにwrapして、渡してやる必要が
		生じるのである。<BR>

	※　boxing早くサポートして！(つД`) > D言語
*/
class struct2class(T) {
	this() { t = new T; }
	~this(){ t = null; }

	///	getter
	T* get() { return t; }	//	setする必要はないと思われ

private:
	T* t; // struct実体
}
