/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.ByteUtils;

public final class IntegerUtils {
    public static final long UNSIGNED_MAX_VALUE = -1L;

    public static int parseInt(String intStr, int dflt) {
        if (intStr == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public static int parseInt(String intStr, int radix, int dflt) {
        if (intStr == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(intStr, radix);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public static int intFromByteArray(byte[] bytes, int offset) {
        int out = 0;
        out |= ByteUtils.toUnsigned(bytes[offset + 0]) << 24;
        out |= ByteUtils.toUnsigned(bytes[offset + 1]) << 16;
        out |= ByteUtils.toUnsigned(bytes[offset + 2]) << 8;
        return out |= ByteUtils.toUnsigned(bytes[offset + 3]) << 0;
    }

    public static byte[] byteArrayFromInt(int i) {
        byte[] out = new byte[4];
        IntegerUtils.intIntoByteArray(i, 0, out);
        return out;
    }

    public static void intIntoByteArray(int i, int offset, byte[] bytes) {
        bytes[offset + 0] = (byte)(i >>> 24 & 0xFF);
        bytes[offset + 1] = (byte)(i >>> 16 & 0xFF);
        bytes[offset + 2] = (byte)(i >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(i >>> 0 & 0xFF);
    }

    public static long toUnsigned(int i) {
        return i < 0 ? 0L + (long)i : (long)i;
    }

    private IntegerUtils() {
    }
}

