/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.fantasy_isle;

import static com.l2jserver.gameserver.util.GameTimeFunction.gameTimeHourToRealMilli;
import static com.l2jserver.gameserver.util.GameTimeFunction.timeLeftMilli;

import java.text.SimpleDateFormat;
import java.util.Map;

import javolution.util.FastMap;
import ai.npc.AbstractNpcAI;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;

/**
 * MC Show AI.
 * @author Kerberos
 */
public class MC_Show extends AbstractNpcAI
{
	private static final int SHOWSTUFF_A = 32424, SHOWSTUFF_B = 32425, SHOWSTUFF_C = 32426, SHOWSTUFF_D = 32427, SHOWSTUFF_E = 32428;
	private static final int SINGER_A =32431, SINGER_B = 32432;
	private static final int MC = 32433;
	private static final int INDIVIDUAL_A = 32439, INDIVIDUAL_B = 32440, INDIVIDUAL_C = 32441;
	private static final int CIRCUS_A = 32442, CIRCUS_B = 32443, CIRCUS_C = 32444, CIRCUS_D = 32445, CIRCUS_E = 32446;
	private static boolean isStarted = false;
	private static final NpcStringId
		MESSAGES_0_  = NpcStringId.HOW_COME_PEOPLE_ARE_NOT_HERE_WE_ARE_ABOUT_TO_START_THE_SHOW_HMM,
		MESSAGES_1_  = NpcStringId.UGH_I_HAVE_BUTTERFLIES_IN_MY_STOMACH_THE_SHOW_STARTS_SOON,
		MESSAGES_2_  = NpcStringId.THANK_YOU_ALL_FOR_COMING_HERE_TONIGHT,
		MESSAGES_3_  = NpcStringId.IT_IS_AN_HONOR_TO_HAVE_THE_SPECIAL_SHOW_TODAY,
		MESSAGES_4_  = NpcStringId.FANTASY_ISLE_IS_FULLY_COMMITTED_TO_YOUR_HAPPINESS,
		MESSAGES_5_  = NpcStringId.NOW_ID_LIKE_TO_INTRODUCE_THE_MOST_BEAUTIFUL_SINGER_IN_ADEN_PLEASE_WELCOMELEYLA_MIRA,
		MESSAGES_6_  = NpcStringId.HERE_SHE_COMES,
		MESSAGES_7_  = NpcStringId.THANK_YOU_VERY_MUCH_LEYLA,
		MESSAGES_8_  = NpcStringId.NOW_WERE_IN_FOR_A_REAL_TREAT,
		MESSAGES_8a_ = NpcStringId.JUST_BACK_FROM_THEIR_WORLD_TOUR_PUT_YOUR_HANDS_TOGETHER_FOR_THE_FANTASY_ISLE_CIRCUS,
		MESSAGES_9_  = NpcStringId.COME_ON_EVERYONE,
		MESSAGES_10_ = NpcStringId.DID_YOU_LIKE_IT_THAT_WAS_SO_AMAZING,
		MESSAGES_11_ = NpcStringId.NOW_WE_ALSO_INVITED_INDIVIDUALS_WITH_SPECIAL_TALENTS,
		MESSAGES_12_ = NpcStringId.LETS_WELCOME_THE_FIRST_PERSON_HERE,
		MESSAGES_13_ = NpcStringId.OH,
		MESSAGES_14_ = NpcStringId.OKAY_NOW_HERE_COMES_THE_NEXT_PERSON_COME_ON_UP_PLEASE,
		MESSAGES_15_ = NpcStringId.OH_IT_LOOKS_LIKE_SOMETHING_GREAT_IS_GOING_TO_HAPPEN_RIGHT,
		MESSAGES_16_ = NpcStringId.OH_MY,
		MESSAGES_17_ = NpcStringId.THATS_G_GREAT_NOW_HERE_COMES_THE_LAST_PERSON,
		MESSAGES_18_ = NpcStringId.NOW_THIS_IS_THE_END_OF_TODAYS_SHOW,
		MESSAGES_19_ = NpcStringId.HOW_WAS_IT_I_HOPE_YOU_ALL_ENJOYED_IT,
		MESSAGES_20_ = NpcStringId.PLEASE_REMEMBER_THAT_FANTASY_ISLE_IS_ALWAYS_PLANNING_A_LOT_OF_GREAT_SHOWS_FOR_YOU,
		MESSAGES_21_ = NpcStringId.WELL_I_WISH_I_COULD_CONTINUE_ALL_NIGHT_LONG_BUT_THIS_IS_IT_FOR_TODAY_THANK_YOU,
		MESSAGES_22_ = NpcStringId.WE_LOVE_YOU
	;
	
	private class ShoutInfo
	{
		private final NpcStringId _npcStringId;
		private final String _nextEvent;
		private final int _time;
		
		public ShoutInfo(NpcStringId npcStringId, String nextEvent, int time)
		{
			_npcStringId = npcStringId;
			_nextEvent = nextEvent;
			_time = time;
		}
		
		/**
		 * @return the _npcStringId
		 */
		public NpcStringId getNpcStringId()
		{
			return _npcStringId;
		}
		
		/**
		 * @return the _nextEvent
		 */
		public String getNextEvent()
		{
			return _nextEvent;
		}
		
		/**
		 * @return the _time
		 */
		public int getTime()
		{
			return _time;
		}
	}
	
	private class WalkInfo
	{
		private final L2CharPosition _charPos;
		private final String _nextEvent;
		private final int _time;
		
		public WalkInfo(int x, int y, int z, String nextEvent, int time)
		{
			_charPos = new L2CharPosition(x, y, z, 0);
			_nextEvent = nextEvent;
			_time = time;
		}
		
		/**
		 * @return the _charPos
		 */
		public L2CharPosition getCharPos()
		{
			return _charPos;
		}
		
		/**
		 * @return the _nextEvent
		 */
		public String getNextEvent()
		{
			return _nextEvent;
		}
		
		/**
		 * @return the _time
		 */
		public int getTime()
		{
			return _time;
		}
	}
	
	private static Map<String, ShoutInfo> talks = new FastMap<>();
	private static Map<String, WalkInfo> walks = new FastMap<>();
	
	private void load()
	{
		talks.put("1", new ShoutInfo(MESSAGES_1_, "2", 1000));
		talks.put("2", new ShoutInfo(MESSAGES_2_, "3", 6000));
		talks.put("3", new ShoutInfo(MESSAGES_3_, "4", 4000));
		talks.put("4", new ShoutInfo(MESSAGES_4_, "5", 5000));
		talks.put("5", new ShoutInfo(MESSAGES_5_, "6", 3000));
		talks.put("8", new ShoutInfo(MESSAGES_8_, "8a", 2500));
		talks.put("8a", new ShoutInfo(MESSAGES_8a_, "9", 2500));
		talks.put("9", new ShoutInfo(MESSAGES_9_, "10", 5000));
		talks.put("12", new ShoutInfo(MESSAGES_11_, "13", 5000));
		talks.put("13", new ShoutInfo(MESSAGES_12_, "14", 5000));
		talks.put("15", new ShoutInfo(MESSAGES_13_, "16", 5000));
		talks.put("16", new ShoutInfo(MESSAGES_14_, "17", 5000));
		talks.put("18", new ShoutInfo(MESSAGES_16_, "19", 5000));
		talks.put("19", new ShoutInfo(MESSAGES_17_, "20", 5000));
		talks.put("21", new ShoutInfo(MESSAGES_18_, "22", 5000));
		talks.put("22", new ShoutInfo(MESSAGES_19_, "23", 400));
		talks.put("25", new ShoutInfo(MESSAGES_20_, "26", 5000));
		talks.put("26", new ShoutInfo(MESSAGES_21_, "27", 5400));
		
		walks.put("npc1_1", new WalkInfo(-56546, -56384, -2008, "npc1_2", 1200));
		walks.put("npc1_2", new WalkInfo(-56597, -56384, -2008, "npc1_3", 1200));
		walks.put("npc1_3", new WalkInfo(-56596, -56428, -2008, "npc1_4", 1200));
		walks.put("npc1_4", new WalkInfo(-56593, -56474, -2008, "npc1_5", 1000));
		walks.put("npc1_5", new WalkInfo(-56542, -56474, -2008, "npc1_6", 1000));
		walks.put("npc1_6", new WalkInfo(-56493, -56473, -2008, "npc1_7", 2000));
		walks.put("npc1_7", new WalkInfo(-56495, -56425, -2008, "npc1_1", 4000));
		walks.put("npc2_1", new WalkInfo(-56550, -56291, -2008, "npc2_2", 1200));
		walks.put("npc2_2", new WalkInfo(-56601, -56293, -2008, "npc2_3", 1200));
		walks.put("npc2_3", new WalkInfo(-56603, -56247, -2008, "npc2_4", 1200));
		walks.put("npc2_4", new WalkInfo(-56605, -56203, -2008, "npc2_5", 1000));
		walks.put("npc2_5", new WalkInfo(-56553, -56202, -2008, "npc2_6", 1100));
		walks.put("npc2_6", new WalkInfo(-56504, -56200, -2008, "npc2_7", 2000));
		walks.put("npc2_7", new WalkInfo(-56503, -56243, -2008, "npc2_1", 4000));
		walks.put("npc3_1", new WalkInfo(-56500, -56290, -2008, "npc3_2", 1200));
		walks.put("npc3_2", new WalkInfo(-56551, -56313, -2008, "npc3_3", 1200));
		walks.put("npc3_3", new WalkInfo(-56601, -56293, -2008, "npc3_4", 1200));
		walks.put("npc3_4", new WalkInfo(-56651, -56294, -2008, "npc3_5", 1200));
		walks.put("npc3_5", new WalkInfo(-56653, -56250, -2008, "npc3_6", 1200));
		walks.put("npc3_6", new WalkInfo(-56654, -56204, -2008, "npc3_7", 1200));
		walks.put("npc3_7", new WalkInfo(-56605, -56203, -2008, "npc3_8", 1200));
		walks.put("npc3_8", new WalkInfo(-56554, -56202, -2008, "npc3_9", 1200));
		walks.put("npc3_9", new WalkInfo(-56503, -56200, -2008, "npc3_10", 1200));
		walks.put("npc3_10", new WalkInfo(-56502, -56244, -2008, "npc3_1", 900));
		walks.put("npc4_1", new WalkInfo(-56495, -56381, -2008, "npc4_2", 1200));
		walks.put("npc4_2", new WalkInfo(-56548, -56383, -2008, "npc4_3", 1200));
		walks.put("npc4_3", new WalkInfo(-56597, -56383, -2008, "npc4_4", 1200));
		walks.put("npc4_4", new WalkInfo(-56643, -56385, -2008, "npc4_5", 1200));
		walks.put("npc4_5", new WalkInfo(-56639, -56436, -2008, "npc4_6", 1200));
		walks.put("npc4_6", new WalkInfo(-56639, -56473, -2008, "npc4_7", 1200));
		walks.put("npc4_7", new WalkInfo(-56589, -56473, -2008, "npc4_8", 1200));
		walks.put("npc4_8", new WalkInfo(-56541, -56473, -2008, "npc4_9", 1200));
		walks.put("npc4_9", new WalkInfo(-56496, -56473, -2008, "npc4_10", 1200));
		walks.put("npc4_10", new WalkInfo(-56496, -56429, -2008, "npc4_1", 900));
		walks.put("npc5_1", new WalkInfo(-56549, -56335, -2008, "npc5_2", 1000));
		walks.put("npc5_2", new WalkInfo(-56599, -56337, -2008, "npc5_3", 2000));
		walks.put("npc5_3", new WalkInfo(-56649, -56341, -2008, "npc5_4", 26000));
		walks.put("npc5_4", new WalkInfo(-56600, -56341, -2008, "npc5_5", 1000));
		walks.put("npc5_5", new WalkInfo(-56553, -56341, -2008, "npc5_6", 1000));
		walks.put("npc5_6", new WalkInfo(-56508, -56331, -2008, "npc5_2", 8000));
		walks.put("npc6_1", new WalkInfo(-56595, -56428, -2008, "npc6_2", 1000));
		walks.put("npc6_2", new WalkInfo(-56596, -56383, -2008, "npc6_3", 1000));
		walks.put("npc6_3", new WalkInfo(-56648, -56384, -2008, "npc6_4", 1000));
		walks.put("npc6_4", new WalkInfo(-56645, -56429, -2008, "npc6_5", 1000));
		walks.put("npc6_5", new WalkInfo(-56644, -56475, -2008, "npc6_6", 1000));
		walks.put("npc6_6", new WalkInfo(-56595, -56473, -2008, "npc6_7", 1000));
		walks.put("npc6_7", new WalkInfo(-56542, -56473, -2008, "npc6_8", 1000));
		walks.put("npc6_8", new WalkInfo(-56492, -56472, -2008, "npc6_9", 1200));
		walks.put("npc6_9", new WalkInfo(-56495, -56426, -2008, "npc6_10", 2000));
		walks.put("npc6_10", new WalkInfo(-56540, -56426, -2008, "npc6_1", 3000));
		walks.put("npc7_1", new WalkInfo(-56603, -56249, -2008, "npc7_2", 1000));
		walks.put("npc7_2", new WalkInfo(-56601, -56294, -2008, "npc7_3", 1000));
		walks.put("npc7_3", new WalkInfo(-56651, -56295, -2008, "npc7_4", 1000));
		walks.put("npc7_4", new WalkInfo(-56653, -56248, -2008, "npc7_5", 1000));
		walks.put("npc7_5", new WalkInfo(-56605, -56203, -2008, "npc7_6", 1000));
		walks.put("npc7_6", new WalkInfo(-56554, -56202, -2008, "npc7_7", 1000));
		walks.put("npc7_7", new WalkInfo(-56504, -56201, -2008, "npc7_8", 1000));
		walks.put("npc7_8", new WalkInfo(-56502, -56247, -2008, "npc7_9", 1200));
		walks.put("npc7_9", new WalkInfo(-56549, -56248, -2008, "npc7_10", 2000));
		walks.put("npc7_10", new WalkInfo(-56549, -56248, -2008, "npc7_1", 3000));
		walks.put("npc8_1", new WalkInfo(-56493, -56426, -2008, "npc8_2", 1000));
		walks.put("npc8_2", new WalkInfo(-56497, -56381, -2008, "npc8_3", 1200));
		walks.put("npc8_3", new WalkInfo(-56544, -56381, -2008, "npc8_4", 1200));
		walks.put("npc8_4", new WalkInfo(-56596, -56383, -2008, "npc8_5", 1200));
		walks.put("npc8_5", new WalkInfo(-56594, -56428, -2008, "npc8_6", 900));
		walks.put("npc8_6", new WalkInfo(-56645, -56429, -2008, "npc8_7", 1200));
		walks.put("npc8_7", new WalkInfo(-56647, -56384, -2008, "npc8_8", 1200));
		walks.put("npc8_8", new WalkInfo(-56649, -56362, -2008, "npc8_9", 9200));
		walks.put("npc8_9", new WalkInfo(-56654, -56429, -2008, "npc8_10", 1200));
		walks.put("npc8_10", new WalkInfo(-56644, -56474, -2008, "npc8_11", 900));
		walks.put("npc8_11", new WalkInfo(-56593, -56473, -2008, "npc8_12", 1100));
		walks.put("npc8_12", new WalkInfo(-56543, -56472, -2008, "npc8_13", 1200));
		walks.put("npc8_13", new WalkInfo(-56491, -56471, -2008, "npc8_1", 1200));
		walks.put("npc9_1", new WalkInfo(-56505, -56246, -2008, "npc9_2", 1000));
		walks.put("npc9_2", new WalkInfo(-56504, -56291, -2008, "npc9_3", 1200));
		walks.put("npc9_3", new WalkInfo(-56550, -56291, -2008, "npc9_4", 1200));
		walks.put("npc9_4", new WalkInfo(-56600, -56292, -2008, "npc9_5", 1200));
		walks.put("npc9_5", new WalkInfo(-56603, -56248, -2008, "npc9_6", 900));
		walks.put("npc9_6", new WalkInfo(-56653, -56249, -2008, "npc9_7", 1200));
		walks.put("npc9_7", new WalkInfo(-56651, -56294, -2008, "npc9_8", 1200));
		walks.put("npc9_8", new WalkInfo(-56650, -56316, -2008, "npc9_9", 9200));
		walks.put("npc9_9", new WalkInfo(-56660, -56250, -2008, "npc9_10", 1200));
		walks.put("npc9_10", new WalkInfo(-56656, -56205, -2008, "npc9_11", 900));
		walks.put("npc9_11", new WalkInfo(-56606, -56204, -2008, "npc9_12", 1100));
		walks.put("npc9_12", new WalkInfo(-56554, -56203, -2008, "npc9_13", 1200));
		walks.put("npc9_13", new WalkInfo(-56506, -56203, -2008, "npc9_1", 1200));
		walks.put("24", new WalkInfo(-56730, -56340, -2008, "25", 1800));
		walks.put("27", new WalkInfo(-56702, -56340, -2008, "29", 1800));
	}
	
	private MC_Show(String name, String descr)
	{
		super(name, descr);
		addSpawnId(MC, SINGER_A, SINGER_B, CIRCUS_A, CIRCUS_B, CIRCUS_C, CIRCUS_D, CIRCUS_E, SHOWSTUFF_A, SHOWSTUFF_B, SHOWSTUFF_C, SHOWSTUFF_D, SHOWSTUFF_E);
		load();
		scheduleTimer();
	}
	
	private void scheduleTimer()
	{
		final long diff = timeLeftMilli(8, 0, 0, 6), cycle = gameTimeHourToRealMilli(6); // (lԂ800JnA6ԂƌJԂ)
//		final long diff = timeLeftMilli(20, 30, 0, 24), cycle = gameTimeHourToRealMilli(24); // {Idl(lԂ2030JnA24ԂƌJԂ)
		ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new StartMCShow(), diff, cycle);
		if (Config.DEBUG)
		{
			SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
			_log.info("Fantasy Isle: MC show script starting at " + format.format(System.currentTimeMillis() + diff) + " and is scheduled each next " + (cycle / 3600000) + " hours.");
		}
	}
	
	private void autoChat(L2Npc npc, NpcStringId npcString, int type)
	{
		npc.broadcastPacket(new NpcSay(npc.getObjectId(), type, npc.getNpcId(), npcString));
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		if (isStarted)
		{
			switch (npc.getNpcId())
			{
				case MC:
					autoChat(npc, MESSAGES_0_, Say2.NPC_SHOUT);
					startQuestTimer("1", 30000, npc, null);
					break;
				case SINGER_A:
					npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56657, -56338, -2008, 33102));
					startQuestTimer("social1", 6000, npc, null, true);
					startQuestTimer("7", 215000, npc, null);
					break;
				case SINGER_B:
					startQuestTimer("social1", 6000, npc, null, true);
					startQuestTimer("7", 215000, npc, null);
					break;
				case CIRCUS_A:
				case CIRCUS_B:
				case CIRCUS_C:
				case CIRCUS_D:
				case CIRCUS_E:
					startQuestTimer("11", 100000, npc, null);
					break;
				case SHOWSTUFF_A:
				case SHOWSTUFF_B:
				case SHOWSTUFF_C:
				case SHOWSTUFF_D:
				case SHOWSTUFF_E:
					startQuestTimer("social1", 5500, npc, null);
					startQuestTimer("social1", 12500, npc, null);
					startQuestTimer("28", 19700, npc, null);
					break;
			}
		}
		return super.onSpawn(npc);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event.equals/*IgnoreCase*/("Start"))
		{
			load();	//+[JOJO]
			isStarted = true;
			com.l2jserver.gameserver.Announcements.getInstance().announceToAll("݂Ȃ`Az̓̃Xe[WőfGȃVEn܂\u2764"); // [JOJO]
			addSpawn(MC, -56698, -56430, -2008, 32768, false, 0);
		}
		else if (npc != null && ! npc.isDecayed())	//+[JOJO]
	//	else if (npc != null && isStarted)			//-[JOJO]
		{
			if (event == "6") // C~Jn (215b)
			{
				autoChat(npc, MESSAGES_6_, Say2.NPC_SHOUT);
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56511, -56647, -2008, 36863));
				npc.broadcastPacket(new PlaySound(1, "NS22_F", 0, 0, 0, 0, 0));
				addSpawn(SINGER_A, -56344, -56328, -2008, 32768, false, 224000);
				addSpawn(SINGER_B, -56552, -56245, -2008, 36863, false, 224000);
				addSpawn(SINGER_B, -56546, -56426, -2008, 28672, false, 224000);
				addSpawn(SINGER_B, -56570, -56473, -2008, 28672, false, 224000);
				addSpawn(SINGER_B, -56594, -56516, -2008, 28672, false, 224000);
				addSpawn(SINGER_B, -56580, -56203, -2008, 36863, false, 224000);
				addSpawn(SINGER_B, -56606, -56157, -2008, 36863, false, 224000);
				startQuestTimer("7", 215000, npc, null);
			}
			else if (event == "7") // C~I
			{
				switch (npc.getNpcId())
				{
					case MC:
						autoChat(npc, MESSAGES_7_, Say2.NPC_SHOUT);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56698, -56430, -2008, 32768));
						startQuestTimer("8", 12000, npc, null);
						break;
					default:
						cancelQuestTimer("social1", npc, null);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56594, -56064, -2008, 32768));
						break;
				}
			}
			else if (event == "10") // T[JXJn (100b)
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56483, -56665, -2034, 32768));
				npc.broadcastPacket(new PlaySound(1, "TP05_F", 0, 0, 0, 0, 0));
				startQuestTimer("npc1_1", 3000, addSpawn(CIRCUS_A, -56495, -56375, -2008, 32768, false, 101000), null);
				startQuestTimer("npc2_1", 3000, addSpawn(CIRCUS_A, -56491, -56289, -2008, 32768, false, 101000), null);
				startQuestTimer("npc3_1", 3000, addSpawn(CIRCUS_B, -56502, -56246, -2008, 32768, false, 101000), null);
				startQuestTimer("npc4_1", 3000, addSpawn(CIRCUS_B, -56496, -56429, -2008, 32768, false, 101000), null);
				startQuestTimer("npc5_1", 3500, addSpawn(CIRCUS_C, -56505, -56334, -2008, 32768, false, 101000), null);
				startQuestTimer("npc6_1", 4000, addSpawn(CIRCUS_D, -56545, -56427, -2008, 32768, false, 101000), null);
				startQuestTimer("npc7_1", 4000, addSpawn(CIRCUS_D, -56552, -56248, -2008, 32768, false, 101000), null);
				startQuestTimer("npc8_1", 3000, addSpawn(CIRCUS_E, -56493, -56473, -2008, 32768, false, 101000), null);
				startQuestTimer("npc9_1", 3000, addSpawn(CIRCUS_E, -56504, -56201, -2008, 32768, false, 101000), null);
				startQuestTimer("11", 100000, npc, null);
			}
			else if (event == "11") // T[JXI
			{
				switch (npc.getNpcId())
				{
					case MC:
						autoChat(npc, MESSAGES_10_, Say2.NPC_SHOUT);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56698, -56430, -2008, 32768));
						startQuestTimer("12", 5000, npc, null);
						break;
					default:
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56343, -56330, -2008, 32768));
						break;
				}
			}
			else if (event == "14")
			{
				startQuestTimer("social1", 2000, addSpawn(INDIVIDUAL_A, -56700, -56385, -2008, 32768, false, 49000), null);
				startQuestTimer("15", 7000, npc, null);
			}
			else if (event == "17")
			{
				autoChat(npc, MESSAGES_15_, Say2.NPC_SHOUT);
				startQuestTimer("social1", 2000, addSpawn(INDIVIDUAL_B, -56700, -56340, -2008, 32768, false, 32000), null);
				startQuestTimer("18", 9000, npc, null);
			}
			else if (event == "20")
			{
				startQuestTimer("social1", 2000, addSpawn(INDIVIDUAL_C, -56703, -56296, -2008, 32768, false, 13000), null);
				startQuestTimer("21", 8000, npc, null);
			}
			else if (event == "23") // X^bt
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56702, -56340, -2008, 32768));
				startQuestTimer("24", 2800, npc, null);
				addSpawn(SHOWSTUFF_A, -56672, -56406, -2000, 32768, false, 20900);
				addSpawn(SHOWSTUFF_B, -56648, -56368, -2000, 32768, false, 20900);
				addSpawn(SHOWSTUFF_C, -56608, -56338, -2000, 32768, false, 20900);
				addSpawn(SHOWSTUFF_D, -56652, -56307, -2000, 32768, false, 20900);
				addSpawn(SHOWSTUFF_E, -56672, -56272, -2000, 32768, false, 20900);
			}
			else if (event == "28")
			{
				autoChat(npc, MESSAGES_22_/*"We love you."*/, Say2.NPC_ALL);
				startQuestTimer("social1", 1, npc, null);
			}
			else if (event == "29")
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56730, -56340, -2008, 32768));
				startQuestTimer("clean_npc", 4100, npc, null);
			/*	startQuestTimer("timer_check", 60000, null, null, true);	*/	//-[JOJO]
			}
			else if (event == "social1")
			{
				npc.broadcastSocialAction(1);
			}
			else if (event == "clean_npc")
			{
				isStarted = false;
				npc.deleteMe();
			}
			else
			{
				ShoutInfo si;
				WalkInfo wi;
				if ((si = talks.get(event)) != null)
				{
					autoChat(npc, si.getNpcStringId(), Say2.NPC_SHOUT);
					startQuestTimer(si.getNextEvent(), si.getTime(), npc, null);
				}
				else if ((wi = walks.get(event)) != null)
				{
					npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, wi.getCharPos());
					startQuestTimer(wi.getNextEvent(), wi.getTime(), npc, null);
				}
				else								//+[JOJO]
					throw new RuntimeException();	//+[JOJO]
			}
		}
		return null;
	}
	
	public static void main(String[] args)
	{
		new MC_Show(MC_Show.class.getSimpleName(), "ai");
	}
}

/**
  F
    Q[Ԃł"24"́AłSԁB܂U{B
    T[oN "6"ɐݒ肳B
    Xe[W͂܂"2030"́AT[oNĂ"1430"Ȃ̂ŁA
    ɊZ(UŊ)QԂQTB

    p[h̓Q[Ԃ
      2:00A8:00A14:00A20:00 ̂PSAUԂƂɂȂB
    Xe[W
      20:30 ̂P̂݁B
*/
