/*
 * Copyright (C) 2004-2013 L2J Server
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;

/**
 * NPC that gives information about territory wars
 * @author GodKratos
 */
public class L2MercenaryManagerInstance extends L2Npc
{
	// private int[] TW_BADGE_IDS = { 13757, 13758, 13759, 13760, 13761, 13762, 13763, 13764, 13765 };
	/**
	 * @param objectId
	 * @param template
	 */
	public L2MercenaryManagerInstance(int objectId, L2NpcTemplate template)
	{
		super(objectId, template);
		setInstanceType(InstanceType.L2MercenaryManagerInstance);
	}
	
	@Override
	public void showChatWindow(L2PcInstance player)
	{
		if ((player.getLevel() < 40) || (player.getClassId().level() < 2))
		{
			super.showChatWindow(player, 2);
		}
		else if (TerritoryWarManager.getInstance().isTWInProgress())
		{
			super.showChatWindow(player, 10);
		}
		else
		{
			super.showChatWindow(player, 0);
		}
	}
	
	@Override
	public String getHtmlPath(int npcId, int val)
	{
		return getHtmlPath("data/html/mercmanager/", npcId, val, null);
	/*	String temp = "";
		if (val == 0)
		{
			temp = "data/html/mercmanager/" + npcId + ".htm";
		}
		else
		{
			temp = "data/html/mercmanager/" + npcId + "-" + val + ".htm";
		}
		
		if (!Config.LAZY_CACHE)
		{
			// If not running lazy cache the file must be in the cache or it doesnt exist
			if (HtmCache.getInstance().contains(temp))
			{
				return temp;
			}
		}
		else
		{
			if (HtmCache.getInstance().isLoadable(temp))
			{
				return temp;
			}
		}
		
		// If the file is not found, the standard message "I have nothing to say to you" is returned
		return "data/html/npcdefault.htm";	*/
	}
}
