/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyFrame;
import org.python.core.PyObject;

public class PyTraceback
extends PyObject {
    public PyObject tb_next;
    public PyFrame tb_frame;
    public int tb_lineno;

    public PyTraceback(PyFrame pyFrame) {
        this.tb_frame = pyFrame;
        if (this.tb_frame != null) {
            this.tb_lineno = this.tb_frame.getline();
        }
        this.tb_next = Py.None;
    }

    public PyTraceback(PyTraceback pyTraceback) {
        this.tb_next = pyTraceback;
        if (pyTraceback != null) {
            this.tb_frame = pyTraceback.tb_frame.f_back;
            this.tb_lineno = this.tb_frame.getline();
        }
    }

    private String line() {
        if (this.tb_frame == null || this.tb_frame.f_code == null) {
            return "  (no code object) at line " + this.tb_lineno + "\n";
        }
        return "  File \"" + this.tb_frame.f_code.co_filename + "\", line " + this.tb_lineno + ", in " + this.tb_frame.f_code.co_name + "\n";
    }

    public void dumpStack(StringBuffer stringBuffer) {
        stringBuffer.append(this.line());
        if (this.tb_next != Py.None && this.tb_next != this) {
            ((PyTraceback)this.tb_next).dumpStack(stringBuffer);
        } else if (this.tb_next == this) {
            stringBuffer.append("circularity detected!" + this + this.tb_next);
        }
    }

    public String dumpStack() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Traceback (innermost last):\n");
        this.dumpStack(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        return "<traceback object at  " + Py.idstr(this) + ">";
    }
}

