﻿<?php
/**
 * Changing account password module file
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountPassword.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 * @filesource
 */
 
/**
 * Module for changing account password
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountPassword.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 */
class AccountPassword extends Module
{
	/**
	 * Account wich password gonna be changed
	 */ 
	var $account;
	
	/**
	 * @var string - module output, usually HTML content
	 */
	var $output;

	var $login;
	/**
	 * Constructor loads template and starts content creation
	 */
	function AccountPassword($login)
	{
		$this->Module();		
		$this->login = $login;
		
		$this->template = temp_load($this->config->manager['template_path'].'edit_password.htm');
		$this->check_form();
		$this->output = $this->template;
	}
	
	/**
	 * Manage form data
	 */
	function check_form()
	{
		if(isset($_POST['old']) && isset($_POST['password']) && isset($_POST['password2']))
		{
			if($_POST['old']!= "" && $_POST['password']!= "" && $_POST['password2']!= "")
			{
				if($_POST['password'] == $_POST['password2'])
				{
					$this->account = new Account($this->login, $_POST['old']);
					
					if($this->account->auth()==true)
					{															
						$this->account->set_password($_POST['password']);
						$this->write_log("'{$_SESSION['login']}' changed password of ACCOUNT: '{$this->account->login}' ");
						$this->template = "<font color=red>パスワードを変更しました。</font>";						
					} else {
						$this->template = "<font color=red>現在のパスワードが一致しません。</font>".$this->template;
					}						
				} else {
					$this->template = "<font color=red>新しいパスワードが一致しません。</font>".$this->template;
				}				
			} else {
				$this->template = "<font color=red>パスワードが入力されていません。</font>".$this->template;
			}
		}
	}
		
}
?>