﻿<?php
/**
 * Character access level module class
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: CharacterAccess.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 * @filesource
 */
 
/**
 * Module for changing Character access level
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: CharacterAccess.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 */
class CharacterAccess extends Module
{
	/**
	 * Character Object
	 */
	var $character;
	
	/**
	 * @var string - module output, usually HTML content
	 */
	var $output;
	/**
	 * Constructor loads template and starts content creation
	 */
	function CharacterAccess($charId)
	{
		$this->Module();
		$this->character = new character($charId);
		$this->template = temp_load($this->config->manager['template_path'].'edit_access.htm');		
		$this->check_form();
		$this->get_current();
		$this->output = $this->template;
	}
	
	/**
	 * If form posts something then its being checked and if input is correct then
	 * access level will be changed.
	 */
	function check_form()
	{		
		if(isset($_POST['access']))
		{
			if(is_numeric($_POST['access']))
			{
				if($_POST['access'] <= 999 && $_POST['access'] >= -999)
				{
					$this->character->get();
					$this->character->set_access($_POST['access']);
					$this->write_log("'{$_SESSION['login']}' changed access of CHARACTER: '{$this->character->char_name}' from {$this->character->accesslevel} to {$_POST['access']}");
				} else {
					$this->template = "<font color=red>アクセスレベルは-999から999の間でなければなりません。</font>".$this->template;
				}
			} else {
				$this->template = "<font color=red>あなたが入力した値は数字ではありません。</font>".$this->template;
			}
		}
	}
	
	/**
	 * Gets current access level for displaying and fills that place in template
	 */
	function get_current()
	{
		$q = mysql_query("SELECT * FROM characters WHERE charId = '{$this->character->charId}'");
		$r = mysql_fetch_array($q);

		$r['access_level'] = $r['accesslevel'];
		$this->template = temp_subs($this->template, "account", $r);
	}
}
?>