/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async.test;

import com.mchange.v2.async.RoundRobinAsynchronousRunner;
import com.mchange.v2.lang.ThreadUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InterruptTaskThread {
    static Set interruptedThreads = Collections.synchronizedSet(new HashSet());

    public static void main(String[] argv) {
        try {
            RoundRobinAsynchronousRunner runner = new RoundRobinAsynchronousRunner(5, false);
            new Interrupter().start();
            for (int i = 0; i < 1000; ++i) {
                try {
                    runner.postRunnable(new DumbTask());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Thread.sleep(50L);
            }
            System.out.println("Interrupted Threads: " + interruptedThreads.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class DumbTask
    implements Runnable {
        static int count = 0;

        DumbTask() {
        }

        static synchronized int number() {
            return count++;
        }

        public void run() {
            try {
                Thread.sleep(200L);
                System.out.println("DumbTask complete! " + DumbTask.number());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class Interrupter
    extends Thread {
        Interrupter() {
        }

        public void run() {
            try {
                while (true) {
                    Thread[] fillMe = new Thread[1000];
                    ThreadUtils.enumerateAll(fillMe);
                    int i = 0;
                    while (fillMe[i] != null) {
                        if (fillMe[i].getName().indexOf("RunnableQueue.TaskThread") >= 0) {
                            fillMe[i].interrupt();
                            System.out.println("INTERRUPTED!");
                            interruptedThreads.add(fillMe[i]);
                            break;
                        }
                        ++i;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

