/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import java.util.Map;

import ai.group_template.L2AttackableAIScript;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo.NpcInfo;

/**
 * Gordon AI
 * @author TOFIZ
 */
public class Gordon extends L2AttackableAIScript
{
	private static final boolean VISUALIZE_WALKS = false;
	
	private static final int GORDON = 29095;
	private static int _npcMoveX = 0;
	private static int _npcMoveY = 0;
	private static int _walkTo = 0;
	private static int _npcBlock = 0;
	private static final L2CharPosition[] WALKS = 
	{
		new L2CharPosition(141569, -45908, -2387, 0),
		new L2CharPosition(142494, -45456, -2397, 0),
		new L2CharPosition(142922, -44561, -2395, 0),
		new L2CharPosition(143672, -44130, -2398, 0),
		new L2CharPosition(144557, -43378, -2325, 0),
		new L2CharPosition(145839, -43267, -2301, 0),
		new L2CharPosition(147044, -43601, -2307, 0),
		new L2CharPosition(148140, -43206, -2303, 0),
		new L2CharPosition(148815, -43434, -2328, 0),
		new L2CharPosition(149862, -44151, -2558, 0),
		new L2CharPosition(151037, -44197, -2708, 0),
		new L2CharPosition(152555, -42756, -2836, 0),
		new L2CharPosition(154808, -39546, -3236, 0),
		new L2CharPosition(155333, -39962, -3272, 0),
		new L2CharPosition(156531, -41240, -3470, 0),
		new L2CharPosition(156863, -43232, -3707, 0),
		new L2CharPosition(156783, -44198, -3764, 0),
		new L2CharPosition(158169, -45163, -3541, 0),
		new L2CharPosition(158952, -45479, -3473, 0),
		new L2CharPosition(160039, -46514, -3634, 0),
		new L2CharPosition(160244, -47429, -3656, 0),
		new L2CharPosition(159155, -48109, -3665, 0),
		new L2CharPosition(159558, -51027, -3523, 0),
		new L2CharPosition(159396, -53362, -3244, 0),
		new L2CharPosition(160872, -56556, -2789, 0),
		new L2CharPosition(160857, -59072, -2613, 0),
		new L2CharPosition(160410, -59888, -2647, 0),
		new L2CharPosition(158770, -60173, -2673, 0),
		new L2CharPosition(156368, -59557, -2638, 0),
		new L2CharPosition(155188, -59868, -2642, 0),
		new L2CharPosition(154118, -60591, -2731, 0),
		new L2CharPosition(153571, -61567, -2821, 0),
		new L2CharPosition(153457, -62819, -2886, 0),
		new L2CharPosition(152939, -63778, -3003, 0),
		new L2CharPosition(151816, -64209, -3120, 0),
		new L2CharPosition(147655, -64826, -3433, 0),
		new L2CharPosition(145422, -64576, -3369, 0),
		new L2CharPosition(144097, -64320, -3404, 0),
		new L2CharPosition(140780, -61618, -3096, 0),
		new L2CharPosition(139688, -61450, -3062, 0),
		new L2CharPosition(138267, -61743, -3056, 0),
		new L2CharPosition(138613, -58491, -3465, 0),
		new L2CharPosition(138139, -57252, -3517, 0),
		new L2CharPosition(139555, -56044, -3310, 0),
		new L2CharPosition(139107, -54537, -3240, 0),
		new L2CharPosition(139279, -53781, -3091, 0),
		new L2CharPosition(139810, -52687, -2866, 0),
		new L2CharPosition(139657, -52041, -2793, 0),
		new L2CharPosition(139215, -51355, -2698, 0),
		new L2CharPosition(139334, -50514, -2594, 0),
		new L2CharPosition(139817, -49715, -2449, 0),
		new L2CharPosition(139824, -48976, -2263, 0),
		new L2CharPosition(140130, -47578, -2213, 0),
		new L2CharPosition(140483, -46339, -2382, 0),
	};
	
	public Gordon(int id, String name, String descr)
	{
		super(id, name, descr);
		int[] mobs =
		{
			GORDON
		};
		registerMobs(mobs, QuestEventType.ON_KILL, QuestEventType.ON_SPAWN);
if (!com.l2jserver.Config.FIX_onSpawn_for_SpawnTable) {{
		L2Npc gordon = findTemplate(GORDON);
		if (gordon != null)
		{
			onSpawn(gordon);
		}
}}
	}
	
	public L2Npc findTemplate(int npcId)
	{
		L2Npc npc = null;
if (!com.l2jserver.Config.FIX_onSpawn_for_SpawnTable) {{
		for (L2Spawn spawn : SpawnTable.getInstance().getSpawnTable())
		{
			if (spawn != null && spawn.getNpcid() == npcId)
			{
				npc = spawn.getLastSpawn();
				break;
			}
		}
}}
		return npc;
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		onAdvEvent:
		if (event == "Start")
		{
			if (!npc.isVisible() || npc.isDead())
				break onAdvEvent;
			
			// check if player have Cursed Weapon and in radius
			Map<Integer, L2PcInstance> knownPlayers = npc.getKnownList().getKnownPlayers();
			if (knownPlayers.size() > 0)
			{
				for (L2PcInstance pc : knownPlayers.values())
				{
					if (pc.isCursedWeaponEquipped() && pc.isInsideRadius(npc, 5000, false, false))
					{
						if (npc.getTargetId() != pc.getObjectId() || !npc.hasAI() || npc.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK)
						{
							npc.setRunning();
							((L2Attackable) npc).addDamageHate(pc, 0, 9999);
							npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, pc);
						}
						break onAdvEvent;
					}
				}
			}
			// end check
			
			if (npc.hasAI() && npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_ATTACK || npc.isMovementDisabled())
			{
				_npcBlock = 0;
				break onAdvEvent;
			}
			
			L2CharPosition loc = WALKS[_walkTo];
			long distance = (long)npc.getPlanDistanceSq(loc.x, loc.y);
			
			if (distance <= (50 * 50))
			{
				_walkTo = (_walkTo + 1) % WALKS.length;
				loc = WALKS[_walkTo];
			//	distance = (long)npc.getPlanDistanceSq(loc.x, loc.y);
				npc.setWalking();
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, loc);
				break onAdvEvent;
			}
			
			// Test for unblock Npc
			if (npc.getX() != _npcMoveX || npc.getY() != _npcMoveY)
			{
				_npcMoveX = npc.getX();
				_npcMoveY = npc.getY();
				_npcBlock = 0;
				break onAdvEvent;
			}
			if (++_npcBlock >= 3)
			{
				npc.teleToLocation(loc.x, loc.y, loc.z);
			}
			else
			{
				//-------------------------------------------------------
				// oOH hCA[h[c  J[X tBA[ȂǂsƂAS[hubNĂ܂Ƃ̂ŋATTACK.
				if (npc.isInCombat() && npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO)
				{
					L2Character target = npc.getAI().getAttackTarget();
					if (target != null)
					{
						npc.setRunning();
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
						break onAdvEvent;
					}
				}
				//-------------------------------------------------------
				if (distance > (15000 * 15000))
				{
					npc.teleToLocation(loc.x, loc.y, loc.z);
				}
				else if (distance > (7500 * 7500))
				{
					npc.setRunning();
					npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, loc);
				}
				else
				{
					npc.setWalking();
					npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, loc);
				}
			}
			break onAdvEvent;
			// End Test unblock Npc
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		if (!npc.isTeleporting())
		{
			_walkTo = 0;
			((L2Attackable)npc).setCanReturnToSpawnPoint(false);
			startQuestTimer("Start", 1000, npc, null, true);
		}
		return super.onSpawn(npc);
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		cancelQuestTimer("Start", npc, null);
		return super.onKill(npc, killer, isPet);
	}
	
	/**
	 * DEBUG
	 */
	@SuppressWarnings("unused")
	private void visualizeWALKS(L2PcInstance player)
	{
if (VISUALIZE_WALKS) {{
		final int npcId = 1032467;
		
		for (int e = 0; e < WALKS.length; e++) {
			final L2CharPosition route = WALKS[e];
			final L2CharPosition next  = WALKS[(e + 1) % WALKS.length];

			final int x1 = route.x, y1 = route.y, z1 = route.z;
			L2Npc n = super.addSpawn(npcId, x1, y1, z1, 0, false, 3600000L);
			n.setTitle("#"+e);
			n.broadcastPacket(new NpcInfo(n, null));

			final double dx = next.x - x1, dy = next.y - y1, dz = next.z - z1;
			final double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
			final double pitch = 50;
			for (double p = pitch; p < distance; p += pitch) {
				double a = p / distance;
				int x = x1 + (int)Math.round(dx * a);
				int y = y1 + (int)Math.round(dy * a);
				int z = z1 + (int)Math.round(dz * a) + 20;
				L2ItemInstance i = new L2ItemInstance(IdFactory.getInstance().getNextId(), 57);
				if (player != null) i.setOwnerId(player.getObjectId());
				i.new ItemDropTask(i, null, x, y, z).run();
				i.setProtected(false);
				L2World.getInstance().storeObject(i);
			}
		}
}}
	}
	
	public static void main(String[] args)
	{
		new Gordon(-1, Gordon.class.getSimpleName(), "ai");
	}
}