/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.util.Rnd;

/**
 * f[ U[h} R}_[
 * Delu Lizardman Commander
 */
public class DeluLizardmanCommander extends Quest
{
	private static final int DELU_LIZARDMAN_COMMANDER = 21107;
	
	private static int[] SAY1 =
	{
		1000288,	//$s1! How dare you interrupt our fight! Hey guys, help!	$s1IזƂ͂IA݂ĂI
		1000388,	//$s1! Hey! We're having a duel here!						$s1I悭ΌWQĂꂽȁI҂߁I
	};
	
	private static int[] SAY2 =
	{
		1000389,	//The duel is over! Attack!		Έ̑Ό͏I肾IF̎ҁAĂ܂I
		1000390,	//Foul! Kill the coward!		IF̎ҁAڋ҂nI
		1000391,	//How dare you interrupt a sacred duel! You must be taught a lesson!	_ȌWQƂ́Ił͂ȂI
		1000392,	//Die, you coward!				ڋҁII
		1000393,	//What are you looking at?		ז҂͏I
		1000394,	//Kill the coward!				ڋ҂ɎI
	};
	
	public DeluLizardmanCommander(int questId, String name, String descr)
	{
		super(questId, name, descr);
		addAttackId(DELU_LIZARDMAN_COMMANDER);
		addSpellFinishedId(DELU_LIZARDMAN_COMMANDER);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		if (npc.getCurrentHp() == npc.getMaxHp())
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), SAY1[Rnd.get(SAY1.length)]).addPcName(attacker));
//		else if (Rnd.get(20) == 0)
//			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), SAY2[Rnd.get(SAY2.length)]));
		return null;
	}
	
	@Override
	public String onSpellFinished(L2Npc npc, L2PcInstance player, L2Skill skill)
	{
		if (Rnd.get(100) > npc.getSkillChance())
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), SAY2[Rnd.get(SAY2.length)]));
		return null;
	}
	
	public static void main(String[] args)
	{
		new DeluLizardmanCommander(-1, "DeluLizardmanCommander", "ai");
	}
}
